/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.callback;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import io.dropwizard.revolver.RevolverBundle;
import io.dropwizard.revolver.base.core.RevolverCallbackRequest;
import io.dropwizard.revolver.base.core.RevolverCallbackResponse;
import io.dropwizard.revolver.base.core.RevolverRequestState;
import io.dropwizard.revolver.core.config.HystrixCommandConfig;
import io.dropwizard.revolver.core.config.RevolverConfig;
import io.dropwizard.revolver.core.config.hystrix.ThreadPoolConfig;
import io.dropwizard.revolver.discovery.EndpointSpec;
import io.dropwizard.revolver.discovery.model.RangerEndpointSpec;
import io.dropwizard.revolver.discovery.model.SimpleEndpointSpec;
import io.dropwizard.revolver.http.RevolverHttpCommand;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.http.config.RevolverHttpServiceConfig;
import io.dropwizard.revolver.http.model.RevolverHttpRequest;
import io.dropwizard.revolver.http.model.RevolverHttpResponse;
import io.dropwizard.revolver.persistence.PersistenceProvider;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(CallbackHandler.class);
    private PersistenceProvider persistenceProvider;
    private RevolverConfig revolverConfig;
    private static LoadingCache<CallbackConfigKey, RevolverHttpServiceConfig> clientLoadingCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CallbackConfigKey, RevolverHttpServiceConfig>(){

        public RevolverHttpServiceConfig load(CallbackConfigKey key) throws Exception {
            return CallbackHandler.buildConfiguration(key.callbackRequest, key.uri);
        }
    });

    public void handle(String requestId) {
        RevolverCallbackRequest request = this.persistenceProvider.request(requestId);
        if (request == null) {
            log.warn("Invalid request: {}", (Object)requestId);
            return;
        }
        RevolverRequestState state = this.persistenceProvider.requestState(requestId);
        if (state == null) {
            log.warn("Invalid request state: {}", (Object)requestId);
            return;
        }
        if (state != RevolverRequestState.RESPONDED) {
            log.warn("Invalid request state {}: {}", (Object)state.name(), (Object)requestId);
            return;
        }
        if (Strings.isNullOrEmpty((String)request.getCallbackUri())) {
            log.warn("Invalid callback uri: {}", (Object)requestId);
            return;
        }
        try {
            URI uri = new URI(request.getCallbackUri());
            switch (uri.getScheme()) {
                case "https": 
                case "http": {
                    this.makeCallback(requestId, uri, request);
                    break;
                }
                case "ranger": {
                    log.warn("Ranger is not supported yet for request: {}", (Object)requestId);
                    break;
                }
                default: {
                    log.warn("Invalid protocol for request: {}", (Object)requestId);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.warn("Invalid callback uri {} for request: {}", (Object)request.getCallbackUri(), (Object)requestId);
        }
    }

    private void makeCallback(String requestId, URI uri, RevolverCallbackRequest callbackRequest) {
        CompletableFuture<Boolean> future = CompletableFuture.supplyAsync(() -> {
            RevolverCallbackResponse response = this.persistenceProvider.response(requestId);
            if (response == null) {
                log.warn("Invalid response: {}", (Object)requestId);
                return false;
            }
            try {
                RevolverHttpServiceConfig httpCommandConfig = CallbackHandler.buildConfiguration(callbackRequest, uri);
                log.info("Service config for request {} : {}", (Object)requestId, (Object)httpCommandConfig.toString());
                RevolverHttpCommand httpCommand = this.buildCommand(httpCommandConfig);
                MultivaluedHashMap requestHeaders = new MultivaluedHashMap();
                response.getHeaders().forEach((arg_0, arg_1) -> ((MultivaluedMap)requestHeaders).put(arg_0, arg_1));
                requestHeaders.remove((Object)"Host");
                RevolverHttpRequest httpRequest = RevolverHttpRequest.builder().path(uri.getRawPath()).api("callback").body(response.getBody() == null ? new byte[]{} : response.getBody()).headers((MultivaluedMap<String, String>)requestHeaders).method(RevolverHttpApiConfig.RequestMethod.valueOf(callbackRequest.getMethod())).service(httpCommandConfig.getService()).build();
                log.info("Executing callback for request: " + httpRequest.toString());
                RevolverHttpResponse httpResponse = (RevolverHttpResponse)httpCommand.execute(httpRequest);
                log.info("Callback response: " + httpResponse.toString());
                if (httpResponse.getStatusCode() >= 200 && httpResponse.getStatusCode() <= 210) {
                    log.info("Callback success: " + httpResponse.toString());
                    return true;
                }
                log.error("Error from callback host: {} | Status Code: {} | Response Body: ", new Object[]{uri.getHost(), httpResponse.getStatusCode(), httpResponse.getBody() != null ? new String(httpResponse.getBody()) : "NONE"});
                return false;
            }
            catch (MalformedURLException e) {
                log.error("Invalid callback URL: {} for request: {}", (Object)uri.toString(), (Object)requestId);
                return false;
            }
            catch (IOException e) {
                log.error("Error making callback for: {} for request: {}", (Object)uri.toString(), (Object)requestId);
                return false;
            }
            catch (CertificateException e) {
                log.error("Error making callback for: {} for request: {}", (Object)uri.toString(), (Object)requestId);
                return false;
            }
            catch (NoSuchAlgorithmException e) {
                log.error("Error making callback for: {} for request: {}", (Object)uri.toString(), (Object)requestId);
                return false;
            }
            catch (UnrecoverableKeyException e) {
                log.error("Error making callback for: {} for request: {}", (Object)uri.toString(), (Object)requestId);
                return false;
            }
            catch (KeyStoreException e) {
                log.error("Error making callback for: {} for request: {}", (Object)uri.toString(), (Object)requestId);
                return false;
            }
            catch (KeyManagementException e) {
                log.error("Error making callback for: {} for request: {}", (Object)uri.toString(), (Object)requestId);
                return false;
            }
            catch (ExecutionException e) {
                log.error("Error making callback for: {} for request: {}", (Object)uri.toString(), (Object)requestId);
                return false;
            }
            catch (TimeoutException e) {
                log.error("Error making callback for: {} for request: {}", (Object)uri.toString(), (Object)requestId);
                return false;
            }
        });
        future.thenAccept(result -> {
            if (!result.booleanValue()) {
                log.error("Error making callback for request: {}", (Object)requestId);
            } else {
                log.info("Successful callback for request: {}", (Object)requestId);
            }
        });
    }

    private static RevolverHttpServiceConfig buildConfiguration(RevolverCallbackRequest callbackRequest, URI uri) throws MalformedURLException {
        EndpointSpec endpointSpec = null;
        String apiName = "callback";
        String serviceName = uri.getHost().replace(".", "-");
        String type = null;
        switch (uri.getScheme()) {
            case "https": 
            case "http": {
                SimpleEndpointSpec simpleEndpoint = new SimpleEndpointSpec();
                simpleEndpoint.setHost(uri.getHost());
                simpleEndpoint.setPort(uri.getPort() == 0 || uri.getPort() == -1 ? 80 : uri.getPort());
                endpointSpec = simpleEndpoint;
                type = uri.getScheme();
                break;
            }
            case "ranger": {
                RangerEndpointSpec rangerEndpoint = new RangerEndpointSpec();
                String[] discoveryData = uri.getHost().split("\\.");
                if (discoveryData.length != 3) {
                    throw new MalformedURLException("Invalid ranger host format. Accepted format is environment.service.api");
                }
                rangerEndpoint.setEnvironment(discoveryData[0]);
                rangerEndpoint.setService(discoveryData[1]);
                endpointSpec = rangerEndpoint;
                type = "ranger_sharded";
                apiName = discoveryData[2];
            }
        }
        return RevolverHttpServiceConfig.builder().authEnabled(false).connectionPoolSize(10).secured(false).enpoint(endpointSpec).service(serviceName).type(type).api(RevolverHttpApiConfig.configBuilder().api(apiName).method(RevolverHttpApiConfig.RequestMethod.valueOf(callbackRequest.getHeaders().get("X-CALLBACK-METHOD").get(0))).path("").runtime(HystrixCommandConfig.builder().threadPool(ThreadPoolConfig.builder().concurrency(10).timeout(Integer.parseInt(callbackRequest.getHeaders().get("X-CALLBACK-TIMEOUT").get(0))).build()).build()).build()).build();
    }

    private RevolverHttpCommand buildCommand(RevolverHttpServiceConfig httpConfig) throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, ExecutionException {
        return RevolverHttpCommand.builder().clientConfiguration(this.revolverConfig.getClientConfig()).runtimeConfig(this.revolverConfig.getGlobal()).serviceConfiguration(httpConfig).apiConfigurations(this.generateApiConfigMap(httpConfig)).serviceResolver(RevolverBundle.getServiceNameResolver()).traceCollector(trace -> {}).build();
    }

    private Map<String, RevolverHttpApiConfig> generateApiConfigMap(RevolverHttpServiceConfig serviceConfiguration) {
        ImmutableMap.Builder configMapBuilder = ImmutableMap.builder();
        serviceConfiguration.getApis().forEach(apiConfig -> configMapBuilder.put((Object)apiConfig.getApi(), apiConfig));
        return configMapBuilder.build();
    }

    CallbackHandler(PersistenceProvider persistenceProvider, RevolverConfig revolverConfig) {
        this.persistenceProvider = persistenceProvider;
        this.revolverConfig = revolverConfig;
    }

    public static CallbackHandlerBuilder builder() {
        return new CallbackHandlerBuilder();
    }

    public PersistenceProvider getPersistenceProvider() {
        return this.persistenceProvider;
    }

    public RevolverConfig getRevolverConfig() {
        return this.revolverConfig;
    }

    public void setPersistenceProvider(PersistenceProvider persistenceProvider) {
        this.persistenceProvider = persistenceProvider;
    }

    public void setRevolverConfig(RevolverConfig revolverConfig) {
        this.revolverConfig = revolverConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CallbackHandler)) {
            return false;
        }
        CallbackHandler other = (CallbackHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PersistenceProvider this$persistenceProvider = this.getPersistenceProvider();
        PersistenceProvider other$persistenceProvider = other.getPersistenceProvider();
        if (this$persistenceProvider == null ? other$persistenceProvider != null : !this$persistenceProvider.equals(other$persistenceProvider)) {
            return false;
        }
        RevolverConfig this$revolverConfig = this.getRevolverConfig();
        RevolverConfig other$revolverConfig = other.getRevolverConfig();
        return !(this$revolverConfig == null ? other$revolverConfig != null : !this$revolverConfig.equals(other$revolverConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CallbackHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PersistenceProvider $persistenceProvider = this.getPersistenceProvider();
        result = result * 59 + ($persistenceProvider == null ? 43 : $persistenceProvider.hashCode());
        RevolverConfig $revolverConfig = this.getRevolverConfig();
        result = result * 59 + ($revolverConfig == null ? 43 : $revolverConfig.hashCode());
        return result;
    }

    public String toString() {
        return "CallbackHandler(persistenceProvider=" + this.getPersistenceProvider() + ", revolverConfig=" + this.getRevolverConfig() + ")";
    }

    public static class CallbackHandlerBuilder {
        private PersistenceProvider persistenceProvider;
        private RevolverConfig revolverConfig;

        CallbackHandlerBuilder() {
        }

        public CallbackHandlerBuilder persistenceProvider(PersistenceProvider persistenceProvider) {
            this.persistenceProvider = persistenceProvider;
            return this;
        }

        public CallbackHandlerBuilder revolverConfig(RevolverConfig revolverConfig) {
            this.revolverConfig = revolverConfig;
            return this;
        }

        public CallbackHandler build() {
            return new CallbackHandler(this.persistenceProvider, this.revolverConfig);
        }

        public String toString() {
            return "CallbackHandler.CallbackHandlerBuilder(persistenceProvider=" + this.persistenceProvider + ", revolverConfig=" + this.revolverConfig + ")";
        }
    }

    public static class CallbackConfigKey {
        private URI uri;
        private RevolverCallbackRequest callbackRequest;

        CallbackConfigKey(URI uri, RevolverCallbackRequest callbackRequest) {
            this.uri = uri;
            this.callbackRequest = callbackRequest;
        }

        public static CallbackConfigKeyBuilder builder() {
            return new CallbackConfigKeyBuilder();
        }

        public URI getUri() {
            return this.uri;
        }

        public RevolverCallbackRequest getCallbackRequest() {
            return this.callbackRequest;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }

        public void setCallbackRequest(RevolverCallbackRequest callbackRequest) {
            this.callbackRequest = callbackRequest;
        }

        public String toString() {
            return "CallbackHandler.CallbackConfigKey(uri=" + this.getUri() + ", callbackRequest=" + this.getCallbackRequest() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CallbackConfigKey)) {
                return false;
            }
            CallbackConfigKey other = (CallbackConfigKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            URI this$uri = this.getUri();
            URI other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
                return false;
            }
            RevolverCallbackRequest this$callbackRequest = this.getCallbackRequest();
            RevolverCallbackRequest other$callbackRequest = other.getCallbackRequest();
            return !(this$callbackRequest == null ? other$callbackRequest != null : !((Object)this$callbackRequest).equals(other$callbackRequest));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CallbackConfigKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            URI $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
            RevolverCallbackRequest $callbackRequest = this.getCallbackRequest();
            result = result * 59 + ($callbackRequest == null ? 43 : ((Object)$callbackRequest).hashCode());
            return result;
        }

        public static class CallbackConfigKeyBuilder {
            private URI uri;
            private RevolverCallbackRequest callbackRequest;

            CallbackConfigKeyBuilder() {
            }

            public CallbackConfigKeyBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            public CallbackConfigKeyBuilder callbackRequest(RevolverCallbackRequest callbackRequest) {
                this.callbackRequest = callbackRequest;
                return this;
            }

            public CallbackConfigKey build() {
                return new CallbackConfigKey(this.uri, this.callbackRequest);
            }

            public String toString() {
                return "CallbackHandler.CallbackConfigKey.CallbackConfigKeyBuilder(uri=" + this.uri + ", callbackRequest=" + this.callbackRequest + ")";
            }
        }
    }
}

