/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.http.config;

import io.dropwizard.revolver.core.config.CommandHandlerConfig;
import io.dropwizard.revolver.core.config.HystrixCommandConfig;
import io.dropwizard.revolver.http.config.RevolverHttpAuthorizationConfig;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

public class RevolverHttpApiConfig
extends CommandHandlerConfig {
    @NotNull
    @NotEmpty
    private String path;
    private boolean async = false;
    private boolean whitelist = false;
    @NotNull
    @NotEmpty
    private Set<RequestMethod> methods = Collections.singleton(RequestMethod.GET);
    private Set<Integer> acceptableResponseCodes = Collections.emptySet();
    private RevolverHttpAuthorizationConfig authorization = new RevolverHttpAuthorizationConfig();

    public RevolverHttpApiConfig(String api, HystrixCommandConfig runtime, String path, Set<RequestMethod> methods, Set<Integer> acceptableResponseCodes) {
        super(api, runtime);
        this.path = path;
        this.methods = methods;
        this.acceptableResponseCodes = acceptableResponseCodes;
    }

    public static RevolverHttpApiConfigBuilder configBuilder() {
        return new RevolverHttpApiConfigBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolverHttpApiConfig)) {
            return false;
        }
        RevolverHttpApiConfig other = (RevolverHttpApiConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        if (this.isAsync() != other.isAsync()) {
            return false;
        }
        if (this.isWhitelist() != other.isWhitelist()) {
            return false;
        }
        Set<RequestMethod> this$methods = this.getMethods();
        Set<RequestMethod> other$methods = other.getMethods();
        if (this$methods == null ? other$methods != null : !((Object)this$methods).equals(other$methods)) {
            return false;
        }
        Set<Integer> this$acceptableResponseCodes = this.getAcceptableResponseCodes();
        Set<Integer> other$acceptableResponseCodes = other.getAcceptableResponseCodes();
        if (this$acceptableResponseCodes == null ? other$acceptableResponseCodes != null : !((Object)this$acceptableResponseCodes).equals(other$acceptableResponseCodes)) {
            return false;
        }
        RevolverHttpAuthorizationConfig this$authorization = this.getAuthorization();
        RevolverHttpAuthorizationConfig other$authorization = other.getAuthorization();
        return !(this$authorization == null ? other$authorization != null : !((Object)this$authorization).equals(other$authorization));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RevolverHttpApiConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        result = result * 59 + (this.isAsync() ? 79 : 97);
        result = result * 59 + (this.isWhitelist() ? 79 : 97);
        Set<RequestMethod> $methods = this.getMethods();
        result = result * 59 + ($methods == null ? 43 : ((Object)$methods).hashCode());
        Set<Integer> $acceptableResponseCodes = this.getAcceptableResponseCodes();
        result = result * 59 + ($acceptableResponseCodes == null ? 43 : ((Object)$acceptableResponseCodes).hashCode());
        RevolverHttpAuthorizationConfig $authorization = this.getAuthorization();
        result = result * 59 + ($authorization == null ? 43 : ((Object)$authorization).hashCode());
        return result;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isAsync() {
        return this.async;
    }

    public boolean isWhitelist() {
        return this.whitelist;
    }

    public Set<RequestMethod> getMethods() {
        return this.methods;
    }

    public Set<Integer> getAcceptableResponseCodes() {
        return this.acceptableResponseCodes;
    }

    public RevolverHttpAuthorizationConfig getAuthorization() {
        return this.authorization;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void setWhitelist(boolean whitelist) {
        this.whitelist = whitelist;
    }

    public void setMethods(Set<RequestMethod> methods) {
        this.methods = methods;
    }

    public void setAcceptableResponseCodes(Set<Integer> acceptableResponseCodes) {
        this.acceptableResponseCodes = acceptableResponseCodes;
    }

    public void setAuthorization(RevolverHttpAuthorizationConfig authorization) {
        this.authorization = authorization;
    }

    @ConstructorProperties(value={"path", "async", "whitelist", "methods", "acceptableResponseCodes", "authorization"})
    public RevolverHttpApiConfig(String path, boolean async, boolean whitelist, Set<RequestMethod> methods, Set<Integer> acceptableResponseCodes, RevolverHttpAuthorizationConfig authorization) {
        this.path = path;
        this.async = async;
        this.whitelist = whitelist;
        this.methods = methods;
        this.acceptableResponseCodes = acceptableResponseCodes;
        this.authorization = authorization;
    }

    public RevolverHttpApiConfig() {
    }

    @Override
    public String toString() {
        return "RevolverHttpApiConfig(super=" + super.toString() + ", path=" + this.getPath() + ", async=" + this.isAsync() + ", whitelist=" + this.isWhitelist() + ", methods=" + this.getMethods() + ", acceptableResponseCodes=" + this.getAcceptableResponseCodes() + ", authorization=" + this.getAuthorization() + ")";
    }

    public static class RevolverHttpApiConfigBuilder {
        private String api;
        private HystrixCommandConfig runtime;
        private String path;
        private ArrayList<RequestMethod> methods;
        private Set<Integer> acceptableResponseCodes;

        RevolverHttpApiConfigBuilder() {
        }

        public RevolverHttpApiConfigBuilder api(String api) {
            this.api = api;
            return this;
        }

        public RevolverHttpApiConfigBuilder runtime(HystrixCommandConfig runtime) {
            this.runtime = runtime;
            return this;
        }

        public RevolverHttpApiConfigBuilder path(String path) {
            this.path = path;
            return this;
        }

        public RevolverHttpApiConfigBuilder method(RequestMethod method) {
            if (this.methods == null) {
                this.methods = new ArrayList();
            }
            this.methods.add(method);
            return this;
        }

        public RevolverHttpApiConfigBuilder methods(Collection<? extends RequestMethod> methods) {
            if (this.methods == null) {
                this.methods = new ArrayList();
            }
            this.methods.addAll(methods);
            return this;
        }

        public RevolverHttpApiConfigBuilder acceptableResponseCodes(Set<Integer> acceptableResponseCodes) {
            this.acceptableResponseCodes = acceptableResponseCodes;
            return this;
        }

        public RevolverHttpApiConfig build() {
            Set<Object> methods;
            switch (this.methods == null ? 0 : this.methods.size()) {
                case 0: {
                    methods = Collections.emptySet();
                    break;
                }
                case 1: {
                    methods = Collections.singleton(this.methods.get(0));
                    break;
                }
                default: {
                    methods = new LinkedHashSet(this.methods.size() < 0x40000000 ? 1 + this.methods.size() + (this.methods.size() - 3) / 3 : Integer.MAX_VALUE);
                    methods.addAll(this.methods);
                    methods = Collections.unmodifiableSet(methods);
                }
            }
            return new RevolverHttpApiConfig(this.api, this.runtime, this.path, methods, this.acceptableResponseCodes);
        }

        public String toString() {
            return "RevolverHttpApiConfig.RevolverHttpApiConfigBuilder(api=" + this.api + ", runtime=" + this.runtime + ", path=" + this.path + ", methods=" + this.methods + ", acceptableResponseCodes=" + this.acceptableResponseCodes + ")";
        }
    }

    public static enum RequestMethod {
        GET,
        POST,
        PUT,
        DELETE,
        HEAD,
        PATCH,
        OPTIONS;

    }
}

