/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.netflix.hystrix.contrib.codahalemetricspublisher.HystrixCodaHaleMetricsPublisher;
import com.netflix.hystrix.contrib.metrics.eventstream.HystrixMetricsStreamServlet;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisher;
import io.dropwizard.Bundle;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.assets.AssetsBundle;
import io.dropwizard.msgpack.MsgPackBundle;
import io.dropwizard.revolver.aeroapike.AerospikeConnectionManager;
import io.dropwizard.revolver.callback.CallbackHandler;
import io.dropwizard.revolver.core.RevolverExecutionException;
import io.dropwizard.revolver.core.config.AerospikeMailBoxConfig;
import io.dropwizard.revolver.core.config.InMemoryMailBoxConfig;
import io.dropwizard.revolver.core.config.RevolverConfig;
import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.discovery.RevolverServiceResolver;
import io.dropwizard.revolver.discovery.model.RangerEndpointSpec;
import io.dropwizard.revolver.discovery.model.SimpleEndpointSpec;
import io.dropwizard.revolver.exception.RevolverExceptionMapper;
import io.dropwizard.revolver.exception.TimeoutExceptionMapper;
import io.dropwizard.revolver.filters.RevolverRequestFilter;
import io.dropwizard.revolver.http.RevolverHttpCommand;
import io.dropwizard.revolver.http.auth.BasicAuthConfig;
import io.dropwizard.revolver.http.auth.TokenAuthConfig;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.http.config.RevolverHttpServiceConfig;
import io.dropwizard.revolver.http.config.RevolverHttpsServiceConfig;
import io.dropwizard.revolver.http.model.ApiPathMap;
import io.dropwizard.revolver.persistence.AeroSpikePersistenceProvider;
import io.dropwizard.revolver.persistence.InMemoryPersistenceProvider;
import io.dropwizard.revolver.persistence.PersistenceProvider;
import io.dropwizard.revolver.resource.RevolverCallbackResource;
import io.dropwizard.revolver.resource.RevolverMailboxResource;
import io.dropwizard.revolver.resource.RevolverMetadataResource;
import io.dropwizard.revolver.resource.RevolverRequestResource;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.xml.XmlBundle;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.curator.framework.CuratorFramework;
import org.msgpack.jackson.dataformat.MessagePackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RevolverBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final Logger log = LoggerFactory.getLogger(RevolverBundle.class);
    private static Map<String, RevolverHttpCommand> httpCommands = new HashMap<String, RevolverHttpCommand>();
    private static MultivaluedMap<String, ApiPathMap> serviceToPathMap = new MultivaluedHashMap();
    public static final ObjectMapper msgPackObjectMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());
    public static final XmlMapper xmlObjectMapper = new XmlMapper();
    private static RevolverServiceResolver serviceNameResolver = null;

    public void initialize(Bootstrap<?> bootstrap) {
        HystrixPlugins.reset();
        this.registerTypes(bootstrap);
        this.configureXmlMapper();
        bootstrap.addBundle((Bundle)new XmlBundle());
        bootstrap.addBundle((Bundle)new MsgPackBundle());
        bootstrap.addBundle((Bundle)new AssetsBundle("/revolver/dashboard/", "/revolver/dashboard/", "index.html"));
    }

    public void run(T configuration, Environment environment) throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        HystrixCodaHaleMetricsPublisher metricsPublisher = new HystrixCodaHaleMetricsPublisher(environment.metrics());
        HystrixPlugins.getInstance().registerMetricsPublisher((HystrixMetricsPublisher)metricsPublisher);
        this.initializeRevolver(configuration, environment);
        RevolverConfig revolverConfig = this.getRevolverConfig(configuration);
        if (Strings.isNullOrEmpty((String)revolverConfig.getHystrixStreamPath())) {
            environment.getApplicationContext().addServlet(HystrixMetricsStreamServlet.class, "/hystrix.stream");
        } else {
            environment.getApplicationContext().addServlet(HystrixMetricsStreamServlet.class, revolverConfig.getHystrixStreamPath());
        }
        environment.jersey().register((Object)new RevolverExceptionMapper());
        environment.jersey().register((Object)new TimeoutExceptionMapper());
        PersistenceProvider persistenceProvider = this.getPersistenceProvider(configuration, environment);
        CallbackHandler callbackHandler = CallbackHandler.builder().persistenceProvider(persistenceProvider).revolverConfig(revolverConfig).build();
        environment.jersey().register((Object)new RevolverRequestFilter(revolverConfig));
        environment.jersey().register((Object)new RevolverRequestResource(environment.getObjectMapper(), msgPackObjectMapper, xmlObjectMapper, persistenceProvider));
        environment.jersey().register((Object)new RevolverCallbackResource(persistenceProvider, callbackHandler));
        environment.jersey().register((Object)new RevolverMailboxResource(persistenceProvider));
        environment.jersey().register((Object)new RevolverMetadataResource(revolverConfig));
    }

    private void registerTypes(Bootstrap<?> bootstrap) {
        bootstrap.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(RevolverHttpServiceConfig.class, "http")});
        bootstrap.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(RevolverHttpsServiceConfig.class, "https")});
        bootstrap.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(BasicAuthConfig.class, "basic")});
        bootstrap.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(TokenAuthConfig.class, "token")});
        bootstrap.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(SimpleEndpointSpec.class, "simple")});
        bootstrap.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(RangerEndpointSpec.class, "ranger_sharded")});
        bootstrap.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(InMemoryMailBoxConfig.class, "in_memory")});
        bootstrap.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(AerospikeMailBoxConfig.class, "aerospike")});
    }

    private void configureXmlMapper() {
        xmlObjectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        xmlObjectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        xmlObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        xmlObjectMapper.configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, true);
        xmlObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        xmlObjectMapper.configure(ToXmlGenerator.Feature.WRITE_XML_1_1, true);
    }

    private static Map<String, RevolverHttpApiConfig> generateApiConfigMap(RevolverHttpServiceConfig serviceConfiguration) {
        serviceConfiguration.getApis().forEach(apiConfig -> serviceToPathMap.add((Object)serviceConfiguration.getService(), (Object)ApiPathMap.builder().api((RevolverHttpApiConfig)apiConfig).path(RevolverBundle.generatePathExpression(apiConfig.getPath())).build()));
        ImmutableMap.Builder configMapBuilder = ImmutableMap.builder();
        serviceConfiguration.getApis().forEach(apiConfig -> configMapBuilder.put((Object)apiConfig.getApi(), apiConfig));
        return configMapBuilder.build();
    }

    private static String generatePathExpression(String path) {
        return path.replaceAll("\\{(([^/])+\\})", "(([^/])+)");
    }

    public static ApiPathMap matchPath(String service, String path) {
        if (serviceToPathMap.containsKey((Object)service)) {
            Optional<ApiPathMap> apiMap = ((List)serviceToPathMap.get((Object)service)).stream().filter(api -> path.matches(api.getPath())).findFirst();
            return apiMap.orElse(null);
        }
        return null;
    }

    public static RevolverHttpCommand getHttpCommand(String service) {
        RevolverHttpCommand command = httpCommands.get(service);
        if (null == command) {
            throw new RevolverExecutionException(RevolverExecutionException.Type.BAD_REQUEST, "No service spec defined for service: " + service);
        }
        return command;
    }

    public static RevolverServiceResolver getServiceNameResolver() {
        return serviceNameResolver;
    }

    public abstract RevolverConfig getRevolverConfig(T var1);

    PersistenceProvider getPersistenceProvider(T configuration, Environment environment) {
        RevolverConfig revolverConfig = this.getRevolverConfig(configuration);
        if (revolverConfig.getMailBox() == null) {
            return new InMemoryPersistenceProvider();
        }
        switch (revolverConfig.getMailBox().getType()) {
            case "in_memory": {
                return new InMemoryPersistenceProvider();
            }
            case "aerospike": {
                AerospikeConnectionManager.init((AerospikeMailBoxConfig)revolverConfig.getMailBox());
                return new AeroSpikePersistenceProvider((AerospikeMailBoxConfig)revolverConfig.getMailBox(), environment.getObjectMapper());
            }
        }
        throw new IllegalArgumentException("Invalid mailbox configuration");
    }

    public CuratorFramework getCurator() {
        return null;
    }

    private void initializeRevolver(T configuration, Environment environment) throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        RevolverConfig revolverConfig = this.getRevolverConfig(configuration);
        serviceNameResolver = revolverConfig.getServiceResolverConfig() != null ? (revolverConfig.getServiceResolverConfig().isUseCurator() ? RevolverServiceResolver.usingCurator().curatorFramework(this.getCurator()).objectMapper(environment.getObjectMapper()).resolverConfig(revolverConfig.getServiceResolverConfig()).build() : RevolverServiceResolver.builder().resolverConfig(revolverConfig.getServiceResolverConfig()).objectMapper(environment.getObjectMapper()).build()) : RevolverServiceResolver.builder().objectMapper(environment.getObjectMapper()).build();
        block8: for (RevolverServiceConfig config : revolverConfig.getServices()) {
            String type;
            switch (type = config.getType()) {
                case "http": {
                    RevolverBundle.registerHttpCommand(revolverConfig, config);
                    continue block8;
                }
                case "https": {
                    RevolverBundle.registerHttpsCommand(revolverConfig, config);
                    continue block8;
                }
            }
            log.warn("Unsupported Service type: " + type);
        }
    }

    private static void registerHttpsCommand(RevolverConfig revolverConfig, RevolverServiceConfig config) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException, UnrecoverableKeyException {
        RevolverHttpsServiceConfig httpsConfig = (RevolverHttpsServiceConfig)config;
        RevolverHttpServiceConfig revolverHttpServiceConfig = RevolverHttpServiceConfig.builder().apis(httpsConfig.getApis()).auth(httpsConfig.getAuth()).authEnabled(httpsConfig.isAuthEnabled()).compression(httpsConfig.isCompression()).connectionKeepAliveInMillis(httpsConfig.getConnectionKeepAliveInMillis()).connectionPoolSize(httpsConfig.getConnectionPoolSize()).enpoint(httpsConfig.getEndpoint()).keystorePassword(httpsConfig.getKeystorePassword()).keyStorePath(httpsConfig.getKeyStorePath()).secured(true).service(httpsConfig.getService()).trackingHeaders(httpsConfig.isTrackingHeaders()).type(httpsConfig.getType()).build();
        try {
            httpCommands.put(config.getService(), RevolverHttpCommand.builder().clientConfiguration(revolverConfig.getClientConfig()).runtimeConfig(revolverConfig.getGlobal()).serviceConfiguration(revolverHttpServiceConfig).apiConfigurations(RevolverBundle.generateApiConfigMap(revolverHttpServiceConfig)).serviceResolver(serviceNameResolver).traceCollector(trace -> {}).build());
        }
        catch (ExecutionException e) {
            log.error("Error creating http command: {}", (Object)config.getService(), (Object)e);
        }
    }

    private static void registerHttpCommand(RevolverConfig revolverConfig, RevolverServiceConfig config) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException, UnrecoverableKeyException {
        RevolverHttpServiceConfig httpConfig = (RevolverHttpServiceConfig)config;
        try {
            httpConfig.setSecured(false);
            httpCommands.put(config.getService(), RevolverHttpCommand.builder().clientConfiguration(revolverConfig.getClientConfig()).runtimeConfig(revolverConfig.getGlobal()).serviceConfiguration(httpConfig).apiConfigurations(RevolverBundle.generateApiConfigMap(httpConfig)).serviceResolver(serviceNameResolver).traceCollector(trace -> {}).build());
        }
        catch (ExecutionException e) {
            log.error("Error creating http command: {}", (Object)config.getService(), (Object)e);
        }
    }

    public static void addHttpCommand(String service, RevolverHttpCommand httpCommand) {
        httpCommands.put(service, httpCommand);
    }
}

