/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.config;

import io.dropwizard.revolver.core.config.MailBoxConfig;

public class AerospikeMailBoxConfig
extends MailBoxConfig {
    private String hosts;
    private String namespace;
    private int maxConnectionsPerNode;
    private int timeout;
    private int retries;
    private int sleepBetweenRetries;

    public AerospikeMailBoxConfig(String hosts, String namespace, int maxConnectionsPerNode, int timeout, int retries, int sleepBetweenRetries) {
        super("aerospike");
        this.hosts = hosts;
        this.namespace = namespace;
        this.maxConnectionsPerNode = maxConnectionsPerNode;
        this.timeout = timeout;
        this.retries = retries;
        this.sleepBetweenRetries = sleepBetweenRetries;
    }

    public static AerospikeMailBoxConfigBuilder builder() {
        return new AerospikeMailBoxConfigBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AerospikeMailBoxConfig)) {
            return false;
        }
        AerospikeMailBoxConfig other = (AerospikeMailBoxConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$hosts = this.getHosts();
        String other$hosts = other.getHosts();
        if (this$hosts == null ? other$hosts != null : !this$hosts.equals(other$hosts)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        if (this.getMaxConnectionsPerNode() != other.getMaxConnectionsPerNode()) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        if (this.getRetries() != other.getRetries()) {
            return false;
        }
        return this.getSleepBetweenRetries() == other.getSleepBetweenRetries();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AerospikeMailBoxConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $hosts = this.getHosts();
        result = result * 59 + ($hosts == null ? 43 : $hosts.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        result = result * 59 + this.getMaxConnectionsPerNode();
        result = result * 59 + this.getTimeout();
        result = result * 59 + this.getRetries();
        result = result * 59 + this.getSleepBetweenRetries();
        return result;
    }

    public String getHosts() {
        return this.hosts;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public int getMaxConnectionsPerNode() {
        return this.maxConnectionsPerNode;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getRetries() {
        return this.retries;
    }

    public int getSleepBetweenRetries() {
        return this.sleepBetweenRetries;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setMaxConnectionsPerNode(int maxConnectionsPerNode) {
        this.maxConnectionsPerNode = maxConnectionsPerNode;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setSleepBetweenRetries(int sleepBetweenRetries) {
        this.sleepBetweenRetries = sleepBetweenRetries;
    }

    @Override
    public String toString() {
        return "AerospikeMailBoxConfig(hosts=" + this.getHosts() + ", namespace=" + this.getNamespace() + ", maxConnectionsPerNode=" + this.getMaxConnectionsPerNode() + ", timeout=" + this.getTimeout() + ", retries=" + this.getRetries() + ", sleepBetweenRetries=" + this.getSleepBetweenRetries() + ")";
    }

    public AerospikeMailBoxConfig() {
    }

    public static class AerospikeMailBoxConfigBuilder {
        private String hosts;
        private String namespace;
        private int maxConnectionsPerNode;
        private int timeout;
        private int retries;
        private int sleepBetweenRetries;

        AerospikeMailBoxConfigBuilder() {
        }

        public AerospikeMailBoxConfigBuilder hosts(String hosts) {
            this.hosts = hosts;
            return this;
        }

        public AerospikeMailBoxConfigBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AerospikeMailBoxConfigBuilder maxConnectionsPerNode(int maxConnectionsPerNode) {
            this.maxConnectionsPerNode = maxConnectionsPerNode;
            return this;
        }

        public AerospikeMailBoxConfigBuilder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public AerospikeMailBoxConfigBuilder retries(int retries) {
            this.retries = retries;
            return this;
        }

        public AerospikeMailBoxConfigBuilder sleepBetweenRetries(int sleepBetweenRetries) {
            this.sleepBetweenRetries = sleepBetweenRetries;
            return this;
        }

        public AerospikeMailBoxConfig build() {
            return new AerospikeMailBoxConfig(this.hosts, this.namespace, this.maxConnectionsPerNode, this.timeout, this.retries, this.sleepBetweenRetries);
        }

        public String toString() {
            return "AerospikeMailBoxConfig.AerospikeMailBoxConfigBuilder(hosts=" + this.hosts + ", namespace=" + this.namespace + ", maxConnectionsPerNode=" + this.maxConnectionsPerNode + ", timeout=" + this.timeout + ", retries=" + this.retries + ", sleepBetweenRetries=" + this.sleepBetweenRetries + ")";
        }
    }
}

