/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.aeroapike;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.Host;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.policy.ClientPolicy;
import com.aerospike.client.policy.CommitLevel;
import com.aerospike.client.policy.ConsistencyLevel;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.Replica;
import com.aerospike.client.policy.WritePolicy;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.dropwizard.revolver.core.config.AerospikeMailBoxConfig;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AerospikeConnectionManager {
    private static final Logger log = LoggerFactory.getLogger(AerospikeConnectionManager.class);
    private static IAerospikeClient client;
    private static AerospikeMailBoxConfig config;
    public static WritePolicy writePolicy;
    public static Policy readPolicy;
    private static LoadingCache<Integer, WritePolicy> writePolicyCache;

    public static void init(AerospikeMailBoxConfig aerospikeConfig) {
        config = aerospikeConfig;
        readPolicy = new Policy();
        AerospikeConnectionManager.readPolicy.maxRetries = config.getRetries();
        AerospikeConnectionManager.readPolicy.consistencyLevel = ConsistencyLevel.CONSISTENCY_ONE;
        AerospikeConnectionManager.readPolicy.replica = Replica.MASTER_PROLES;
        AerospikeConnectionManager.readPolicy.sleepBetweenRetries = config.getSleepBetweenRetries();
        AerospikeConnectionManager.readPolicy.totalTimeout = config.getTimeout();
        AerospikeConnectionManager.readPolicy.sendKey = true;
        writePolicy = new WritePolicy();
        AerospikeConnectionManager.writePolicy.maxRetries = config.getRetries();
        AerospikeConnectionManager.writePolicy.consistencyLevel = ConsistencyLevel.CONSISTENCY_ALL;
        AerospikeConnectionManager.writePolicy.replica = Replica.MASTER_PROLES;
        AerospikeConnectionManager.writePolicy.sleepBetweenRetries = config.getSleepBetweenRetries();
        AerospikeConnectionManager.writePolicy.commitLevel = CommitLevel.COMMIT_ALL;
        AerospikeConnectionManager.writePolicy.totalTimeout = config.getTimeout();
        AerospikeConnectionManager.writePolicy.sendKey = true;
        AerospikeConnectionManager.writePolicy.expiration = config.getTtl();
        ClientPolicy clientPolicy = new ClientPolicy();
        clientPolicy.maxConnsPerNode = config.getMaxConnectionsPerNode();
        clientPolicy.readPolicyDefault = readPolicy;
        clientPolicy.writePolicyDefault = writePolicy;
        clientPolicy.failIfNotConnected = true;
        clientPolicy.requestProleReplicas = true;
        clientPolicy.threadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 16);
        String[] hosts = config.getHosts().split(",");
        List<Host> hostAddresses = Arrays.stream(hosts).map(h -> {
            String[] host = h.split(":");
            if (host.length == 2) {
                return new Host(host[0], Integer.parseInt(host[1]));
            }
            return new Host(host[0], 3000);
        }).collect(Collectors.toList());
        client = new AerospikeClient(clientPolicy, hostAddresses.toArray(new Host[0]));
        log.info("Aerospike connection status: " + client.isConnected());
    }

    public static IAerospikeClient getClient() {
        Preconditions.checkNotNull((Object)client);
        return client;
    }

    public static void setClient(IAerospikeClient aerospikeClient) {
        client = aerospikeClient;
    }

    public static void close() {
        if (null != client) {
            client.close();
        }
    }

    public static WritePolicy getWritePolicy(int ttl) throws ExecutionException {
        return (WritePolicy)writePolicyCache.get((Object)ttl);
    }

    static {
        writePolicyCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Integer, WritePolicy>(){

            public WritePolicy load(Integer key) throws Exception {
                WritePolicy wp = new WritePolicy();
                wp.maxRetries = config.getRetries();
                wp.consistencyLevel = ConsistencyLevel.CONSISTENCY_ALL;
                wp.replica = Replica.MASTER_PROLES;
                wp.sleepBetweenRetries = config.getSleepBetweenRetries();
                wp.commitLevel = CommitLevel.COMMIT_ALL;
                wp.totalTimeout = config.getTimeout();
                wp.sendKey = true;
                wp.expiration = key;
                return wp;
            }
        });
    }
}

