/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.http;

import com.google.common.base.Strings;
import io.dropwizard.revolver.core.RevolverCommand;
import io.dropwizard.revolver.core.config.ClientConfig;
import io.dropwizard.revolver.core.config.RuntimeConfig;
import io.dropwizard.revolver.core.tracing.TraceCollector;
import io.dropwizard.revolver.core.tracing.TraceInfo;
import io.dropwizard.revolver.core.util.RevolverCommandHelper;
import io.dropwizard.revolver.discovery.RevolverServiceResolver;
import io.dropwizard.revolver.discovery.model.Endpoint;
import io.dropwizard.revolver.exception.RevolverException;
import io.dropwizard.revolver.http.RevolverHttpClientFactory;
import io.dropwizard.revolver.http.RevolverHttpContext;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.http.config.RevolverHttpServiceConfig;
import io.dropwizard.revolver.http.model.RevolverHttpRequest;
import io.dropwizard.revolver.http.model.RevolverHttpResponse;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevolverHttpCommand
extends RevolverCommand<RevolverHttpRequest, RevolverHttpResponse, RevolverHttpContext, RevolverHttpServiceConfig, RevolverHttpApiConfig> {
    private static final Logger log = LoggerFactory.getLogger(RevolverHttpCommand.class);
    public static final String CALL_MODE_POLLING = "POLLING";
    public static final String CALL_MODE_CALLBACK = "CALLBACK";
    public static final String CALL_MODE_CALLBACK_SYNC = "CALLBACK_SYNC";
    private final RevolverServiceResolver serviceResolver;
    private final OkHttpClient client;

    public RevolverHttpCommand(RuntimeConfig runtimeConfig, ClientConfig clientConfiguration, RevolverHttpServiceConfig serviceConfiguration, Map<String, RevolverHttpApiConfig> apiConfigurations, TraceCollector traceCollector, RevolverServiceResolver serviceResolver) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException, UnrecoverableKeyException, ExecutionException {
        super(new RevolverHttpContext(), clientConfiguration, runtimeConfig, serviceConfiguration, apiConfigurations, traceCollector);
        this.serviceResolver = serviceResolver;
        this.serviceResolver.register(serviceConfiguration.getEndpoint());
        this.client = RevolverHttpClientFactory.buildClient(serviceConfiguration);
    }

    @Override
    public boolean isFallbackEnabled() {
        return false;
    }

    @Override
    protected RevolverHttpResponse execute(RevolverHttpContext context, RevolverHttpRequest request) throws Exception {
        RevolverHttpApiConfig apiConfig = (RevolverHttpApiConfig)this.getApiConfigurations().get(request.getApi());
        if (apiConfig.getMethods().contains((Object)request.getMethod())) {
            switch (request.getMethod()) {
                case GET: {
                    return this.doGet(request);
                }
                case POST: {
                    return this.doPost(request);
                }
                case PUT: {
                    return this.doPut(request);
                }
                case DELETE: {
                    return this.doDelete(request);
                }
                case HEAD: {
                    return this.doHead(request);
                }
                case OPTIONS: {
                    return this.doOptions(request);
                }
                case PATCH: {
                    return this.doPatch(request);
                }
            }
        }
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.putSingle((Object)"X-REQUEST-PATH", (Object)request.getPath());
        headers.putSingle((Object)"X-REQUEST-METHOD", (Object)request.getMethod().name());
        headers.putSingle((Object)"X-REQUEST-API", (Object)apiConfig.getApi());
        return RevolverHttpResponse.builder().headers((MultivaluedMap<String, String>)headers).statusCode(Response.Status.BAD_REQUEST.getStatusCode()).build();
    }

    @Override
    protected RevolverHttpResponse fallback(RevolverHttpContext context, RevolverHttpRequest requestType) {
        log.error("Fallback triggered for command: " + RevolverCommandHelper.getName(requestType));
        return null;
    }

    private RevolverHttpResponse executeRequest(RevolverHttpApiConfig apiConfiguration, Request request, boolean readBody) throws Exception {
        try {
            Response response = this.client.newCall(request).execute();
            return this.getHttpResponse(apiConfiguration, response, readBody);
        }
        catch (Exception e) {
            log.error("Error running HTTP GET call: ", (Throwable)e);
            throw e;
        }
    }

    private RevolverHttpResponse doGet(RevolverHttpRequest request) throws Exception {
        RevolverHttpApiConfig apiConfiguration = (RevolverHttpApiConfig)this.getApiConfigurations().get(request.getApi());
        Endpoint endpoint = this.serviceResolver.resolve(((RevolverHttpServiceConfig)this.getServiceConfiguration()).getEndpoint());
        if (endpoint == null) {
            throw new RevolverException(503, "R999", "Service [" + request.getPath() + "] Unavailable");
        }
        HttpUrl url = this.generateURI(request, apiConfiguration, endpoint);
        Request.Builder httpRequest = new Request.Builder().url(url);
        httpRequest.get();
        if (null != request.getHeaders()) {
            request.getHeaders().forEach((key, values) -> values.forEach(value -> httpRequest.addHeader(key, value)));
        }
        this.trackingHeaders(request, httpRequest);
        return this.executeRequest(apiConfiguration, httpRequest.build(), true);
    }

    private RevolverHttpResponse doOptions(RevolverHttpRequest request) throws Exception {
        RevolverHttpApiConfig apiConfiguration = (RevolverHttpApiConfig)this.getApiConfigurations().get(request.getApi());
        Endpoint endpoint = this.serviceResolver.resolve(((RevolverHttpServiceConfig)this.getServiceConfiguration()).getEndpoint());
        if (endpoint == null) {
            throw new RevolverException(503, "R999", "Service [" + request.getPath() + "] Unavailable");
        }
        HttpUrl url = this.generateURI(request, apiConfiguration, endpoint);
        Request.Builder httpRequest = new Request.Builder().url(url);
        httpRequest.method("OPTIONS", null);
        if (null != request.getHeaders()) {
            request.getHeaders().forEach((key, values) -> values.forEach(value -> httpRequest.addHeader(key, value)));
        }
        this.trackingHeaders(request, httpRequest);
        return this.executeRequest(apiConfiguration, httpRequest.build(), true);
    }

    private RevolverHttpResponse doHead(RevolverHttpRequest request) throws Exception {
        RevolverHttpApiConfig apiConfiguration = (RevolverHttpApiConfig)this.getApiConfigurations().get(request.getApi());
        Endpoint endpoint = this.serviceResolver.resolve(((RevolverHttpServiceConfig)this.getServiceConfiguration()).getEndpoint());
        if (endpoint == null) {
            throw new RevolverException(503, "R999", "Service [" + request.getPath() + "] Unavailable");
        }
        HttpUrl url = this.generateURI(request, apiConfiguration, endpoint);
        Request.Builder httpRequest = new Request.Builder().url(url);
        httpRequest.head();
        if (null != request.getHeaders()) {
            request.getHeaders().forEach((key, values) -> values.forEach(value -> httpRequest.addHeader(key, value)));
        }
        this.trackingHeaders(request, httpRequest);
        return this.executeRequest(apiConfiguration, httpRequest.build(), false);
    }

    private RevolverHttpResponse doDelete(RevolverHttpRequest request) throws Exception {
        RevolverHttpApiConfig apiConfiguration = (RevolverHttpApiConfig)this.getApiConfigurations().get(request.getApi());
        Endpoint endpoint = this.serviceResolver.resolve(((RevolverHttpServiceConfig)this.getServiceConfiguration()).getEndpoint());
        if (endpoint == null) {
            throw new RevolverException(503, "R999", "Service [" + request.getPath() + "] Unavailable");
        }
        HttpUrl url = this.generateURI(request, apiConfiguration, endpoint);
        Request.Builder httpRequest = new Request.Builder().url(url);
        httpRequest.delete();
        if (null != request.getHeaders()) {
            request.getHeaders().forEach((key, values) -> values.forEach(value -> httpRequest.addHeader(key, value)));
        }
        this.trackingHeaders(request, httpRequest);
        return this.executeRequest(apiConfiguration, httpRequest.build(), true);
    }

    private RevolverHttpResponse doPatch(RevolverHttpRequest request) throws Exception {
        RevolverHttpApiConfig apiConfiguration = (RevolverHttpApiConfig)this.getApiConfigurations().get(request.getApi());
        Endpoint endpoint = this.serviceResolver.resolve(((RevolverHttpServiceConfig)this.getServiceConfiguration()).getEndpoint());
        if (endpoint == null) {
            throw new RevolverException(503, "R999", "Service [" + request.getPath() + "] Unavailable");
        }
        HttpUrl url = this.generateURI(request, apiConfiguration, endpoint);
        Request.Builder httpRequest = new Request.Builder().url(url);
        if (null != request.getHeaders()) {
            request.getHeaders().forEach((key, values) -> values.forEach(value -> httpRequest.addHeader(key, value)));
        }
        if (request.getBody() != null) {
            if (null != request.getHeaders() && StringUtils.isNotBlank((CharSequence)((CharSequence)request.getHeaders().getFirst((Object)"Content-Type")))) {
                httpRequest.patch(RequestBody.create((MediaType)MediaType.parse((String)((String)request.getHeaders().getFirst((Object)"Content-Type"))), (byte[])request.getBody()));
            } else {
                httpRequest.patch(RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (byte[])request.getBody()));
            }
        } else {
            httpRequest.patch(RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (byte[])new byte[0]));
        }
        this.trackingHeaders(request, httpRequest);
        return this.executeRequest(apiConfiguration, httpRequest.build(), true);
    }

    private RevolverHttpResponse doPost(RevolverHttpRequest request) throws Exception {
        RevolverHttpApiConfig apiConfiguration = (RevolverHttpApiConfig)this.getApiConfigurations().get(request.getApi());
        Endpoint endpoint = this.serviceResolver.resolve(((RevolverHttpServiceConfig)this.getServiceConfiguration()).getEndpoint());
        if (endpoint == null) {
            throw new RevolverException(503, "R999", "Service [" + request.getPath() + "] Unavailable");
        }
        HttpUrl url = this.generateURI(request, apiConfiguration, endpoint);
        Request.Builder httpRequest = new Request.Builder().url(url);
        if (null != request.getHeaders()) {
            request.getHeaders().forEach((key, values) -> values.forEach(value -> httpRequest.addHeader(key, value)));
        }
        if (request.getBody() != null) {
            if (null != request.getHeaders() && StringUtils.isNotBlank((CharSequence)((CharSequence)request.getHeaders().getFirst((Object)"Content-Type")))) {
                httpRequest.post(RequestBody.create((MediaType)MediaType.parse((String)((String)request.getHeaders().getFirst((Object)"Content-Type"))), (byte[])request.getBody()));
            } else {
                httpRequest.post(RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (byte[])request.getBody()));
            }
        } else {
            httpRequest.post(RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (byte[])new byte[0]));
        }
        this.trackingHeaders(request, httpRequest);
        return this.executeRequest(apiConfiguration, httpRequest.build(), true);
    }

    private RevolverHttpResponse doPut(RevolverHttpRequest request) throws Exception {
        RevolverHttpApiConfig apiConfiguration = (RevolverHttpApiConfig)this.getApiConfigurations().get(request.getApi());
        Endpoint endpoint = this.serviceResolver.resolve(((RevolverHttpServiceConfig)this.getServiceConfiguration()).getEndpoint());
        if (endpoint == null) {
            throw new RevolverException(503, "R999", "Service [" + request.getPath() + "] Unavailable");
        }
        HttpUrl url = this.generateURI(request, apiConfiguration, endpoint);
        Request.Builder httpRequest = new Request.Builder().url(url);
        if (null != request.getHeaders()) {
            request.getHeaders().forEach((key, values) -> values.forEach(value -> httpRequest.addHeader(key, value)));
        }
        if (request.getBody() != null) {
            if (null != request.getHeaders() && StringUtils.isNotBlank((CharSequence)((CharSequence)request.getHeaders().getFirst((Object)"Content-Type")))) {
                httpRequest.put(RequestBody.create((MediaType)MediaType.parse((String)((String)request.getHeaders().getFirst((Object)"Content-Type"))), (byte[])request.getBody()));
            } else {
                httpRequest.put(RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (byte[])request.getBody()));
            }
        } else {
            httpRequest.put(RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (byte[])new byte[0]));
        }
        this.trackingHeaders(request, httpRequest);
        return this.executeRequest(apiConfiguration, httpRequest.build(), true);
    }

    private HttpUrl generateURI(RevolverHttpRequest request, RevolverHttpApiConfig apiConfiguration, Endpoint endpoint) {
        HttpUrl.Builder builder = new HttpUrl.Builder();
        this.addQueryParams(request, builder);
        if (((RevolverHttpServiceConfig)this.getServiceConfiguration()).isSecured()) {
            builder.scheme("https");
        } else {
            builder.scheme("http");
        }
        builder.host(endpoint.getHost()).port(endpoint.getPort()).encodedPath(this.resolvePath(apiConfiguration, request));
        return builder.build();
    }

    private RevolverHttpResponse getHttpResponse(RevolverHttpApiConfig apiConfiguration, Response response, boolean readBody) throws Exception {
        if (apiConfiguration.getAcceptableResponseCodes() != null && !apiConfiguration.getAcceptableResponseCodes().isEmpty() && !apiConfiguration.getAcceptableResponseCodes().contains(response.code())) {
            if (response.body() != null) {
                log.error("Response: " + response.body().string());
            }
            throw new Exception(String.format("HTTP %s %s failed with [%d - %s]", apiConfiguration.getMethods(), apiConfiguration.getApi(), response.code(), response.message()));
        }
        MultivaluedHashMap headers = new MultivaluedHashMap();
        response.headers().names().stream().forEach(h -> headers.putSingle(h, (Object)response.header(h)));
        RevolverHttpResponse.RevolverHttpResponseBuilder revolverResponse = RevolverHttpResponse.builder().statusCode(response.code()).headers((MultivaluedMap<String, String>)headers);
        if (readBody) {
            revolverResponse.body(response.body().bytes());
        }
        return revolverResponse.build();
    }

    private String resolvePath(RevolverHttpApiConfig httpApiConfiguration, RevolverHttpRequest request) {
        String uri = null;
        if (Strings.isNullOrEmpty((String)request.getPath())) {
            if (null != request.getPathParams()) {
                uri = StrSubstitutor.replace((Object)httpApiConfiguration.getPath(), request.getPathParams());
            }
        } else {
            uri = request.getPath();
        }
        if (Strings.isNullOrEmpty((String)uri)) {
            uri = httpApiConfiguration.getPath();
        }
        return uri.charAt(0) == '/' ? uri : "/" + uri;
    }

    private void addQueryParams(RevolverHttpRequest request, HttpUrl.Builder builder) {
        if (null != request.getQueryParams()) {
            request.getQueryParams().forEach((key, values) -> values.forEach(value -> builder.addQueryParameter(key, value)));
        }
    }

    private void trackingHeaders(RevolverHttpRequest request, Request.Builder requestBuilder) {
        List existing;
        if (!((RevolverHttpServiceConfig)this.getServiceConfiguration()).isTrackingHeaders()) {
            return;
        }
        TraceInfo spanInfo = request.getTrace();
        if (request.getHeaders() == null) {
            request.setHeaders((MultivaluedMap<String, String>)new MultivaluedHashMap());
        }
        if (!(existing = request.getHeaders().keySet().stream().map(String::toLowerCase).collect(Collectors.toList())).contains("X-TRANSACTION-ID".toLowerCase())) {
            requestBuilder.addHeader("X-TRANSACTION-ID", spanInfo.getTransactionId());
        }
        if (!existing.contains("X-REQUEST-ID".toLowerCase())) {
            requestBuilder.addHeader("X-REQUEST-ID", spanInfo.getRequestId());
        }
        if (!existing.contains("X-PARENT-REQUEST-ID".toLowerCase())) {
            requestBuilder.addHeader("X-PARENT-REQUEST-ID", spanInfo.getParentRequestId());
        }
        if (!existing.contains("X-REQUEST-TIMESTAMP".toLowerCase())) {
            requestBuilder.addHeader("X-REQUEST-TIMESTAMP", Long.toString(spanInfo.getTimestamp()));
        }
        if (!existing.contains("X-CLIENT-ID".toLowerCase())) {
            requestBuilder.addHeader("X-CLIENT-ID", this.getClientConfiguration().getClientName());
        }
    }

    public static RevolverHttpCommandBuilder builder() {
        return new RevolverHttpCommandBuilder();
    }

    public static class RevolverHttpCommandBuilder {
        private RuntimeConfig runtimeConfig;
        private ClientConfig clientConfiguration;
        private RevolverHttpServiceConfig serviceConfiguration;
        private Map<String, RevolverHttpApiConfig> apiConfigurations;
        private TraceCollector traceCollector;
        private RevolverServiceResolver serviceResolver;

        RevolverHttpCommandBuilder() {
        }

        public RevolverHttpCommandBuilder runtimeConfig(RuntimeConfig runtimeConfig) {
            this.runtimeConfig = runtimeConfig;
            return this;
        }

        public RevolverHttpCommandBuilder clientConfiguration(ClientConfig clientConfiguration) {
            this.clientConfiguration = clientConfiguration;
            return this;
        }

        public RevolverHttpCommandBuilder serviceConfiguration(RevolverHttpServiceConfig serviceConfiguration) {
            this.serviceConfiguration = serviceConfiguration;
            return this;
        }

        public RevolverHttpCommandBuilder apiConfigurations(Map<String, RevolverHttpApiConfig> apiConfigurations) {
            this.apiConfigurations = apiConfigurations;
            return this;
        }

        public RevolverHttpCommandBuilder traceCollector(TraceCollector traceCollector) {
            this.traceCollector = traceCollector;
            return this;
        }

        public RevolverHttpCommandBuilder serviceResolver(RevolverServiceResolver serviceResolver) {
            this.serviceResolver = serviceResolver;
            return this;
        }

        public RevolverHttpCommand build() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException, UnrecoverableKeyException, ExecutionException {
            return new RevolverHttpCommand(this.runtimeConfig, this.clientConfiguration, this.serviceConfiguration, this.apiConfigurations, this.traceCollector, this.serviceResolver);
        }

        public String toString() {
            return "RevolverHttpCommand.RevolverHttpCommandBuilder(runtimeConfig=" + this.runtimeConfig + ", clientConfiguration=" + this.clientConfiguration + ", serviceConfiguration=" + this.serviceConfiguration + ", apiConfigurations=" + this.apiConfigurations + ", traceCollector=" + this.traceCollector + ", serviceResolver=" + this.serviceResolver + ")";
        }
    }
}

