/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.riemann;

import com.codahale.metrics.riemann.DropWizardRiemannReporter;
import com.codahale.metrics.riemann.Riemann;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.riemann.RiemannConfig;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RiemannBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final Logger log = LoggerFactory.getLogger(RiemannBundle.class);
    private static Riemann riemann;
    private static DropWizardRiemannReporter riemannReporter;

    public abstract RiemannConfig getRiemannConfiguration(T var1);

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(T configuration, Environment environment) {
        environment.lifecycle().manage(new Managed((Configuration)configuration, environment){
            final /* synthetic */ Configuration val$configuration;
            final /* synthetic */ Environment val$environment;
            {
                this.val$configuration = configuration;
                this.val$environment = environment;
            }

            public void start() throws Exception {
                if (riemann == null) {
                    RiemannConfig riemannConfig = RiemannBundle.this.getRiemannConfiguration(this.val$configuration);
                    if (riemannConfig == null || Strings.isNullOrEmpty((String)riemannConfig.getHost())) {
                        log.warn("No valid reimann host found!. Cannot start reimann bundle");
                        return;
                    }
                    try {
                        String host = System.getenv("HOST");
                        if (host == null) {
                            host = InetAddress.getLocalHost().getHostName();
                        }
                        riemann = new Riemann(riemannConfig.getHost(), Integer.valueOf(riemannConfig.getPort()));
                        DropWizardRiemannReporter.Builder builder = DropWizardRiemannReporter.forRegistry(this.val$environment.metrics()).tags(riemannConfig.getTags()).prefixedWith(riemannConfig.getPrefix()).useSeparator(".").localHost(host).convertDurationsTo(TimeUnit.MILLISECONDS).convertRatesTo(TimeUnit.SECONDS);
                        riemannReporter = builder.build(riemann);
                        riemannReporter.start(riemannConfig.getPollingInterval(), TimeUnit.SECONDS);
                        log.info("Started Riemann metrics reporter on {}:{} with prefix {} and tagged with: {}", new Object[]{riemannConfig.getHost(), riemannConfig.getPort(), riemannConfig.getPrefix(), Joiner.on((String)",").join(riemannConfig.getTags())});
                    }
                    catch (IOException e) {
                        log.error("Error starting Riemann reporter: ", (Object)e.getMessage());
                    }
                }
            }

            public void stop() throws Exception {
                if (riemannReporter != null) {
                    riemannReporter.stop();
                }
                if (riemann != null) {
                    riemann.close();
                }
            }
        });
    }
}

