/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.socket.oor;

import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.servlets.tasks.Task;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.socket.oor.server.OorSocketServer;
import io.dropwizard.socket.oor.tasks.OorTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OorSocketBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final Logger log = LoggerFactory.getLogger(OorSocketBundle.class);
    private ExecutorService executorService;

    public abstract int oorPort();

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(T configuration, Environment environment) throws Exception {
        final OorSocketServer oorSocketServer = new OorSocketServer(this.oorPort());
        this.executorService = Executors.newSingleThreadExecutor();
        environment.lifecycle().manage(new Managed(){

            public void start() throws Exception {
                OorSocketBundle.this.executorService.submit(oorSocketServer);
            }

            public void stop() throws Exception {
                oorSocketServer.stop();
                OorSocketBundle.this.executorService.shutdownNow();
            }
        });
        environment.admin().addTask((Task)new OorTask(oorSocketServer));
    }
}

