/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.maxmind.geoip2.cache;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.maxmind.db.NodeCache;
import io.dropwizard.maxmind.geoip2.config.MaxMindConfig;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxMindCache
implements NodeCache {
    private static final Logger log = LoggerFactory.getLogger(MaxMindCache.class);
    private LoadingCache<Integer, JsonNode> cache;
    private NodeCache.Loader loader;

    public MaxMindCache(MaxMindConfig config) {
        this.cache = CacheBuilder.newBuilder().expireAfterAccess((long)config.getCacheTTL(), TimeUnit.SECONDS).maximumSize((long)config.getCacheMaxEntries()).recordStats().build((CacheLoader)new CacheLoader<Integer, JsonNode>(){

            public JsonNode load(Integer key) throws Exception {
                return MaxMindCache.this.loader.load(key.intValue());
            }
        });
    }

    public JsonNode get(int i, NodeCache.Loader loader) throws IOException {
        if (loader != null) {
            this.loader = loader;
        }
        try {
            return (JsonNode)this.cache.get((Object)i);
        }
        catch (ExecutionException e) {
            log.error("Error fetching info from cache", (Throwable)e);
            return null;
        }
    }
}

