/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.maxmind.geoip2.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.model.AnonymousIpResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.ConnectionTypeResponse;
import com.maxmind.geoip2.model.CountryResponse;
import io.dropwizard.maxmind.geoip2.config.MaxMindConfig;
import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxMindCache {
    private static final Logger log = LoggerFactory.getLogger(MaxMindCache.class);
    private LoadingCache<InetAddress, CountryResponse> countryCache;
    private LoadingCache<InetAddress, CityResponse> cityCache;
    private LoadingCache<InetAddress, AnonymousIpResponse> anonymousCache;
    private LoadingCache<InetAddress, ConnectionTypeResponse> connectionTypeCache;

    public MaxMindCache(MaxMindConfig config, final DatabaseReader databaseReader) {
        this.countryCache = CacheBuilder.newBuilder().expireAfterAccess((long)config.getCacheTTL(), TimeUnit.SECONDS).maximumSize((long)config.getCacheMaxEntries()).recordStats().build((CacheLoader)new CacheLoader<InetAddress, CountryResponse>(){

            public CountryResponse load(InetAddress key) throws Exception {
                return databaseReader.country(key);
            }
        });
        this.cityCache = CacheBuilder.newBuilder().expireAfterAccess((long)config.getCacheTTL(), TimeUnit.SECONDS).maximumSize((long)config.getCacheMaxEntries()).recordStats().build((CacheLoader)new CacheLoader<InetAddress, CityResponse>(){

            public CityResponse load(InetAddress key) throws Exception {
                return databaseReader.city(key);
            }
        });
        this.anonymousCache = CacheBuilder.newBuilder().expireAfterAccess((long)config.getCacheTTL(), TimeUnit.SECONDS).maximumSize((long)config.getCacheMaxEntries()).recordStats().build((CacheLoader)new CacheLoader<InetAddress, AnonymousIpResponse>(){

            public AnonymousIpResponse load(InetAddress key) throws Exception {
                return databaseReader.anonymousIp(key);
            }
        });
        this.connectionTypeCache = CacheBuilder.newBuilder().expireAfterAccess((long)config.getCacheTTL(), TimeUnit.SECONDS).maximumSize((long)config.getCacheMaxEntries()).recordStats().build((CacheLoader)new CacheLoader<InetAddress, ConnectionTypeResponse>(){

            public ConnectionTypeResponse load(InetAddress key) throws Exception {
                return databaseReader.connectionType(key);
            }
        });
    }

    public CountryResponse country(InetAddress address) throws IOException {
        try {
            return (CountryResponse)this.countryCache.get((Object)address);
        }
        catch (ExecutionException e) {
            log.error("Error fetching country info from cache: {}", (Object)e.getMessage());
            return null;
        }
    }

    public CityResponse city(InetAddress address) throws IOException {
        try {
            return (CityResponse)this.cityCache.get((Object)address);
        }
        catch (ExecutionException e) {
            log.error("Error fetching city info from cache: {}", (Object)e.getMessage());
            return null;
        }
    }

    public AnonymousIpResponse anonymousIp(InetAddress address) throws IOException {
        try {
            return (AnonymousIpResponse)this.anonymousCache.get((Object)address);
        }
        catch (ExecutionException e) {
            log.error("Error fetching anonymous ip info from cache: {}", (Object)e.getMessage());
            return null;
        }
    }

    public ConnectionTypeResponse connectionType(InetAddress address) throws IOException {
        try {
            return (ConnectionTypeResponse)this.connectionTypeCache.get((Object)address);
        }
        catch (ExecutionException e) {
            log.error("Error fetching connection type info from cache: {}", (Object)e.getMessage());
            return null;
        }
    }
}

