/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer;

import com.github.toastshaman.dropwizard.auth.jwt.JsonWebTokenParser;
import com.github.toastshaman.dropwizard.auth.jwt.hmac.HmacSHA512Verifier;
import com.github.toastshaman.dropwizard.auth.jwt.parser.DefaultJsonWebTokenParser;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.okhttp.OkHttpClient;
import feign.slf4j.Slf4jLogger;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.primer.auth.PrimerAuthenticatorRequestFilter;
import io.dropwizard.primer.cache.TokenCacheManager;
import io.dropwizard.primer.client.PrimerClient;
import io.dropwizard.primer.exception.PrimerException;
import io.dropwizard.primer.exception.PrimerExceptionMapper;
import io.dropwizard.primer.model.PrimerBundleConfiguration;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.core.Response;

public abstract class PrimerBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static PrimerClient primerClient;

    public abstract PrimerBundleConfiguration getPrimerConfiguration(T var1);

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(T configuration, Environment environment) throws Exception {
        JacksonDecoder decoder = new JacksonDecoder();
        JacksonEncoder encoder = new JacksonEncoder();
        Slf4jLogger logger = new Slf4jLogger();
        primerClient = (PrimerClient)Feign.builder().decoder((Decoder)decoder).encoder((Encoder)encoder).errorDecoder((methodKey, response) -> PrimerException.builder().status(Response.Status.fromStatusCode((int)response.status())).errorCode("PR000").message(response.body().toString()).build()).client((Client)new OkHttpClient()).logger((Logger)logger).logLevel(Logger.Level.BASIC).target(PrimerClient.class, String.format("http://%s:%d", this.getPrimerConfiguration(configuration).getHost(), this.getPrimerConfiguration(configuration).getPort()));
        environment.lifecycle().manage(new Managed((Configuration)configuration){
            final /* synthetic */ Configuration val$configuration;
            {
                this.val$configuration = configuration;
            }

            public void start() throws Exception {
                TokenCacheManager.init(PrimerBundle.this.getPrimerConfiguration(this.val$configuration));
            }

            public void stop() throws Exception {
            }
        });
        environment.jersey().register((Object)new PrimerExceptionMapper());
        DefaultJsonWebTokenParser tokenParser = new DefaultJsonWebTokenParser();
        byte[] secretKey = this.getPrimerConfiguration(configuration).getPrivateKey().getBytes(StandardCharsets.UTF_8);
        HmacSHA512Verifier tokenVerifier = new HmacSHA512Verifier(secretKey);
        environment.jersey().register((Object)PrimerAuthenticatorRequestFilter.builder().configuration(this.getPrimerConfiguration(configuration)).primerClient(primerClient).tokenParser((JsonWebTokenParser)tokenParser).verifier(tokenVerifier).build());
    }
}

