/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.http;

import io.dropwizard.revolver.http.config.IdleConnectionConfig;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.HttpClientConnectionManager;

public class IdleConnectionMonitorThread
extends Thread {
    private HttpClientConnectionManager connMgr;
    private volatile boolean shutdown;
    private IdleConnectionConfig idleConnectionConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.shutdown) {
                IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                synchronized (idleConnectionMonitorThread) {
                    this.wait(this.idleConnectionConfig.getWaitTimeInMillis());
                    this.connMgr.closeExpiredConnections();
                    this.connMgr.closeIdleConnections(this.idleConnectionConfig.getConnectionCloseTimeInSeconds(), TimeUnit.SECONDS);
                }
            }
            return;
        }
        catch (InterruptedException ex) {
            this.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        IdleConnectionMonitorThread idleConnectionMonitorThread = this;
        synchronized (idleConnectionMonitorThread) {
            this.notifyAll();
        }
    }

    public static IdleConnectionMonitorThreadBuilder builder() {
        return new IdleConnectionMonitorThreadBuilder();
    }

    public IdleConnectionMonitorThread(HttpClientConnectionManager connMgr, boolean shutdown, IdleConnectionConfig idleConnectionConfig) {
        this.connMgr = connMgr;
        this.shutdown = shutdown;
        this.idleConnectionConfig = idleConnectionConfig;
    }

    public IdleConnectionMonitorThread() {
    }

    public static class IdleConnectionMonitorThreadBuilder {
        private HttpClientConnectionManager connMgr;
        private boolean shutdown;
        private IdleConnectionConfig idleConnectionConfig;

        IdleConnectionMonitorThreadBuilder() {
        }

        public IdleConnectionMonitorThreadBuilder connMgr(HttpClientConnectionManager connMgr) {
            this.connMgr = connMgr;
            return this;
        }

        public IdleConnectionMonitorThreadBuilder shutdown(boolean shutdown) {
            this.shutdown = shutdown;
            return this;
        }

        public IdleConnectionMonitorThreadBuilder idleConnectionConfig(IdleConnectionConfig idleConnectionConfig) {
            this.idleConnectionConfig = idleConnectionConfig;
            return this;
        }

        public IdleConnectionMonitorThread build() {
            return new IdleConnectionMonitorThread(this.connMgr, this.shutdown, this.idleConnectionConfig);
        }

        public String toString() {
            return "IdleConnectionMonitorThread.IdleConnectionMonitorThreadBuilder(connMgr=" + this.connMgr + ", shutdown=" + this.shutdown + ", idleConnectionConfig=" + this.idleConnectionConfig + ")";
        }
    }
}

