/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.http;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.dropwizard.revolver.http.auth.BasicAuthConfig;
import io.dropwizard.revolver.http.auth.TokenAuthConfig;
import io.dropwizard.revolver.http.config.RevolverHttpServiceConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.CodingErrorAction;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.NoHttpResponseException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RevolverHttpClientFactory {
    private static final Logger log = LoggerFactory.getLogger(RevolverHttpClientFactory.class);
    private static LoadingCache<RevolverHttpServiceConfig, CloseableHttpClient> clientCache = Caffeine.newBuilder().build(RevolverHttpClientFactory::getHttpClient);

    RevolverHttpClientFactory() {
    }

    static CloseableHttpClient buildClient(RevolverHttpServiceConfig serviceConfiguration) {
        Preconditions.checkNotNull((Object)serviceConfiguration);
        return (CloseableHttpClient)clientCache.get((Object)serviceConfiguration);
    }

    private static CloseableHttpClient getHttpClient(RevolverHttpServiceConfig serviceConfiguration) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, KeyManagementException, UnrecoverableKeyException {
        SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).setSoKeepAlive(true).setSoTimeout(0).build();
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).setCharset(Consts.UTF_8).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(serviceConfiguration.getConnectionPoolSize());
        connectionManager.setMaxTotal(serviceConfiguration.getConnectionPoolSize());
        connectionManager.setValidateAfterInactivity(100);
        connectionManager.closeIdleConnections(serviceConfiguration.getConnectionKeepAliveInMillis() <= 0 ? 30000L : (long)serviceConfiguration.getConnectionKeepAliveInMillis(), TimeUnit.MILLISECONDS);
        connectionManager.setDefaultSocketConfig(socketConfig);
        connectionManager.setDefaultConnectionConfig(connectionConfig);
        RequestConfig defaultRequestConfig = RequestConfig.custom().setAuthenticationEnabled(serviceConfiguration.isAuthEnabled()).setRedirectsEnabled(false).setConnectTimeout(Integer.MAX_VALUE).setConnectionRequestTimeout(Integer.MAX_VALUE).setSocketTimeout(0).build();
        HttpClientBuilder client = HttpClients.custom().addInterceptorFirst((httpRequest, httpContext) -> httpRequest.removeHeaders("Content-Length")).setConnectionManager((HttpClientConnectionManager)connectionManager).setRetryHandler((exception, executionCount, context) -> {
            if (executionCount < 3 && exception instanceof NoHttpResponseException) {
                log.warn("Invalid connection used for service client: {} | Retry count: {}", (Object)serviceConfiguration.getService(), (Object)executionCount);
                return true;
            }
            return false;
        }).setDefaultRequestConfig(defaultRequestConfig);
        if (serviceConfiguration.isAuthEnabled()) {
            switch (serviceConfiguration.getAuth().getType().toLowerCase()) {
                case "basic": {
                    BasicAuthConfig basicAuthConfig = (BasicAuthConfig)serviceConfiguration.getAuth();
                    if (!Strings.isNullOrEmpty((String)basicAuthConfig.getUsername())) {
                        throw new RuntimeException(String.format("No valid authentication data for service %s", serviceConfiguration.getAuth().getType()));
                    }
                    BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
                    basicCredentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(basicAuthConfig.getUsername(), basicAuthConfig.getPassword()));
                    client.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
                    break;
                }
                case "token": {
                    TokenAuthConfig tokenAuthConfig = (TokenAuthConfig)serviceConfiguration.getAuth();
                    if (Strings.isNullOrEmpty((String)tokenAuthConfig.getPrefix())) {
                        client.setDefaultHeaders(Collections.singletonList(new BasicHeader("Authorization", tokenAuthConfig.getToken())));
                        break;
                    }
                    client.setDefaultHeaders(Collections.singletonList(new BasicHeader("Authorization", String.format("%s %s", tokenAuthConfig.getPrefix(), tokenAuthConfig.getToken()))));
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("Authentication type %s is not supported", serviceConfiguration.getAuth().getType()));
                }
            }
        }
        if (serviceConfiguration.isSecured()) {
            String keystorePassword;
            String keystorePath = serviceConfiguration.getKeyStorePath();
            String string = keystorePassword = serviceConfiguration.getKeystorePassword() == null ? "" : serviceConfiguration.getKeystorePassword();
            if (!StringUtils.isBlank((CharSequence)keystorePath)) {
                RevolverHttpClientFactory.configureSSL(keystorePath, keystorePassword, client);
            } else {
                client.setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier());
            }
        }
        return client.build();
    }

    private static void configureSSL(String keyStorePath, String keyStorePassword, HttpClientBuilder clientBuilder) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, KeyManagementException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream instream = RevolverHttpClientFactory.class.getClassLoader().getResourceAsStream(keyStorePath);){
            keyStore.load(instream, keyStorePassword.toCharArray());
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keyStorePassword.toCharArray());
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        clientBuilder.setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier());
        clientBuilder.setSSLContext(sslContext);
    }
}

