package io.dropwizard.revolver.retry;

import lombok.Builder;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.ws.rs.DefaultValue;

/***
 Created by nitish.goyal on 25/02/19
 ***/
@Data
@Builder
public class RevolverApiRetryConfig {

    public static final int MAX_RETRY = 3;
    public static final int MAXIMUM_WAIT_TIME_IN_SECONDS = 10;
    public static final long INCREMENT_BY_IN_MILLIS = 200;

    @NotNull
    private boolean enabled;

    @DefaultValue("3")
    private int maxRetry;

    @DefaultValue(value = "EXPONENTIAL")
    private WaitStrategy waitStrategy;

    @DefaultValue(value = "10")
    private int maximumTimeInSeconds;

    @DefaultValue(value = "200")
    private long incrementByInMillis;

    @Builder(builderMethodName = "configBuilder")
    public RevolverApiRetryConfig(final boolean enabled, final int maxRetry, final WaitStrategy waitStrategy,
                                  final int maximumTimeInSeconds, final long incrementByInMillis) {

        this.enabled = enabled;
        this.maxRetry = maxRetry;
        this.waitStrategy = waitStrategy;
        this.maximumTimeInSeconds = maximumTimeInSeconds;
        this.incrementByInMillis = incrementByInMillis;
    }
}
