/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.retry;

import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.retry.RevolverApiRetryConfig;
import io.dropwizard.revolver.retry.WaitStrategy;
import java.util.concurrent.TimeUnit;

public class RetryUtils {
    private static final Retryer<Boolean> DEFAULT_RETRYER = RetryerBuilder.newBuilder().retryIfException().withStopStrategy(StopStrategies.stopAfterAttempt((int)3)).withWaitStrategy(WaitStrategies.exponentialWait((long)10L, (TimeUnit)TimeUnit.SECONDS)).build();
    private static final long INITIAL_WAIT_IN_MILLS = 200L;

    public static Retryer getRetryer(RevolverHttpApiConfig revolverHttpApiConfig) {
        RevolverApiRetryConfig revolverApiRetryConfig = revolverHttpApiConfig.getRetryConfig();
        int maximumTimeInSeconds = revolverHttpApiConfig.getRetryConfig().getMaximumTimeInSeconds();
        int maxRetry = revolverApiRetryConfig.getMaxRetry();
        long incrementByInMillis = revolverApiRetryConfig.getIncrementByInMillis();
        WaitStrategy waitStrategy = revolverApiRetryConfig.getWaitStrategy();
        switch (waitStrategy) {
            case FIXED: {
                return RetryerBuilder.newBuilder().retryIfException().withStopStrategy(StopStrategies.stopAfterAttempt((int)maxRetry)).withWaitStrategy(WaitStrategies.fixedWait((long)maximumTimeInSeconds, (TimeUnit)TimeUnit.SECONDS)).build();
            }
            case NO_WAIT: {
                return RetryerBuilder.newBuilder().retryIfException().withStopStrategy(StopStrategies.stopAfterAttempt((int)maxRetry)).withWaitStrategy(WaitStrategies.noWait()).build();
            }
            case EXPONENTIAL: {
                return RetryerBuilder.newBuilder().retryIfException().withStopStrategy(StopStrategies.stopAfterAttempt((int)maxRetry)).withWaitStrategy(WaitStrategies.exponentialWait((long)maximumTimeInSeconds, (TimeUnit)TimeUnit.SECONDS)).build();
            }
            case INCREMENTAL: {
                return RetryerBuilder.newBuilder().retryIfException().withStopStrategy(StopStrategies.stopAfterAttempt((int)maxRetry)).withWaitStrategy(WaitStrategies.incrementingWait((long)200L, (TimeUnit)TimeUnit.MILLISECONDS, (long)incrementByInMillis, (TimeUnit)TimeUnit.MILLISECONDS)).build();
            }
            case FIBONACCI: {
                return RetryerBuilder.newBuilder().retryIfException().withStopStrategy(StopStrategies.stopAfterAttempt((int)maxRetry)).withWaitStrategy(WaitStrategies.fibonacciWait((long)maximumTimeInSeconds, (TimeUnit)TimeUnit.SECONDS)).build();
            }
        }
        return DEFAULT_RETRYER;
    }
}

