/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.http;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.dropwizard.revolver.RevolverBundle;
import io.dropwizard.revolver.core.RevolverCommand;
import io.dropwizard.revolver.core.config.ClientConfig;
import io.dropwizard.revolver.core.config.RuntimeConfig;
import io.dropwizard.revolver.core.tracing.TraceInfo;
import io.dropwizard.revolver.core.util.RevolverCommandHelper;
import io.dropwizard.revolver.discovery.model.Endpoint;
import io.dropwizard.revolver.exception.RevolverException;
import io.dropwizard.revolver.http.RevolverHttpClientFactory;
import io.dropwizard.revolver.http.RevolverHttpContext;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.http.config.RevolverHttpServiceConfig;
import io.dropwizard.revolver.http.model.RevolverHttpRequest;
import io.dropwizard.revolver.http.model.RevolverHttpResponse;
import io.dropwizard.revolver.retry.RetryUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevolverHttpCommand
extends RevolverCommand<RevolverHttpRequest, RevolverHttpResponse, RevolverHttpContext, RevolverHttpServiceConfig, RevolverHttpApiConfig> {
    private static final Logger log = LoggerFactory.getLogger(RevolverHttpCommand.class);
    public static final String CALL_MODE_POLLING = "POLLING";
    public static final String CALL_MODE_CALLBACK = "CALLBACK";
    public static final String CALL_MODE_CALLBACK_SYNC = "CALLBACK_SYNC";
    private final CloseableHttpClient client;

    public RevolverHttpCommand(RuntimeConfig runtimeConfig, ClientConfig clientConfiguration, RevolverHttpServiceConfig serviceConfiguration, RevolverHttpApiConfig apiConfiguration) {
        super(new RevolverHttpContext(), clientConfiguration, runtimeConfig, serviceConfiguration, apiConfiguration);
        this.client = RevolverHttpClientFactory.buildClient(serviceConfiguration);
    }

    @Override
    public boolean isFallbackEnabled() {
        return false;
    }

    @Override
    protected RevolverHttpResponse execute(RevolverHttpContext context, RevolverHttpRequest request) throws Exception {
        Preconditions.checkNotNull((Object)this.client);
        RevolverHttpApiConfig apiConfig = (RevolverHttpApiConfig)this.getApiConfiguration();
        if (apiConfig.getMethods().contains((Object)request.getMethod())) {
            switch (request.getMethod()) {
                case GET: {
                    return this.doGet(request);
                }
                case POST: {
                    return this.doPost(request);
                }
                case PUT: {
                    return this.doPut(request);
                }
                case DELETE: {
                    return this.doDelete(request);
                }
                case HEAD: {
                    return this.doHead(request);
                }
                case OPTIONS: {
                    return this.doOptions(request);
                }
                case PATCH: {
                    return this.doPatch(request);
                }
            }
        }
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.putSingle((Object)"X-REQUEST-PATH", (Object)request.getPath());
        headers.putSingle((Object)"X-REQUEST-METHOD", (Object)request.getMethod().name());
        headers.putSingle((Object)"X-REQUEST-API", (Object)((RevolverHttpApiConfig)this.getApiConfiguration()).getApi());
        return RevolverHttpResponse.builder().headers((MultivaluedMap<String, String>)headers).statusCode(Response.Status.BAD_REQUEST.getStatusCode()).build();
    }

    @Override
    protected RevolverHttpResponse fallback(RevolverHttpContext context, RevolverHttpRequest requestType) {
        log.error("Fallback triggered for command: " + RevolverCommandHelper.getName(requestType));
        return null;
    }

    private URI getServiceUrl(RevolverHttpRequest request, RevolverHttpApiConfig apiConfiguration) throws RevolverException {
        Endpoint endpoint = RevolverBundle.serviceNameResolver.resolve(((RevolverHttpServiceConfig)this.getServiceConfiguration()).getEndpoint());
        if (endpoint == null) {
            if (Strings.isNullOrEmpty((String)((RevolverHttpServiceConfig)this.getServiceConfiguration()).getFallbackAddress())) {
                throw new RevolverException(503, "R999", "Service [" + request.getPath() + "] Unavailable");
            }
            String[] address = ((RevolverHttpServiceConfig)this.getServiceConfiguration()).getFallbackAddress().split(":");
            endpoint = address.length == 1 ? Endpoint.builder().host(address[0]).port(80).build() : Endpoint.builder().host(address[0]).port(Integer.parseInt(address[1])).build();
        }
        try {
            return this.generateURI(request, apiConfiguration, endpoint);
        }
        catch (URISyntaxException e) {
            throw new RevolverException(400, "R001", "Bad URI");
        }
    }

    private RevolverHttpResponse executeRequest(RevolverHttpApiConfig apiConfiguration, final HttpRequestBase request, boolean readBody) throws Exception {
        try (CloseableHttpResponse response = null;){
            long start = System.currentTimeMillis();
            response = null != apiConfiguration.getRetryConfig() && apiConfiguration.getRetryConfig().isEnabled() ? (CloseableHttpResponse)RetryUtils.getRetryer(apiConfiguration).call(new Callable(){

                public Object call() throws Exception {
                    return RevolverHttpCommand.this.client.execute((HttpUriRequest)request);
                }
            }) : this.client.execute((HttpUriRequest)request);
            long end = System.currentTimeMillis();
            RevolverHttpResponse httpResponse = this.getHttpResponse(apiConfiguration, (HttpResponse)response, readBody);
            log.info("[{}/{}] {} {}:{}{} {} {}ms", new Object[]{apiConfiguration.getApi(), apiConfiguration.getPath(), request.getMethod(), request.getURI().getHost(), request.getURI().getPort(), request.getURI().getRawPath(), httpResponse.getStatusCode(), end - start});
            RevolverHttpResponse revolverHttpResponse = httpResponse;
            return revolverHttpResponse;
        }
    }

    private RevolverHttpResponse doGet(RevolverHttpRequest request) throws Exception {
        URI url = this.getServiceUrl(request, (RevolverHttpApiConfig)this.getApiConfiguration());
        HttpGet httpRequest = new HttpGet(url);
        this.addHeaders(request, (HttpRequestBase)httpRequest);
        this.trackingHeaders(request, (HttpRequestBase)httpRequest);
        return this.executeRequest((RevolverHttpApiConfig)this.getApiConfiguration(), (HttpRequestBase)httpRequest, true);
    }

    private RevolverHttpResponse doOptions(RevolverHttpRequest request) throws Exception {
        RevolverHttpApiConfig apiConfiguration = (RevolverHttpApiConfig)this.getApiConfiguration();
        URI url = this.getServiceUrl(request, apiConfiguration);
        HttpOptions httpRequest = new HttpOptions(url);
        this.addHeaders(request, (HttpRequestBase)httpRequest);
        this.trackingHeaders(request, (HttpRequestBase)httpRequest);
        return this.executeRequest(apiConfiguration, (HttpRequestBase)httpRequest, true);
    }

    private RevolverHttpResponse doHead(RevolverHttpRequest request) throws Exception {
        RevolverHttpApiConfig apiConfiguration = (RevolverHttpApiConfig)this.getApiConfiguration();
        URI url = this.getServiceUrl(request, apiConfiguration);
        HttpHead httpRequest = new HttpHead(url);
        this.addHeaders(request, (HttpRequestBase)httpRequest);
        this.trackingHeaders(request, (HttpRequestBase)httpRequest);
        return this.executeRequest(apiConfiguration, (HttpRequestBase)httpRequest, false);
    }

    private RevolverHttpResponse doDelete(RevolverHttpRequest request) throws Exception {
        RevolverHttpApiConfig apiConfiguration = (RevolverHttpApiConfig)this.getApiConfiguration();
        URI url = this.getServiceUrl(request, apiConfiguration);
        HttpDelete httpRequest = new HttpDelete(url);
        this.addHeaders(request, (HttpRequestBase)httpRequest);
        this.trackingHeaders(request, (HttpRequestBase)httpRequest);
        return this.executeRequest(apiConfiguration, (HttpRequestBase)httpRequest, true);
    }

    private RevolverHttpResponse doPatch(RevolverHttpRequest request) throws Exception {
        RevolverHttpApiConfig apiConfiguration = (RevolverHttpApiConfig)this.getApiConfiguration();
        URI url = this.getServiceUrl(request, apiConfiguration);
        HttpPatch httpRequest = new HttpPatch(url);
        this.addHeaders(request, (HttpRequestBase)httpRequest);
        if (request.getBody() != null) {
            if (null != request.getHeaders() && StringUtils.isNotBlank((CharSequence)((CharSequence)request.getHeaders().getFirst((Object)"Content-Type")))) {
                httpRequest.setEntity((HttpEntity)new ByteArrayEntity(request.getBody()));
                httpRequest.setHeader("Content-Type", (String)request.getHeaders().getFirst((Object)"Content-Type"));
            } else {
                httpRequest.setEntity((HttpEntity)new ByteArrayEntity(request.getBody(), ContentType.WILDCARD));
            }
        } else {
            httpRequest.setEntity((HttpEntity)new ByteArrayEntity(new byte[0], ContentType.WILDCARD));
        }
        this.trackingHeaders(request, (HttpRequestBase)httpRequest);
        return this.executeRequest(apiConfiguration, (HttpRequestBase)httpRequest, true);
    }

    private RevolverHttpResponse doPost(RevolverHttpRequest request) throws Exception {
        RevolverHttpApiConfig apiConfiguration = (RevolverHttpApiConfig)this.getApiConfiguration();
        URI url = this.getServiceUrl(request, apiConfiguration);
        HttpPost httpRequest = new HttpPost(url);
        this.addHeaders(request, (HttpRequestBase)httpRequest);
        if (request.getBody() != null) {
            if (null != request.getHeaders() && StringUtils.isNotBlank((CharSequence)((CharSequence)request.getHeaders().getFirst((Object)"Content-Type")))) {
                httpRequest.setEntity((HttpEntity)new ByteArrayEntity(request.getBody()));
            } else {
                httpRequest.setEntity((HttpEntity)new ByteArrayEntity(request.getBody()));
            }
        } else {
            httpRequest.setEntity((HttpEntity)new ByteArrayEntity(new byte[0]));
        }
        this.trackingHeaders(request, (HttpRequestBase)httpRequest);
        return this.executeRequest(apiConfiguration, (HttpRequestBase)httpRequest, true);
    }

    private RevolverHttpResponse doPut(RevolverHttpRequest request) throws Exception {
        RevolverHttpApiConfig apiConfiguration = (RevolverHttpApiConfig)this.getApiConfiguration();
        URI url = this.getServiceUrl(request, apiConfiguration);
        HttpPut httpRequest = new HttpPut(url);
        this.addHeaders(request, (HttpRequestBase)httpRequest);
        if (request.getBody() != null) {
            if (null != request.getHeaders() && StringUtils.isNotBlank((CharSequence)((CharSequence)request.getHeaders().getFirst((Object)"Content-Type")))) {
                httpRequest.setEntity((HttpEntity)new ByteArrayEntity(request.getBody()));
            } else {
                httpRequest.setEntity((HttpEntity)new ByteArrayEntity(request.getBody()));
            }
        } else {
            httpRequest.setEntity((HttpEntity)new ByteArrayEntity(new byte[0]));
        }
        this.trackingHeaders(request, (HttpRequestBase)httpRequest);
        return this.executeRequest(apiConfiguration, (HttpRequestBase)httpRequest, true);
    }

    private URI generateURI(RevolverHttpRequest request, RevolverHttpApiConfig apiConfiguration, Endpoint endpoint) throws URISyntaxException {
        URIBuilder builder = new URIBuilder();
        this.addQueryParams(request, builder);
        if (((RevolverHttpServiceConfig)this.getServiceConfiguration()).isSecured()) {
            builder.setScheme("https");
        } else {
            builder.setScheme("http");
        }
        builder.setHost(endpoint.getHost());
        builder.setPort(endpoint.getPort());
        builder.setPath(this.resolvePath(apiConfiguration, request));
        return builder.build();
    }

    private RevolverHttpResponse getHttpResponse(RevolverHttpApiConfig apiConfiguration, HttpResponse response, boolean readBody) throws Exception {
        if (apiConfiguration.getAcceptableResponseCodes() != null && !apiConfiguration.getAcceptableResponseCodes().isEmpty() && !apiConfiguration.getAcceptableResponseCodes().contains(response.getStatusLine().getStatusCode())) {
            if (response.getEntity() != null) {
                log.error("Response: " + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            throw new Exception(String.format("HTTP %s %s failed with [%d - %s]", apiConfiguration.getMethods(), apiConfiguration.getApi(), response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
        }
        MultivaluedHashMap headers = new MultivaluedHashMap();
        Arrays.stream(response.getAllHeaders()).forEach(h -> headers.putSingle((Object)h.getName(), (Object)h.getValue()));
        RevolverHttpResponse.RevolverHttpResponseBuilder revolverResponse = RevolverHttpResponse.builder().statusCode(response.getStatusLine().getStatusCode()).headers((MultivaluedMap<String, String>)headers);
        if (readBody && response.getEntity() != null) {
            revolverResponse.body(EntityUtils.toByteArray((HttpEntity)response.getEntity()));
        }
        return revolverResponse.build();
    }

    private String resolvePath(RevolverHttpApiConfig httpApiConfiguration, RevolverHttpRequest request) {
        String uri = null;
        if (Strings.isNullOrEmpty((String)request.getPath())) {
            if (null != request.getPathParams()) {
                uri = StringSubstitutor.replace((Object)httpApiConfiguration.getPath(), request.getPathParams());
            }
        } else {
            uri = request.getPath();
        }
        if (Strings.isNullOrEmpty((String)uri)) {
            uri = httpApiConfiguration.getPath();
        }
        return uri.charAt(0) == '/' ? uri : "/" + uri;
    }

    private void addQueryParams(RevolverHttpRequest request, URIBuilder builder) {
        if (null != request.getQueryParams()) {
            request.getQueryParams().forEach((key, values) -> values.forEach(value -> builder.addParameter(key, value)));
        }
    }

    private void trackingHeaders(RevolverHttpRequest request, HttpRequestBase requestBuilder) {
        List existing;
        if (!((RevolverHttpServiceConfig)this.getServiceConfiguration()).isTrackingHeaders()) {
            return;
        }
        TraceInfo spanInfo = request.getTrace();
        if (request.getHeaders() == null) {
            request.setHeaders((MultivaluedMap<String, String>)new MultivaluedHashMap());
        }
        if (!(existing = request.getHeaders().keySet().stream().map(String::toLowerCase).collect(Collectors.toList())).contains("X-TRANSACTION-ID".toLowerCase())) {
            requestBuilder.addHeader("X-TRANSACTION-ID", spanInfo.getTransactionId());
        }
        if (!existing.contains("X-REQUEST-ID".toLowerCase())) {
            requestBuilder.addHeader("X-REQUEST-ID", spanInfo.getRequestId());
        }
        if (!existing.contains("X-PARENT-REQUEST-ID".toLowerCase())) {
            requestBuilder.addHeader("X-PARENT-REQUEST-ID", spanInfo.getParentRequestId());
        }
        if (!existing.contains("X-REQUEST-TIMESTAMP".toLowerCase())) {
            requestBuilder.addHeader("X-REQUEST-TIMESTAMP", Long.toString(spanInfo.getTimestamp()));
        }
        if (!existing.contains("X-CLIENT-ID".toLowerCase())) {
            requestBuilder.addHeader("X-CLIENT-ID", this.getClientConfiguration().getClientName());
        }
    }

    private void addHeaders(RevolverHttpRequest request, HttpRequestBase httpRequest) {
        if (null != request.getHeaders()) {
            request.getHeaders().forEach((key, values) -> values.forEach(value -> httpRequest.setHeader(key, value)));
        }
    }

    public static RevolverHttpCommandBuilder builder() {
        return new RevolverHttpCommandBuilder();
    }

    public static class RevolverHttpCommandBuilder {
        private RuntimeConfig runtimeConfig;
        private ClientConfig clientConfiguration;
        private RevolverHttpServiceConfig serviceConfiguration;
        private RevolverHttpApiConfig apiConfiguration;

        RevolverHttpCommandBuilder() {
        }

        public RevolverHttpCommandBuilder runtimeConfig(RuntimeConfig runtimeConfig) {
            this.runtimeConfig = runtimeConfig;
            return this;
        }

        public RevolverHttpCommandBuilder clientConfiguration(ClientConfig clientConfiguration) {
            this.clientConfiguration = clientConfiguration;
            return this;
        }

        public RevolverHttpCommandBuilder serviceConfiguration(RevolverHttpServiceConfig serviceConfiguration) {
            this.serviceConfiguration = serviceConfiguration;
            return this;
        }

        public RevolverHttpCommandBuilder apiConfiguration(RevolverHttpApiConfig apiConfiguration) {
            this.apiConfiguration = apiConfiguration;
            return this;
        }

        public RevolverHttpCommand build() {
            return new RevolverHttpCommand(this.runtimeConfig, this.clientConfiguration, this.serviceConfiguration, this.apiConfiguration);
        }

        public String toString() {
            return "RevolverHttpCommand.RevolverHttpCommandBuilder(runtimeConfig=" + this.runtimeConfig + ", clientConfiguration=" + this.clientConfiguration + ", serviceConfiguration=" + this.serviceConfiguration + ", apiConfiguration=" + this.apiConfiguration + ")";
        }
    }
}

