/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.retry;

import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.base.Predicate;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.retry.RevolverApiRetryConfig;
import io.dropwizard.revolver.retry.ValidResponseFilter;
import io.dropwizard.revolver.retry.WaitStrategy;
import java.util.concurrent.TimeUnit;

public class RetryUtils {
    private static final Retryer<Boolean> DEFAULT_RETRYER = RetryerBuilder.newBuilder().retryIfException().withStopStrategy(StopStrategies.stopAfterAttempt((int)3)).withWaitStrategy(WaitStrategies.exponentialWait((long)10L, (TimeUnit)TimeUnit.SECONDS)).build();
    private static final long INITIAL_WAIT_IN_MILLS = 200L;

    public static Retryer getRetryer(RevolverHttpApiConfig revolverHttpApiConfig) {
        WaitStrategy waitStrategy;
        long incrementByInMillis;
        int maxRetry;
        RevolverApiRetryConfig revolverApiRetryConfig = revolverHttpApiConfig.getRetryConfig();
        int maximumTimeInSeconds = revolverHttpApiConfig.getRetryConfig().getMaximumTimeInSeconds();
        if (maximumTimeInSeconds == 0) {
            maximumTimeInSeconds = 10;
        }
        if ((maxRetry = revolverApiRetryConfig.getMaxRetry()) == 0) {
            maxRetry = 3;
        }
        if ((incrementByInMillis = revolverApiRetryConfig.getIncrementByInMillis()) == 0L) {
            incrementByInMillis = 200L;
        }
        if ((waitStrategy = revolverApiRetryConfig.getWaitStrategy()) == null) {
            waitStrategy = WaitStrategy.EXPONENTIAL;
        }
        switch (waitStrategy) {
            case FIXED: {
                return RetryerBuilder.newBuilder().retryIfResult((Predicate)new ValidResponseFilter()).withStopStrategy(StopStrategies.stopAfterAttempt((int)maxRetry)).withWaitStrategy(WaitStrategies.fixedWait((long)maximumTimeInSeconds, (TimeUnit)TimeUnit.SECONDS)).build();
            }
            case NO_WAIT: {
                return RetryerBuilder.newBuilder().retryIfResult((Predicate)new ValidResponseFilter()).withStopStrategy(StopStrategies.stopAfterAttempt((int)maxRetry)).withWaitStrategy(WaitStrategies.noWait()).build();
            }
            case EXPONENTIAL: {
                return RetryerBuilder.newBuilder().retryIfResult((Predicate)new ValidResponseFilter()).withStopStrategy(StopStrategies.stopAfterAttempt((int)maxRetry)).withWaitStrategy(WaitStrategies.exponentialWait((long)maximumTimeInSeconds, (TimeUnit)TimeUnit.SECONDS)).build();
            }
            case INCREMENTAL: {
                return RetryerBuilder.newBuilder().retryIfResult((Predicate)new ValidResponseFilter()).withStopStrategy(StopStrategies.stopAfterAttempt((int)maxRetry)).withWaitStrategy(WaitStrategies.incrementingWait((long)200L, (TimeUnit)TimeUnit.MILLISECONDS, (long)incrementByInMillis, (TimeUnit)TimeUnit.MILLISECONDS)).build();
            }
            case FIBONACCI: {
                return RetryerBuilder.newBuilder().retryIfResult((Predicate)new ValidResponseFilter()).withStopStrategy(StopStrategies.stopAfterAttempt((int)maxRetry)).withWaitStrategy(WaitStrategies.fibonacciWait((long)maximumTimeInSeconds, (TimeUnit)TimeUnit.SECONDS)).build();
            }
        }
        return DEFAULT_RETRYER;
    }
}

