package io.dropwizard.revolver.optimizer;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.msgpack.jackson.dataformat.Tuple;

import java.util.SortedMap;

/***
 Created by nitish.goyal on 29/03/19
 ***/
@Slf4j
@Builder
@AllArgsConstructor
@Data
public class OptimizerMetricsBuilder implements Runnable {

    private static final String PREFIX = "HystrixThreadPool";
    private MetricRegistry metrics;

    @Override
    public void run() {

        Long time = System.currentTimeMillis();

        SortedMap<String, Gauge> gauges = metrics.getGauges(MetricFilter.startsWith(PREFIX));
        gauges.forEach((k, v) -> {
            String[] splits = k.split(".");
            if(splits.length < 3) {
                return;
            }
            String pool = splits[1];
            Tuple<Long, String> key = new Tuple<>(time, pool);
            if(OptimizerMetricsCache.get(key) == null) {
                OptimizerMetricsCache.put(key, new OptimizerMetrics());
            }
            OptimizerMetrics optimizerMetrics = OptimizerMetricsCache.get(key);

            String metricName = splits[2];
            if(OptimizerUtils.getMetricsToRead()
                       .contains(metricName) && (v.getValue() instanceof Integer)) {
                optimizerMetrics.getMetrics()
                        .put(metricName, (Integer)v.getValue());
            }
        });

    }
}
