/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.optimizer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import io.dropwizard.revolver.optimizer.OptimizerMetrics;
import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.msgpack.jackson.dataformat.Tuple;

public class OptimizerMetricsCache {
    private static LinkedHashMap<Tuple<Long, String>, OptimizerMetrics> poolTimeBasedMetricsMap = new LinkedHashMap();
    private static LoadingCache<Tuple<Long, String>, OptimizerMetrics> cache = CacheBuilder.newBuilder().concurrencyLevel(4).expireAfterWrite(30L, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<Tuple<Long, String>, OptimizerMetrics>(){

        public void onRemoval(RemovalNotification<Tuple<Long, String>, OptimizerMetrics> notification) {
            poolTimeBasedMetricsMap.remove(notification.getKey());
        }
    }).build((CacheLoader)new CacheLoader<Tuple<Long, String>, OptimizerMetrics>(){

        public OptimizerMetrics load(@NonNull Tuple<Long, String> key) throws Exception {
            if (key == null) {
                throw new NullPointerException("key is marked @NonNull but is null");
            }
            return (OptimizerMetrics)poolTimeBasedMetricsMap.get(key);
        }
    });

    public static void put(Tuple<Long, String> key, OptimizerMetrics value) {
        poolTimeBasedMetricsMap.put(key, value);
    }

    public static OptimizerMetrics get(Tuple<Long, String> key) {
        return poolTimeBasedMetricsMap.get(key);
    }
}

