/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.http.config;

import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.config.ThreadPoolGroupConfig;
import io.dropwizard.revolver.discovery.EndpointSpec;
import io.dropwizard.revolver.http.auth.AuthConfig;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.splitting.RevolverHttpServiceSplitConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class RevolverHttpServiceConfig
extends RevolverServiceConfig {
    @NotNull
    @Valid
    private EndpointSpec endpoint;
    private int connectionPoolSize;
    private boolean authEnabled;
    private boolean secured;
    private AuthConfig auth;
    private String keyStorePath;
    private String keystorePassword;
    private Set<RevolverHttpApiConfig> apis;
    private boolean trackingHeaders;
    private boolean compression;
    private int connectionKeepAliveInMillis = 30000;
    private RevolverHttpServiceSplitConfig serviceSplitConfig;

    public RevolverHttpServiceConfig(String type, String service, EndpointSpec enpoint, int connectionPoolSize, boolean authEnabled, boolean secured, AuthConfig auth, String keyStorePath, String keystorePassword, Set<RevolverHttpApiConfig> apis, boolean trackingHeaders, boolean compression, int connectionKeepAliveInMillis, ThreadPoolGroupConfig threadPoolGroupConfig, RevolverHttpServiceSplitConfig serviceSplitConfig) {
        super(type, service);
        this.endpoint = enpoint;
        this.connectionPoolSize = connectionPoolSize;
        this.authEnabled = authEnabled;
        this.auth = auth;
        this.secured = secured;
        this.keyStorePath = keyStorePath;
        this.keystorePassword = keystorePassword;
        this.apis = apis;
        this.trackingHeaders = trackingHeaders;
        this.compression = compression;
        this.connectionKeepAliveInMillis = connectionKeepAliveInMillis;
        this.threadPoolGroupConfig = threadPoolGroupConfig;
        this.serviceSplitConfig = serviceSplitConfig;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof RevolverHttpServiceConfig && ((RevolverHttpServiceConfig)other).getService().equals(this.getService());
    }

    public static RevolverHttpServiceConfigBuilder builder() {
        return new RevolverHttpServiceConfigBuilder();
    }

    public EndpointSpec getEndpoint() {
        return this.endpoint;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public AuthConfig getAuth() {
        return this.auth;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public Set<RevolverHttpApiConfig> getApis() {
        return this.apis;
    }

    public boolean isTrackingHeaders() {
        return this.trackingHeaders;
    }

    public boolean isCompression() {
        return this.compression;
    }

    public int getConnectionKeepAliveInMillis() {
        return this.connectionKeepAliveInMillis;
    }

    public RevolverHttpServiceSplitConfig getServiceSplitConfig() {
        return this.serviceSplitConfig;
    }

    public void setEndpoint(EndpointSpec endpoint) {
        this.endpoint = endpoint;
    }

    public void setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }

    public void setAuthEnabled(boolean authEnabled) {
        this.authEnabled = authEnabled;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    public void setAuth(AuthConfig auth) {
        this.auth = auth;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public void setApis(Set<RevolverHttpApiConfig> apis) {
        this.apis = apis;
    }

    public void setTrackingHeaders(boolean trackingHeaders) {
        this.trackingHeaders = trackingHeaders;
    }

    public void setCompression(boolean compression) {
        this.compression = compression;
    }

    public void setConnectionKeepAliveInMillis(int connectionKeepAliveInMillis) {
        this.connectionKeepAliveInMillis = connectionKeepAliveInMillis;
    }

    public void setServiceSplitConfig(RevolverHttpServiceSplitConfig serviceSplitConfig) {
        this.serviceSplitConfig = serviceSplitConfig;
    }

    public RevolverHttpServiceConfig(EndpointSpec endpoint, int connectionPoolSize, boolean authEnabled, boolean secured, AuthConfig auth, String keyStorePath, String keystorePassword, Set<RevolverHttpApiConfig> apis, boolean trackingHeaders, boolean compression, int connectionKeepAliveInMillis, RevolverHttpServiceSplitConfig serviceSplitConfig) {
        this.endpoint = endpoint;
        this.connectionPoolSize = connectionPoolSize;
        this.authEnabled = authEnabled;
        this.secured = secured;
        this.auth = auth;
        this.keyStorePath = keyStorePath;
        this.keystorePassword = keystorePassword;
        this.apis = apis;
        this.trackingHeaders = trackingHeaders;
        this.compression = compression;
        this.connectionKeepAliveInMillis = connectionKeepAliveInMillis;
        this.serviceSplitConfig = serviceSplitConfig;
    }

    public RevolverHttpServiceConfig() {
    }

    @Override
    public String toString() {
        return "RevolverHttpServiceConfig(super=" + super.toString() + ", endpoint=" + this.getEndpoint() + ", connectionPoolSize=" + this.getConnectionPoolSize() + ", authEnabled=" + this.isAuthEnabled() + ", secured=" + this.isSecured() + ", auth=" + this.getAuth() + ", keyStorePath=" + this.getKeyStorePath() + ", keystorePassword=" + this.getKeystorePassword() + ", apis=" + this.getApis() + ", trackingHeaders=" + this.isTrackingHeaders() + ", compression=" + this.isCompression() + ", connectionKeepAliveInMillis=" + this.getConnectionKeepAliveInMillis() + ", serviceSplitConfig=" + this.getServiceSplitConfig() + ")";
    }

    public static class RevolverHttpServiceConfigBuilder {
        private String type;
        private String service;
        private EndpointSpec enpoint;
        private int connectionPoolSize;
        private boolean authEnabled;
        private boolean secured;
        private AuthConfig auth;
        private String keyStorePath;
        private String keystorePassword;
        private ArrayList<RevolverHttpApiConfig> apis;
        private boolean trackingHeaders;
        private boolean compression;
        private int connectionKeepAliveInMillis;
        private ThreadPoolGroupConfig threadPoolGroupConfig;
        private RevolverHttpServiceSplitConfig serviceSplitConfig;

        RevolverHttpServiceConfigBuilder() {
        }

        public RevolverHttpServiceConfigBuilder type(String type) {
            this.type = type;
            return this;
        }

        public RevolverHttpServiceConfigBuilder service(String service) {
            this.service = service;
            return this;
        }

        public RevolverHttpServiceConfigBuilder enpoint(EndpointSpec enpoint) {
            this.enpoint = enpoint;
            return this;
        }

        public RevolverHttpServiceConfigBuilder connectionPoolSize(int connectionPoolSize) {
            this.connectionPoolSize = connectionPoolSize;
            return this;
        }

        public RevolverHttpServiceConfigBuilder authEnabled(boolean authEnabled) {
            this.authEnabled = authEnabled;
            return this;
        }

        public RevolverHttpServiceConfigBuilder secured(boolean secured) {
            this.secured = secured;
            return this;
        }

        public RevolverHttpServiceConfigBuilder auth(AuthConfig auth) {
            this.auth = auth;
            return this;
        }

        public RevolverHttpServiceConfigBuilder keyStorePath(String keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this;
        }

        public RevolverHttpServiceConfigBuilder keystorePassword(String keystorePassword) {
            this.keystorePassword = keystorePassword;
            return this;
        }

        public RevolverHttpServiceConfigBuilder api(RevolverHttpApiConfig api) {
            if (this.apis == null) {
                this.apis = new ArrayList();
            }
            this.apis.add(api);
            return this;
        }

        public RevolverHttpServiceConfigBuilder apis(Collection<? extends RevolverHttpApiConfig> apis) {
            if (this.apis == null) {
                this.apis = new ArrayList();
            }
            this.apis.addAll(apis);
            return this;
        }

        public RevolverHttpServiceConfigBuilder clearApis() {
            if (this.apis != null) {
                this.apis.clear();
            }
            return this;
        }

        public RevolverHttpServiceConfigBuilder trackingHeaders(boolean trackingHeaders) {
            this.trackingHeaders = trackingHeaders;
            return this;
        }

        public RevolverHttpServiceConfigBuilder compression(boolean compression) {
            this.compression = compression;
            return this;
        }

        public RevolverHttpServiceConfigBuilder connectionKeepAliveInMillis(int connectionKeepAliveInMillis) {
            this.connectionKeepAliveInMillis = connectionKeepAliveInMillis;
            return this;
        }

        public RevolverHttpServiceConfigBuilder threadPoolGroupConfig(ThreadPoolGroupConfig threadPoolGroupConfig) {
            this.threadPoolGroupConfig = threadPoolGroupConfig;
            return this;
        }

        public RevolverHttpServiceConfigBuilder serviceSplitConfig(RevolverHttpServiceSplitConfig serviceSplitConfig) {
            this.serviceSplitConfig = serviceSplitConfig;
            return this;
        }

        public RevolverHttpServiceConfig build() {
            Set<Object> apis;
            switch (this.apis == null ? 0 : this.apis.size()) {
                case 0: {
                    apis = Collections.emptySet();
                    break;
                }
                case 1: {
                    apis = Collections.singleton(this.apis.get(0));
                    break;
                }
                default: {
                    apis = new LinkedHashSet(this.apis.size() < 0x40000000 ? 1 + this.apis.size() + (this.apis.size() - 3) / 3 : Integer.MAX_VALUE);
                    apis.addAll(this.apis);
                    apis = Collections.unmodifiableSet(apis);
                }
            }
            return new RevolverHttpServiceConfig(this.type, this.service, this.enpoint, this.connectionPoolSize, this.authEnabled, this.secured, this.auth, this.keyStorePath, this.keystorePassword, apis, this.trackingHeaders, this.compression, this.connectionKeepAliveInMillis, this.threadPoolGroupConfig, this.serviceSplitConfig);
        }

        public String toString() {
            return "RevolverHttpServiceConfig.RevolverHttpServiceConfigBuilder(type=" + this.type + ", service=" + this.service + ", enpoint=" + this.enpoint + ", connectionPoolSize=" + this.connectionPoolSize + ", authEnabled=" + this.authEnabled + ", secured=" + this.secured + ", auth=" + this.auth + ", keyStorePath=" + this.keyStorePath + ", keystorePassword=" + this.keystorePassword + ", apis=" + this.apis + ", trackingHeaders=" + this.trackingHeaders + ", compression=" + this.compression + ", connectionKeepAliveInMillis=" + this.connectionKeepAliveInMillis + ", threadPoolGroupConfig=" + this.threadPoolGroupConfig + ", serviceSplitConfig=" + this.serviceSplitConfig + ")";
        }
    }
}

