/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.optimizer.config;

public class OptimizerConcurrencyConfig {
    private double maxThreshold = 0.7;
    private double minThreshold = 0.6;
    private double increaseBy = 1.2;
    private double decreaseBy = 0.8;

    public static OptimizerConcurrencyConfigBuilder builder() {
        return new OptimizerConcurrencyConfigBuilder();
    }

    public double getMaxThreshold() {
        return this.maxThreshold;
    }

    public double getMinThreshold() {
        return this.minThreshold;
    }

    public double getIncreaseBy() {
        return this.increaseBy;
    }

    public double getDecreaseBy() {
        return this.decreaseBy;
    }

    public void setMaxThreshold(double maxThreshold) {
        this.maxThreshold = maxThreshold;
    }

    public void setMinThreshold(double minThreshold) {
        this.minThreshold = minThreshold;
    }

    public void setIncreaseBy(double increaseBy) {
        this.increaseBy = increaseBy;
    }

    public void setDecreaseBy(double decreaseBy) {
        this.decreaseBy = decreaseBy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptimizerConcurrencyConfig)) {
            return false;
        }
        OptimizerConcurrencyConfig other = (OptimizerConcurrencyConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getMaxThreshold(), other.getMaxThreshold()) != 0) {
            return false;
        }
        if (Double.compare(this.getMinThreshold(), other.getMinThreshold()) != 0) {
            return false;
        }
        if (Double.compare(this.getIncreaseBy(), other.getIncreaseBy()) != 0) {
            return false;
        }
        return Double.compare(this.getDecreaseBy(), other.getDecreaseBy()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof OptimizerConcurrencyConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxThreshold = Double.doubleToLongBits(this.getMaxThreshold());
        result = result * 59 + (int)($maxThreshold >>> 32 ^ $maxThreshold);
        long $minThreshold = Double.doubleToLongBits(this.getMinThreshold());
        result = result * 59 + (int)($minThreshold >>> 32 ^ $minThreshold);
        long $increaseBy = Double.doubleToLongBits(this.getIncreaseBy());
        result = result * 59 + (int)($increaseBy >>> 32 ^ $increaseBy);
        long $decreaseBy = Double.doubleToLongBits(this.getDecreaseBy());
        result = result * 59 + (int)($decreaseBy >>> 32 ^ $decreaseBy);
        return result;
    }

    public String toString() {
        return "OptimizerConcurrencyConfig(maxThreshold=" + this.getMaxThreshold() + ", minThreshold=" + this.getMinThreshold() + ", increaseBy=" + this.getIncreaseBy() + ", decreaseBy=" + this.getDecreaseBy() + ")";
    }

    public OptimizerConcurrencyConfig(double maxThreshold, double minThreshold, double increaseBy, double decreaseBy) {
        this.maxThreshold = maxThreshold;
        this.minThreshold = minThreshold;
        this.increaseBy = increaseBy;
        this.decreaseBy = decreaseBy;
    }

    public OptimizerConcurrencyConfig() {
    }

    public static class OptimizerConcurrencyConfigBuilder {
        private double maxThreshold;
        private double minThreshold;
        private double increaseBy;
        private double decreaseBy;

        OptimizerConcurrencyConfigBuilder() {
        }

        public OptimizerConcurrencyConfigBuilder maxThreshold(double maxThreshold) {
            this.maxThreshold = maxThreshold;
            return this;
        }

        public OptimizerConcurrencyConfigBuilder minThreshold(double minThreshold) {
            this.minThreshold = minThreshold;
            return this;
        }

        public OptimizerConcurrencyConfigBuilder increaseBy(double increaseBy) {
            this.increaseBy = increaseBy;
            return this;
        }

        public OptimizerConcurrencyConfigBuilder decreaseBy(double decreaseBy) {
            this.decreaseBy = decreaseBy;
            return this;
        }

        public OptimizerConcurrencyConfig build() {
            return new OptimizerConcurrencyConfig(this.maxThreshold, this.minThreshold, this.increaseBy, this.decreaseBy);
        }

        public String toString() {
            return "OptimizerConcurrencyConfig.OptimizerConcurrencyConfigBuilder(maxThreshold=" + this.maxThreshold + ", minThreshold=" + this.minThreshold + ", increaseBy=" + this.increaseBy + ", decreaseBy=" + this.decreaseBy + ")";
        }
    }
}

