/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.optimizer.utils;

import com.google.common.collect.Lists;
import io.dropwizard.revolver.optimizer.config.OptimizerConcurrencyConfig;
import io.dropwizard.revolver.optimizer.config.OptimizerConfig;
import io.dropwizard.revolver.optimizer.config.OptimizerConfigUpdaterConfig;
import io.dropwizard.revolver.optimizer.config.OptimizerMetricsCollectorConfig;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class OptimizerUtils {
    public static final String ROLLING_MAX_ACTIVE_THREADS = "rollingMaxActiveThreads";
    public static final String THREAD_POOL_PREFIX = "HystrixThreadPool";
    private static final List<String> METRICS_TO_READ = Lists.newArrayList((Object[])new String[]{"propertyValue_maximumSize", "rollingMaxActiveThreads"});

    public static List<String> getMetricsToRead() {
        return Collections.unmodifiableList(METRICS_TO_READ);
    }

    public static OptimizerConfig getDefaultOptimizerConfig() {
        return OptimizerConfig.builder().initialDelay(5).timeUnit(TimeUnit.MINUTES).concurrencyConfig(OptimizerConcurrencyConfig.builder().bandwidth(1.3).minThreshold(0.5).maxThreshold(0.85).build()).configUpdaterConfig(OptimizerConfigUpdaterConfig.builder().repeatAfter(5).build()).metricsCollectorConfig(OptimizerMetricsCollectorConfig.builder().repeatAfter(30).timeUnit(TimeUnit.SECONDS).cachingWindowInMinutes(15).concurrency(3).build()).enabled(true).build();
    }
}

