/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.config;

public class LatencyConfig {
    private boolean downgradable;
    private double latencyMetricValue;
    private double threshold;

    public static LatencyConfigBuilder builder() {
        return new LatencyConfigBuilder();
    }

    public boolean isDowngradable() {
        return this.downgradable;
    }

    public double getLatencyMetricValue() {
        return this.latencyMetricValue;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setDowngradable(boolean downgradable) {
        this.downgradable = downgradable;
    }

    public void setLatencyMetricValue(double latencyMetricValue) {
        this.latencyMetricValue = latencyMetricValue;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LatencyConfig)) {
            return false;
        }
        LatencyConfig other = (LatencyConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDowngradable() != other.isDowngradable()) {
            return false;
        }
        if (Double.compare(this.getLatencyMetricValue(), other.getLatencyMetricValue()) != 0) {
            return false;
        }
        return Double.compare(this.getThreshold(), other.getThreshold()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof LatencyConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDowngradable() ? 79 : 97);
        long $latencyMetricValue = Double.doubleToLongBits(this.getLatencyMetricValue());
        result = result * 59 + (int)($latencyMetricValue >>> 32 ^ $latencyMetricValue);
        long $threshold = Double.doubleToLongBits(this.getThreshold());
        result = result * 59 + (int)($threshold >>> 32 ^ $threshold);
        return result;
    }

    public String toString() {
        return "LatencyConfig(downgradable=" + this.isDowngradable() + ", latencyMetricValue=" + this.getLatencyMetricValue() + ", threshold=" + this.getThreshold() + ")";
    }

    public LatencyConfig() {
    }

    public LatencyConfig(boolean downgradable, double latencyMetricValue, double threshold) {
        this.downgradable = downgradable;
        this.latencyMetricValue = latencyMetricValue;
        this.threshold = threshold;
    }

    public static class LatencyConfigBuilder {
        private boolean downgradable;
        private double latencyMetricValue;
        private double threshold;

        LatencyConfigBuilder() {
        }

        public LatencyConfigBuilder downgradable(boolean downgradable) {
            this.downgradable = downgradable;
            return this;
        }

        public LatencyConfigBuilder latencyMetricValue(double latencyMetricValue) {
            this.latencyMetricValue = latencyMetricValue;
            return this;
        }

        public LatencyConfigBuilder threshold(double threshold) {
            this.threshold = threshold;
            return this;
        }

        public LatencyConfig build() {
            return new LatencyConfig(this.downgradable, this.latencyMetricValue, this.threshold);
        }

        public String toString() {
            return "LatencyConfig.LatencyConfigBuilder(downgradable=" + this.downgradable + ", latencyMetricValue=" + this.latencyMetricValue + ", threshold=" + this.threshold + ")";
        }
    }
}

