/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.optimizer.config;

import com.google.common.collect.Lists;
import java.util.List;

public class OptimizerTimeoutConfig {
    private List<String> latencyMetrics = Lists.newArrayList((Object[])new String[]{"latencyExecute_percentile_99", "latencyExecute_percentile_50"});
    private String timeoutMetric = "latencyExecute_percentile_99";
    private double getMethodTimeoutBuffer = 1.2;
    private double allMethodTimeoutBuffer = 1.4;

    public static OptimizerTimeoutConfigBuilder builder() {
        return new OptimizerTimeoutConfigBuilder();
    }

    public List<String> getLatencyMetrics() {
        return this.latencyMetrics;
    }

    public String getTimeoutMetric() {
        return this.timeoutMetric;
    }

    public double getGetMethodTimeoutBuffer() {
        return this.getMethodTimeoutBuffer;
    }

    public double getAllMethodTimeoutBuffer() {
        return this.allMethodTimeoutBuffer;
    }

    public void setLatencyMetrics(List<String> latencyMetrics) {
        this.latencyMetrics = latencyMetrics;
    }

    public void setTimeoutMetric(String timeoutMetric) {
        this.timeoutMetric = timeoutMetric;
    }

    public void setGetMethodTimeoutBuffer(double getMethodTimeoutBuffer) {
        this.getMethodTimeoutBuffer = getMethodTimeoutBuffer;
    }

    public void setAllMethodTimeoutBuffer(double allMethodTimeoutBuffer) {
        this.allMethodTimeoutBuffer = allMethodTimeoutBuffer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptimizerTimeoutConfig)) {
            return false;
        }
        OptimizerTimeoutConfig other = (OptimizerTimeoutConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$latencyMetrics = this.getLatencyMetrics();
        List<String> other$latencyMetrics = other.getLatencyMetrics();
        if (this$latencyMetrics == null ? other$latencyMetrics != null : !((Object)this$latencyMetrics).equals(other$latencyMetrics)) {
            return false;
        }
        String this$timeoutMetric = this.getTimeoutMetric();
        String other$timeoutMetric = other.getTimeoutMetric();
        if (this$timeoutMetric == null ? other$timeoutMetric != null : !this$timeoutMetric.equals(other$timeoutMetric)) {
            return false;
        }
        if (Double.compare(this.getGetMethodTimeoutBuffer(), other.getGetMethodTimeoutBuffer()) != 0) {
            return false;
        }
        return Double.compare(this.getAllMethodTimeoutBuffer(), other.getAllMethodTimeoutBuffer()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof OptimizerTimeoutConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $latencyMetrics = this.getLatencyMetrics();
        result = result * 59 + ($latencyMetrics == null ? 43 : ((Object)$latencyMetrics).hashCode());
        String $timeoutMetric = this.getTimeoutMetric();
        result = result * 59 + ($timeoutMetric == null ? 43 : $timeoutMetric.hashCode());
        long $getMethodTimeoutBuffer = Double.doubleToLongBits(this.getGetMethodTimeoutBuffer());
        result = result * 59 + (int)($getMethodTimeoutBuffer >>> 32 ^ $getMethodTimeoutBuffer);
        long $allMethodTimeoutBuffer = Double.doubleToLongBits(this.getAllMethodTimeoutBuffer());
        result = result * 59 + (int)($allMethodTimeoutBuffer >>> 32 ^ $allMethodTimeoutBuffer);
        return result;
    }

    public String toString() {
        return "OptimizerTimeoutConfig(latencyMetrics=" + this.getLatencyMetrics() + ", timeoutMetric=" + this.getTimeoutMetric() + ", getMethodTimeoutBuffer=" + this.getGetMethodTimeoutBuffer() + ", allMethodTimeoutBuffer=" + this.getAllMethodTimeoutBuffer() + ")";
    }

    public OptimizerTimeoutConfig(List<String> latencyMetrics, String timeoutMetric, double getMethodTimeoutBuffer, double allMethodTimeoutBuffer) {
        this.latencyMetrics = latencyMetrics;
        this.timeoutMetric = timeoutMetric;
        this.getMethodTimeoutBuffer = getMethodTimeoutBuffer;
        this.allMethodTimeoutBuffer = allMethodTimeoutBuffer;
    }

    public OptimizerTimeoutConfig() {
    }

    public static class OptimizerTimeoutConfigBuilder {
        private List<String> latencyMetrics;
        private String timeoutMetric;
        private double getMethodTimeoutBuffer;
        private double allMethodTimeoutBuffer;

        OptimizerTimeoutConfigBuilder() {
        }

        public OptimizerTimeoutConfigBuilder latencyMetrics(List<String> latencyMetrics) {
            this.latencyMetrics = latencyMetrics;
            return this;
        }

        public OptimizerTimeoutConfigBuilder timeoutMetric(String timeoutMetric) {
            this.timeoutMetric = timeoutMetric;
            return this;
        }

        public OptimizerTimeoutConfigBuilder getMethodTimeoutBuffer(double getMethodTimeoutBuffer) {
            this.getMethodTimeoutBuffer = getMethodTimeoutBuffer;
            return this;
        }

        public OptimizerTimeoutConfigBuilder allMethodTimeoutBuffer(double allMethodTimeoutBuffer) {
            this.allMethodTimeoutBuffer = allMethodTimeoutBuffer;
            return this;
        }

        public OptimizerTimeoutConfig build() {
            return new OptimizerTimeoutConfig(this.latencyMetrics, this.timeoutMetric, this.getMethodTimeoutBuffer, this.allMethodTimeoutBuffer);
        }

        public String toString() {
            return "OptimizerTimeoutConfig.OptimizerTimeoutConfigBuilder(latencyMetrics=" + this.latencyMetrics + ", timeoutMetric=" + this.timeoutMetric + ", getMethodTimeoutBuffer=" + this.getMethodTimeoutBuffer + ", allMethodTimeoutBuffer=" + this.allMethodTimeoutBuffer + ")";
        }
    }
}

