/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.discovery;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.ranger.healthcheck.HealthcheckStatus;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import io.dropwizard.discovery.client.io.dropwizard.ranger.ServiceDiscoveryClient;
import io.dropwizard.revolver.discovery.EndpointSpec;
import io.dropwizard.revolver.discovery.ServiceResolverConfig;
import io.dropwizard.revolver.discovery.SpecVisitor;
import io.dropwizard.revolver.discovery.model.Endpoint;
import io.dropwizard.revolver.discovery.model.RangerEndpointSpec;
import io.dropwizard.revolver.discovery.model.SimpleEndpointSpec;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevolverServiceResolver {
    private static final Logger log = LoggerFactory.getLogger(RevolverServiceResolver.class);
    private ObjectMapper objectMapper;
    private final boolean discoverEnabled;
    private final CuratorFramework curatorFramework;
    private final ServiceResolverConfig resolverConfig;
    private Map<String, ServiceDiscoveryClient> serviceFinders = Maps.newConcurrentMap();
    private final ExecutorService executorService = Executors.newCachedThreadPool();

    public RevolverServiceResolver(ServiceResolverConfig resolverConfig, ObjectMapper objectMapper) {
        this.resolverConfig = resolverConfig;
        this.objectMapper = objectMapper;
        if (resolverConfig != null) {
            if (!Strings.isNullOrEmpty((String)resolverConfig.getZkConnectionString())) {
                this.curatorFramework = CuratorFrameworkFactory.builder().connectString(resolverConfig.getZkConnectionString()).namespace(resolverConfig.getNamespace()).retryPolicy((RetryPolicy)new RetryNTimes(1000, 500)).build();
                this.curatorFramework.start();
                this.discoverEnabled = true;
            } else {
                this.discoverEnabled = false;
                this.curatorFramework = null;
            }
        } else {
            this.discoverEnabled = false;
            this.curatorFramework = null;
        }
    }

    public RevolverServiceResolver(ServiceResolverConfig resolverConfig, ObjectMapper objectMapper, CuratorFramework curatorFramework) {
        this.resolverConfig = resolverConfig;
        this.objectMapper = objectMapper;
        this.curatorFramework = curatorFramework;
        this.discoverEnabled = true;
    }

    public Endpoint resolve(EndpointSpec endpointSpecification) {
        return new SpecResolver(this.discoverEnabled, this.serviceFinders).resolve(endpointSpecification);
    }

    public void register(EndpointSpec endpointSpecification) {
        endpointSpecification.accept(new SpecVisitor(){

            @Override
            public void visit(SimpleEndpointSpec simpleEndpointSpecification) {
                log.info("Initialized simple service: " + simpleEndpointSpecification.getHost());
            }

            @Override
            public void visit(RangerEndpointSpec rangerEndpointSpecification) {
                try {
                    if (!RevolverServiceResolver.this.serviceFinders.containsKey(rangerEndpointSpecification.getService())) {
                        ServiceDiscoveryClient discoveryClient = ServiceDiscoveryClient.fromCurator().curator(RevolverServiceResolver.this.curatorFramework).environment(rangerEndpointSpecification.getEnvironment()).namespace(RevolverServiceResolver.this.resolverConfig.getNamespace()).objectMapper(RevolverServiceResolver.this.objectMapper).serviceName(rangerEndpointSpecification.getService()).build();
                        RevolverServiceResolver.this.serviceFinders.put(rangerEndpointSpecification.getService(), discoveryClient);
                        RevolverServiceResolver.this.executorService.submit(() -> {
                            try {
                                log.info("Service finder starting for: " + rangerEndpointSpecification.getService());
                                discoveryClient.start();
                                log.info("Initialized ZK service: " + rangerEndpointSpecification.getService());
                            }
                            catch (Exception e) {
                                log.error("Error registering service finder started for: " + rangerEndpointSpecification.getService(), (Throwable)e);
                            }
                            return null;
                        });
                    }
                }
                catch (Exception e) {
                    log.error("Error registering hander for service: " + rangerEndpointSpecification.getService(), (Throwable)e);
                }
            }
        });
    }

    public static RevolverServiceResolverBuilder builder() {
        return new RevolverServiceResolverBuilder();
    }

    public static RevolverServiceResolverBuilder usingCurator() {
        return new RevolverServiceResolverBuilder();
    }

    public Map<String, ServiceDiscoveryClient> getServiceFinders() {
        return this.serviceFinders;
    }

    public static class RevolverServiceResolverBuilder {
        private ServiceResolverConfig resolverConfig;
        private ObjectMapper objectMapper;
        private CuratorFramework curatorFramework;

        RevolverServiceResolverBuilder() {
        }

        public RevolverServiceResolverBuilder resolverConfig(ServiceResolverConfig resolverConfig) {
            this.resolverConfig = resolverConfig;
            return this;
        }

        public RevolverServiceResolverBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public RevolverServiceResolver build() {
            return new RevolverServiceResolver(this.resolverConfig, this.objectMapper);
        }

        public String toString() {
            return "RevolverServiceResolver.RevolverServiceResolverBuilder(resolverConfig=" + this.resolverConfig + ", objectMapper=" + this.objectMapper + ")";
        }

        public RevolverServiceResolverBuilder curatorFramework(CuratorFramework curatorFramework) {
            this.curatorFramework = curatorFramework;
            return this;
        }
    }

    private static class SpecResolver
    implements SpecVisitor {
        private Endpoint endpoint;
        private final boolean discoverEnabled;
        private final Map<String, ServiceDiscoveryClient> serviceDiscoveryClients;

        private SpecResolver(boolean discoverEnabled, Map<String, ServiceDiscoveryClient> serviceDiscoveryClients) {
            this.discoverEnabled = discoverEnabled;
            this.serviceDiscoveryClients = serviceDiscoveryClients;
        }

        @Override
        public void visit(SimpleEndpointSpec simpleEndpointSpecification) {
            this.endpoint = Endpoint.builder().host(simpleEndpointSpecification.getHost()).port(simpleEndpointSpecification.getPort()).build();
        }

        @Override
        public void visit(RangerEndpointSpec rangerEndpointSpecification) {
            if (!this.discoverEnabled) {
                throw new IllegalAccessError("Zookeeper is not initialized in config. Discovery based lookups will not be possible.");
            }
            Optional node = this.serviceDiscoveryClients.get(rangerEndpointSpecification.getService()).getNode();
            node.ifPresent(n -> {
                if (n.getHealthcheckStatus() == HealthcheckStatus.healthy) {
                    this.endpoint = Endpoint.builder().host(n.getHost()).port(n.getPort()).build();
                }
            });
        }

        Endpoint resolve(EndpointSpec specification) {
            specification.accept(this);
            return this.endpoint;
        }
    }
}

