/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.optimizer;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Maps;
import io.dropwizard.revolver.optimizer.OptimizerMetrics;
import io.dropwizard.revolver.optimizer.OptimizerMetricsCache;
import io.dropwizard.revolver.optimizer.utils.OptimizerUtils;
import java.util.SortedMap;
import org.msgpack.jackson.dataformat.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizerMetricsCollector
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(OptimizerMetricsCollector.class);
    private MetricRegistry metrics;
    private OptimizerMetricsCache optimizerMetricsCache;

    @Override
    public void run() {
        Long time = System.currentTimeMillis();
        SortedMap gauges = this.metrics.getGauges(MetricFilter.startsWith((String)"HystrixThreadPool"));
        gauges.forEach((k, v) -> {
            OptimizerMetrics optimizerMetrics;
            String[] splits = k.split("\\.");
            if (splits.length < 3) {
                return;
            }
            int length = splits.length;
            String metricName = splits[length - 1];
            if (!OptimizerUtils.getMetricsToRead().contains(metricName) || !(v.getValue() instanceof Number)) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            String delimiter = "";
            for (int i = 1; i < length - 1; ++i) {
                sb.append(delimiter);
                sb.append(splits[i]);
                delimiter = ".";
            }
            Tuple key = new Tuple((Object)time, (Object)sb.toString());
            if (this.optimizerMetricsCache.get((Tuple<Long, String>)key) == null) {
                this.optimizerMetricsCache.put((Tuple<Long, String>)key, OptimizerMetrics.builder().metrics(Maps.newHashMap()).build());
            }
            if ((optimizerMetrics = this.optimizerMetricsCache.get((Tuple<Long, String>)key)) == null) {
                return;
            }
            optimizerMetrics.getMetrics().put(metricName, (Number)v.getValue());
        });
    }

    public static OptimizerMetricsCollectorBuilder builder() {
        return new OptimizerMetricsCollectorBuilder();
    }

    public OptimizerMetricsCollector(MetricRegistry metrics, OptimizerMetricsCache optimizerMetricsCache) {
        this.metrics = metrics;
        this.optimizerMetricsCache = optimizerMetricsCache;
    }

    public MetricRegistry getMetrics() {
        return this.metrics;
    }

    public OptimizerMetricsCache getOptimizerMetricsCache() {
        return this.optimizerMetricsCache;
    }

    public void setMetrics(MetricRegistry metrics) {
        this.metrics = metrics;
    }

    public void setOptimizerMetricsCache(OptimizerMetricsCache optimizerMetricsCache) {
        this.optimizerMetricsCache = optimizerMetricsCache;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptimizerMetricsCollector)) {
            return false;
        }
        OptimizerMetricsCollector other = (OptimizerMetricsCollector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MetricRegistry this$metrics = this.getMetrics();
        MetricRegistry other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !this$metrics.equals(other$metrics)) {
            return false;
        }
        OptimizerMetricsCache this$optimizerMetricsCache = this.getOptimizerMetricsCache();
        OptimizerMetricsCache other$optimizerMetricsCache = other.getOptimizerMetricsCache();
        return !(this$optimizerMetricsCache == null ? other$optimizerMetricsCache != null : !((Object)this$optimizerMetricsCache).equals(other$optimizerMetricsCache));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OptimizerMetricsCollector;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MetricRegistry $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : $metrics.hashCode());
        OptimizerMetricsCache $optimizerMetricsCache = this.getOptimizerMetricsCache();
        result = result * 59 + ($optimizerMetricsCache == null ? 43 : ((Object)$optimizerMetricsCache).hashCode());
        return result;
    }

    public String toString() {
        return "OptimizerMetricsCollector(metrics=" + this.getMetrics() + ", optimizerMetricsCache=" + this.getOptimizerMetricsCache() + ")";
    }

    public static class OptimizerMetricsCollectorBuilder {
        private MetricRegistry metrics;
        private OptimizerMetricsCache optimizerMetricsCache;

        OptimizerMetricsCollectorBuilder() {
        }

        public OptimizerMetricsCollectorBuilder metrics(MetricRegistry metrics) {
            this.metrics = metrics;
            return this;
        }

        public OptimizerMetricsCollectorBuilder optimizerMetricsCache(OptimizerMetricsCache optimizerMetricsCache) {
            this.optimizerMetricsCache = optimizerMetricsCache;
            return this;
        }

        public OptimizerMetricsCollector build() {
            return new OptimizerMetricsCollector(this.metrics, this.optimizerMetricsCache);
        }

        public String toString() {
            return "OptimizerMetricsCollector.OptimizerMetricsCollectorBuilder(metrics=" + this.metrics + ", optimizerMetricsCache=" + this.optimizerMetricsCache + ")";
        }
    }
}

