/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.config;

import javax.ws.rs.DefaultValue;

public class ApiLatencyConfig {
    @DefaultValue(value="true")
    private boolean downgradable;
    private double latencyMetricValue;

    public static ApiLatencyConfigBuilder builder() {
        return new ApiLatencyConfigBuilder();
    }

    public boolean isDowngradable() {
        return this.downgradable;
    }

    public double getLatencyMetricValue() {
        return this.latencyMetricValue;
    }

    public void setDowngradable(boolean downgradable) {
        this.downgradable = downgradable;
    }

    public void setLatencyMetricValue(double latencyMetricValue) {
        this.latencyMetricValue = latencyMetricValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiLatencyConfig)) {
            return false;
        }
        ApiLatencyConfig other = (ApiLatencyConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDowngradable() != other.isDowngradable()) {
            return false;
        }
        return Double.compare(this.getLatencyMetricValue(), other.getLatencyMetricValue()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiLatencyConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDowngradable() ? 79 : 97);
        long $latencyMetricValue = Double.doubleToLongBits(this.getLatencyMetricValue());
        result = result * 59 + (int)($latencyMetricValue >>> 32 ^ $latencyMetricValue);
        return result;
    }

    public String toString() {
        return "ApiLatencyConfig(downgradable=" + this.isDowngradable() + ", latencyMetricValue=" + this.getLatencyMetricValue() + ")";
    }

    public ApiLatencyConfig() {
    }

    public ApiLatencyConfig(boolean downgradable, double latencyMetricValue) {
        this.downgradable = downgradable;
        this.latencyMetricValue = latencyMetricValue;
    }

    public static class ApiLatencyConfigBuilder {
        private boolean downgradable;
        private double latencyMetricValue;

        ApiLatencyConfigBuilder() {
        }

        public ApiLatencyConfigBuilder downgradable(boolean downgradable) {
            this.downgradable = downgradable;
            return this;
        }

        public ApiLatencyConfigBuilder latencyMetricValue(double latencyMetricValue) {
            this.latencyMetricValue = latencyMetricValue;
            return this;
        }

        public ApiLatencyConfig build() {
            return new ApiLatencyConfig(this.downgradable, this.latencyMetricValue);
        }

        public String toString() {
            return "ApiLatencyConfig.ApiLatencyConfigBuilder(downgradable=" + this.downgradable + ", latencyMetricValue=" + this.latencyMetricValue + ")";
        }
    }
}

