/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.config;

import javax.ws.rs.DefaultValue;

public class ApiLatencyConfig {
    @DefaultValue(value="true")
    private boolean downgradable;
    private double latency;

    public static ApiLatencyConfigBuilder builder() {
        return new ApiLatencyConfigBuilder();
    }

    public boolean isDowngradable() {
        return this.downgradable;
    }

    public double getLatency() {
        return this.latency;
    }

    public void setDowngradable(boolean downgradable) {
        this.downgradable = downgradable;
    }

    public void setLatency(double latency) {
        this.latency = latency;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiLatencyConfig)) {
            return false;
        }
        ApiLatencyConfig other = (ApiLatencyConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDowngradable() != other.isDowngradable()) {
            return false;
        }
        return Double.compare(this.getLatency(), other.getLatency()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiLatencyConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDowngradable() ? 79 : 97);
        long $latency = Double.doubleToLongBits(this.getLatency());
        result = result * 59 + (int)($latency >>> 32 ^ $latency);
        return result;
    }

    public String toString() {
        return "ApiLatencyConfig(downgradable=" + this.isDowngradable() + ", latency=" + this.getLatency() + ")";
    }

    public ApiLatencyConfig() {
    }

    public ApiLatencyConfig(boolean downgradable, double latency) {
        this.downgradable = downgradable;
        this.latency = latency;
    }

    public static class ApiLatencyConfigBuilder {
        private boolean downgradable;
        private double latency;

        ApiLatencyConfigBuilder() {
        }

        public ApiLatencyConfigBuilder downgradable(boolean downgradable) {
            this.downgradable = downgradable;
            return this;
        }

        public ApiLatencyConfigBuilder latency(double latency) {
            this.latency = latency;
            return this;
        }

        public ApiLatencyConfig build() {
            return new ApiLatencyConfig(this.downgradable, this.latency);
        }

        public String toString() {
            return "ApiLatencyConfig.ApiLatencyConfigBuilder(downgradable=" + this.downgradable + ", latency=" + this.latency + ")";
        }
    }
}

