/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.optimizer;

import com.google.common.collect.Maps;
import io.dropwizard.revolver.RevolverBundle;
import io.dropwizard.revolver.core.config.ApiLatencyConfig;
import io.dropwizard.revolver.core.config.RevolverConfig;
import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.config.hystrix.ThreadPoolConfig;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.http.config.RevolverHttpServiceConfig;
import io.dropwizard.revolver.optimizer.OptimizerAggregatedMetrics;
import io.dropwizard.revolver.optimizer.OptimizerCacheKey;
import io.dropwizard.revolver.optimizer.OptimizerMetrics;
import io.dropwizard.revolver.optimizer.OptimizerMetricsCache;
import io.dropwizard.revolver.optimizer.config.OptimizerConcurrencyConfig;
import io.dropwizard.revolver.optimizer.config.OptimizerConfig;
import io.dropwizard.revolver.optimizer.config.OptimizerTimeConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevolverConfigUpdater
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(RevolverConfigUpdater.class);
    private RevolverConfig revolverConfig;
    private OptimizerConfig optimizerConfig;
    private OptimizerMetricsCache optimizerMetricsCache;

    @Override
    public void run() {
        log.info("Running revolver config updater job");
        HashMap optimizerAggregatedMetricsMap = Maps.newHashMap();
        Map<OptimizerCacheKey, OptimizerMetrics> metricsCache = this.optimizerMetricsCache.getCache();
        if (metricsCache.isEmpty()) {
            log.info("Metrics cache is empty");
            return;
        }
        HashMap keyVsMetricCount = Maps.newHashMap();
        AtomicLong metricsCount = new AtomicLong(0L);
        HashMap aggregatedAppLevelMetricsValues = Maps.newHashMap();
        metricsCache.forEach((key, optimizerMetrics) -> {
            if (optimizerAggregatedMetricsMap.get(key.getName()) == null) {
                optimizerAggregatedMetricsMap.put(key.getName(), OptimizerAggregatedMetrics.builder().metricsAggValueMap(Maps.newHashMap()).build());
            }
            OptimizerAggregatedMetrics optimizerAggregatedMetrics = (OptimizerAggregatedMetrics)optimizerAggregatedMetricsMap.get(key.getName());
            Map<String, Number> aggregatedMetricsValues = optimizerAggregatedMetrics.getMetricsAggValueMap();
            optimizerMetrics.getMetrics().forEach((metric, value) -> {
                this.aggregateAppLevelMetrics(aggregatedAppLevelMetricsValues, (String)metric, (Number)value, metricsCount);
                this.aggregateApiLevelMetrics((OptimizerMetrics)optimizerMetrics, aggregatedMetricsValues, (String)metric, (Number)value, keyVsMetricCount, (OptimizerCacheKey)key);
            });
        });
        this.updateAvgOfMetrics(keyVsMetricCount, optimizerAggregatedMetricsMap, aggregatedAppLevelMetricsValues, metricsCount);
        this.updateRevolverConfig(optimizerAggregatedMetricsMap);
        this.updateLatencyThreshold(aggregatedAppLevelMetricsValues);
    }

    private void updateAvgOfMetrics(Map<String, Integer> keyVsMetricCount, Map<String, OptimizerAggregatedMetrics> optimizerAggregatedMetricsMap, Map<String, Number> aggregatedAppLevelMetricsValues, AtomicLong metricsCount) {
        keyVsMetricCount.forEach((k, v) -> {
            OptimizerAggregatedMetrics optimizerAggregatedMetrics = (OptimizerAggregatedMetrics)optimizerAggregatedMetricsMap.get(k);
            optimizerAggregatedMetrics.getMetricsAggValueMap().forEach((metric, aggregatedValue) -> {
                if (v != 0) {
                    optimizerAggregatedMetrics.getMetricsAggValueMap().put((String)metric, aggregatedValue.intValue() / v);
                }
            });
        });
        aggregatedAppLevelMetricsValues.forEach((k, v) -> aggregatedAppLevelMetricsValues.put((String)k, (long)v.intValue() / metricsCount.get()));
    }

    private void updateLatencyThreshold(Map<String, Number> aggregatedAppLevelMetricsValues) {
        OptimizerTimeConfig optimizerTimeConfig = this.optimizerConfig.getTimeConfig();
        if (optimizerTimeConfig == null || !optimizerTimeConfig.isEnabled() || aggregatedAppLevelMetricsValues.get(optimizerTimeConfig.getAppLatencyMetric()) == null) {
            return;
        }
        int latencyThresholdValue = aggregatedAppLevelMetricsValues.get(optimizerTimeConfig.getAppLatencyMetric()).intValue();
        optimizerTimeConfig.setAppLatencyThresholdValue(latencyThresholdValue);
    }

    private void aggregateAppLevelMetrics(Map<String, Number> aggregatedAppLevelMetricsValues, String metric, Number value, AtomicLong metricsCount) {
        OptimizerTimeConfig optimizerTimeConfig = this.optimizerConfig.getTimeConfig();
        if (optimizerTimeConfig == null || !optimizerTimeConfig.isEnabled() || !optimizerTimeConfig.getAppLatencyMetric().equals(metric) || value.intValue() == 0) {
            return;
        }
        metricsCount.addAndGet(1L);
        if (aggregatedAppLevelMetricsValues.get(metric) == null) {
            aggregatedAppLevelMetricsValues.put(metric, value);
        } else {
            aggregatedAppLevelMetricsValues.put(metric, aggregatedAppLevelMetricsValues.get(metric).intValue() + value.intValue());
        }
        if ("latencyExecute_percentile_995".equals(metric)) {
            log.error("Aggregated 99%ile for app : " + (long)aggregatedAppLevelMetricsValues.get(metric).intValue() / metricsCount.get());
        }
    }

    private void aggregateApiLevelMetrics(OptimizerMetrics optimizerMetrics, Map<String, Number> aggregatedMetricsValues, String metric, Number value, Map<String, Integer> keyVsMetricCount, OptimizerCacheKey key) {
        OptimizerMetrics.AggregationAlgo aggregationAlgo = optimizerMetrics.getAggregationAlgo();
        switch (aggregationAlgo) {
            case MAX: {
                if (aggregatedMetricsValues.get(metric) != null && aggregatedMetricsValues.get(metric).intValue() >= value.intValue()) break;
                aggregatedMetricsValues.put(metric, value);
                break;
            }
            case AVG: {
                keyVsMetricCount.putIfAbsent(key.getName(), 0);
                if (aggregatedMetricsValues.get(metric) == null) {
                    aggregatedMetricsValues.put(metric, value);
                    keyVsMetricCount.put(key.getName(), 1);
                    break;
                }
                keyVsMetricCount.put(key.getName(), keyVsMetricCount.get(key.getName()) + 1);
                aggregatedMetricsValues.put(metric, aggregatedMetricsValues.get(metric).intValue() + value.intValue());
            }
        }
    }

    private void updateRevolverConfig(Map<String, OptimizerAggregatedMetrics> optimizerAggregatedMetricsMap) {
        AtomicBoolean configUpdated = new AtomicBoolean();
        this.revolverConfig.getServices().forEach(revolverServiceConfig -> {
            if (revolverServiceConfig.getThreadPoolGroupConfig() != null) {
                revolverServiceConfig.getThreadPoolGroupConfig().getThreadPools().forEach(threadPoolConfig -> this.updatedPoolSettings((ThreadPoolConfig)threadPoolConfig, optimizerAggregatedMetricsMap, configUpdated));
            }
            if (revolverServiceConfig instanceof RevolverHttpServiceConfig) {
                ((RevolverHttpServiceConfig)revolverServiceConfig).getApis().forEach(api -> this.updatedApiSettings((RevolverServiceConfig)revolverServiceConfig, (RevolverHttpApiConfig)api, optimizerAggregatedMetricsMap, configUpdated));
            }
        });
        if (configUpdated.get()) {
            RevolverBundle.loadServiceConfiguration(this.revolverConfig);
        }
    }

    private void updatedPoolSettings(ThreadPoolConfig threadPoolConfig, Map<String, OptimizerAggregatedMetrics> optimizerAggregatedMetricsMap, AtomicBoolean configUpdated) {
        if (!this.optimizerConfig.getConcurrencyConfig().isEnabled()) {
            return;
        }
        OptimizerAggregatedMetrics optimizerAggregatedMetrics = optimizerAggregatedMetricsMap.get(threadPoolConfig.getThreadPoolName());
        if (optimizerAggregatedMetrics == null) {
            return;
        }
        this.updateConcurrencySetting(threadPoolConfig, optimizerAggregatedMetrics, configUpdated, threadPoolConfig.getThreadPoolName());
    }

    private void updatedApiSettings(RevolverServiceConfig revolverServiceConfig, RevolverHttpApiConfig api, Map<String, OptimizerAggregatedMetrics> optimizerAggregatedMetricsMap, AtomicBoolean configUpdated) {
        String key = revolverServiceConfig.getService() + "." + api.getApi();
        OptimizerAggregatedMetrics optimizerAggregatedMetrics = optimizerAggregatedMetricsMap.get(key);
        if (optimizerAggregatedMetrics == null) {
            return;
        }
        this.updateConcurrencySetting(api.getRuntime().getThreadPool(), optimizerAggregatedMetrics, configUpdated, api.getApi());
        this.updateTimeoutSettings(api.getRuntime().getThreadPool(), optimizerAggregatedMetrics, configUpdated, api);
        this.updateLatencySettings(api, optimizerAggregatedMetrics);
    }

    private void updateConcurrencySetting(ThreadPoolConfig threadPoolConfig, OptimizerAggregatedMetrics optimizerAggregatedMetrics, AtomicBoolean configUpdated, String poolName) {
        if (!this.optimizerConfig.getConcurrencyConfig().isEnabled()) {
            return;
        }
        if (optimizerAggregatedMetrics.getMetricsAggValueMap().get("rollingMaxActiveThreads") == null) {
            return;
        }
        OptimizerConcurrencyConfig concurrencyConfig = this.optimizerConfig.getConcurrencyConfig();
        log.info("Enabled : {}, MaxThreadsMultiplier : {}, MaxThreshold : {}", new Object[]{concurrencyConfig.isEnabled(), concurrencyConfig.getMaxThreadsMultiplier(), concurrencyConfig.getMaxThreshold()});
        int maxRollingActiveThreads = optimizerAggregatedMetrics.getMetricsAggValueMap().get("rollingMaxActiveThreads").intValue();
        int concurrency = threadPoolConfig.getConcurrency();
        if (maxRollingActiveThreads == 0) {
            threadPoolConfig.setConcurrency(3);
            log.info("Setting concurrency for : " + poolName + " from : " + concurrency + " to : " + threadPoolConfig.getConcurrency() + ", maxRollingActiveThreads : " + maxRollingActiveThreads);
            return;
        }
        if (((double)maxRollingActiveThreads > (double)concurrency * concurrencyConfig.getMaxThreshold() || (double)maxRollingActiveThreads < (double)concurrency * concurrencyConfig.getMinThreshold()) && (double)maxRollingActiveThreads < (double)threadPoolConfig.getInitialConcurrency() * concurrencyConfig.getMaxThreadsMultiplier()) {
            int updatedConcurrency = (int)Math.ceil((double)maxRollingActiveThreads * concurrencyConfig.getBandwidth());
            threadPoolConfig.setConcurrency(updatedConcurrency);
            configUpdated.set(true);
            log.info("Setting concurrency for : " + poolName + " from : " + concurrency + " to : " + updatedConcurrency + ", maxRollingActiveThreads : " + maxRollingActiveThreads);
        }
    }

    private void updateTimeoutSettings(ThreadPoolConfig threadPool, OptimizerAggregatedMetrics optimizerAggregatedMetrics, AtomicBoolean configUpdated, RevolverHttpApiConfig api) {
        int currentTimeout;
        OptimizerTimeConfig timeoutConfig = this.optimizerConfig.getTimeConfig();
        if (timeoutConfig == null || !timeoutConfig.isEnabled() || optimizerAggregatedMetrics.getMetricsAggValueMap().get(timeoutConfig.getTimeoutMetric()) == null) {
            return;
        }
        int meanTimeoutValue = optimizerAggregatedMetrics.getMetricsAggValueMap().get(timeoutConfig.getTimeoutMetric()).intValue();
        if (meanTimeoutValue <= 0) {
            return;
        }
        int newTimeout = currentTimeout = threadPool.getTimeout();
        Set<RevolverHttpApiConfig.RequestMethod> methods = api.getMethods();
        double timeoutBuffer = methods.isEmpty() || !methods.contains((Object)RevolverHttpApiConfig.RequestMethod.GET) ? timeoutConfig.getAllMethodTimeoutBuffer() : timeoutConfig.getGetMethodTimeoutBuffer();
        if (currentTimeout < meanTimeoutValue || (double)currentTimeout > (double)meanTimeoutValue * timeoutBuffer) {
            newTimeout = (int)((double)meanTimeoutValue * timeoutBuffer);
            configUpdated.set(true);
        }
        log.info("Setting timeout for : " + api.getApi() + " from : " + threadPool.getTimeout() + " to : " + newTimeout + ", meanTimeoutValue : " + meanTimeoutValue + ", with timeout buffer : " + timeoutBuffer);
    }

    private void updateLatencySettings(RevolverHttpApiConfig api, OptimizerAggregatedMetrics optimizerAggregatedMetrics) {
        int apiLatency;
        OptimizerTimeConfig optimizerTimeConfig = this.optimizerConfig.getTimeConfig();
        if (!optimizerTimeConfig.isEnabled()) {
            return;
        }
        String latencyMetric = optimizerTimeConfig.getApiLatencyMetric();
        int n = apiLatency = optimizerAggregatedMetrics.getMetricsAggValueMap().get(latencyMetric) == null ? 0 : optimizerAggregatedMetrics.getMetricsAggValueMap().get(latencyMetric).intValue();
        if (apiLatency <= 0) {
            return;
        }
        if (api.getApiLatencyConfig() == null) {
            api.setApiLatencyConfig(ApiLatencyConfig.builder().build());
        }
        api.getApiLatencyConfig().setLatency(apiLatency);
    }

    public static RevolverConfigUpdaterBuilder builder() {
        return new RevolverConfigUpdaterBuilder();
    }

    public RevolverConfig getRevolverConfig() {
        return this.revolverConfig;
    }

    public OptimizerConfig getOptimizerConfig() {
        return this.optimizerConfig;
    }

    public OptimizerMetricsCache getOptimizerMetricsCache() {
        return this.optimizerMetricsCache;
    }

    public void setRevolverConfig(RevolverConfig revolverConfig) {
        this.revolverConfig = revolverConfig;
    }

    public void setOptimizerConfig(OptimizerConfig optimizerConfig) {
        this.optimizerConfig = optimizerConfig;
    }

    public void setOptimizerMetricsCache(OptimizerMetricsCache optimizerMetricsCache) {
        this.optimizerMetricsCache = optimizerMetricsCache;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolverConfigUpdater)) {
            return false;
        }
        RevolverConfigUpdater other = (RevolverConfigUpdater)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RevolverConfig this$revolverConfig = this.getRevolverConfig();
        RevolverConfig other$revolverConfig = other.getRevolverConfig();
        if (this$revolverConfig == null ? other$revolverConfig != null : !((Object)((Object)this$revolverConfig)).equals((Object)other$revolverConfig)) {
            return false;
        }
        OptimizerConfig this$optimizerConfig = this.getOptimizerConfig();
        OptimizerConfig other$optimizerConfig = other.getOptimizerConfig();
        if (this$optimizerConfig == null ? other$optimizerConfig != null : !((Object)this$optimizerConfig).equals(other$optimizerConfig)) {
            return false;
        }
        OptimizerMetricsCache this$optimizerMetricsCache = this.getOptimizerMetricsCache();
        OptimizerMetricsCache other$optimizerMetricsCache = other.getOptimizerMetricsCache();
        return !(this$optimizerMetricsCache == null ? other$optimizerMetricsCache != null : !((Object)this$optimizerMetricsCache).equals(other$optimizerMetricsCache));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RevolverConfigUpdater;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RevolverConfig $revolverConfig = this.getRevolverConfig();
        result = result * 59 + ($revolverConfig == null ? 43 : ((Object)((Object)$revolverConfig)).hashCode());
        OptimizerConfig $optimizerConfig = this.getOptimizerConfig();
        result = result * 59 + ($optimizerConfig == null ? 43 : ((Object)$optimizerConfig).hashCode());
        OptimizerMetricsCache $optimizerMetricsCache = this.getOptimizerMetricsCache();
        result = result * 59 + ($optimizerMetricsCache == null ? 43 : ((Object)$optimizerMetricsCache).hashCode());
        return result;
    }

    public String toString() {
        return "RevolverConfigUpdater(revolverConfig=" + (Object)((Object)this.getRevolverConfig()) + ", optimizerConfig=" + this.getOptimizerConfig() + ", optimizerMetricsCache=" + this.getOptimizerMetricsCache() + ")";
    }

    public RevolverConfigUpdater() {
    }

    public RevolverConfigUpdater(RevolverConfig revolverConfig, OptimizerConfig optimizerConfig, OptimizerMetricsCache optimizerMetricsCache) {
        this.revolverConfig = revolverConfig;
        this.optimizerConfig = optimizerConfig;
        this.optimizerMetricsCache = optimizerMetricsCache;
    }

    public static class RevolverConfigUpdaterBuilder {
        private RevolverConfig revolverConfig;
        private OptimizerConfig optimizerConfig;
        private OptimizerMetricsCache optimizerMetricsCache;

        RevolverConfigUpdaterBuilder() {
        }

        public RevolverConfigUpdaterBuilder revolverConfig(RevolverConfig revolverConfig) {
            this.revolverConfig = revolverConfig;
            return this;
        }

        public RevolverConfigUpdaterBuilder optimizerConfig(OptimizerConfig optimizerConfig) {
            this.optimizerConfig = optimizerConfig;
            return this;
        }

        public RevolverConfigUpdaterBuilder optimizerMetricsCache(OptimizerMetricsCache optimizerMetricsCache) {
            this.optimizerMetricsCache = optimizerMetricsCache;
            return this;
        }

        public RevolverConfigUpdater build() {
            return new RevolverConfigUpdater(this.revolverConfig, this.optimizerConfig, this.optimizerMetricsCache);
        }

        public String toString() {
            return "RevolverConfigUpdater.RevolverConfigUpdaterBuilder(revolverConfig=" + (Object)((Object)this.revolverConfig) + ", optimizerConfig=" + this.optimizerConfig + ", optimizerMetricsCache=" + this.optimizerMetricsCache + ")";
        }
    }
}

