/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.config;

public class ServiceDiscoveryConfig {
    private boolean watcherDisabled = false;
    private int refreshTimeInMs = 1000;

    public static ServiceDiscoveryConfigBuilder builder() {
        return new ServiceDiscoveryConfigBuilder();
    }

    public boolean isWatcherDisabled() {
        return this.watcherDisabled;
    }

    public int getRefreshTimeInMs() {
        return this.refreshTimeInMs;
    }

    public void setWatcherDisabled(boolean watcherDisabled) {
        this.watcherDisabled = watcherDisabled;
    }

    public void setRefreshTimeInMs(int refreshTimeInMs) {
        this.refreshTimeInMs = refreshTimeInMs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceDiscoveryConfig)) {
            return false;
        }
        ServiceDiscoveryConfig other = (ServiceDiscoveryConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isWatcherDisabled() != other.isWatcherDisabled()) {
            return false;
        }
        return this.getRefreshTimeInMs() == other.getRefreshTimeInMs();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceDiscoveryConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isWatcherDisabled() ? 79 : 97);
        result = result * 59 + this.getRefreshTimeInMs();
        return result;
    }

    public String toString() {
        return "ServiceDiscoveryConfig(watcherDisabled=" + this.isWatcherDisabled() + ", refreshTimeInMs=" + this.getRefreshTimeInMs() + ")";
    }

    public ServiceDiscoveryConfig() {
    }

    public ServiceDiscoveryConfig(boolean watcherDisabled, int refreshTimeInMs) {
        this.watcherDisabled = watcherDisabled;
        this.refreshTimeInMs = refreshTimeInMs;
    }

    public static class ServiceDiscoveryConfigBuilder {
        private boolean watcherDisabled;
        private int refreshTimeInMs;

        ServiceDiscoveryConfigBuilder() {
        }

        public ServiceDiscoveryConfigBuilder watcherDisabled(boolean watcherDisabled) {
            this.watcherDisabled = watcherDisabled;
            return this;
        }

        public ServiceDiscoveryConfigBuilder refreshTimeInMs(int refreshTimeInMs) {
            this.refreshTimeInMs = refreshTimeInMs;
            return this;
        }

        public ServiceDiscoveryConfig build() {
            return new ServiceDiscoveryConfig(this.watcherDisabled, this.refreshTimeInMs);
        }

        public String toString() {
            return "ServiceDiscoveryConfig.ServiceDiscoveryConfigBuilder(watcherDisabled=" + this.watcherDisabled + ", refreshTimeInMs=" + this.refreshTimeInMs + ")";
        }
    }
}

