/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.json.MetricsModule;
import com.collections.CollectionUtils;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.netflix.hystrix.contrib.codahalemetricspublisher.HystrixCodaHaleMetricsPublisher;
import com.netflix.hystrix.strategy.HystrixPlugins;
import io.dropwizard.Bundle;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.assets.AssetsBundle;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.msgpack.MsgPackBundle;
import io.dropwizard.revolver.aeroapike.AerospikeConnectionManager;
import io.dropwizard.revolver.callback.InlineCallbackHandler;
import io.dropwizard.revolver.core.RevolverExecutionException;
import io.dropwizard.revolver.core.config.AerospikeMailBoxConfig;
import io.dropwizard.revolver.core.config.InMemoryMailBoxConfig;
import io.dropwizard.revolver.core.config.RevolverConfig;
import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.config.hystrix.HystrixUtil;
import io.dropwizard.revolver.core.config.hystrix.ThreadPoolConfig;
import io.dropwizard.revolver.core.model.RevolverExecutorType;
import io.dropwizard.revolver.core.resilience.ResilienceHttpContext;
import io.dropwizard.revolver.core.resilience.ResilienceUtil;
import io.dropwizard.revolver.core.sentinel.SentinelUtil;
import io.dropwizard.revolver.discovery.RevolverServiceResolver;
import io.dropwizard.revolver.discovery.model.RangerEndpointSpec;
import io.dropwizard.revolver.discovery.model.SimpleEndpointSpec;
import io.dropwizard.revolver.exception.RevolverExceptionMapper;
import io.dropwizard.revolver.exception.TimeoutExceptionMapper;
import io.dropwizard.revolver.filters.RevolverRequestFilter;
import io.dropwizard.revolver.handler.ConfigSource;
import io.dropwizard.revolver.handler.DynamicConfigHandler;
import io.dropwizard.revolver.http.RevolverHttpClientFactory;
import io.dropwizard.revolver.http.RevolverHttpCommand;
import io.dropwizard.revolver.http.RevolverHttpContext;
import io.dropwizard.revolver.http.auth.BasicAuthConfig;
import io.dropwizard.revolver.http.auth.TokenAuthConfig;
import io.dropwizard.revolver.http.config.RevolverHttpApiConfig;
import io.dropwizard.revolver.http.config.RevolverHttpServiceConfig;
import io.dropwizard.revolver.http.config.RevolverHttpsServiceConfig;
import io.dropwizard.revolver.http.model.ApiPathMap;
import io.dropwizard.revolver.optimizer.OptimizerMetricsCache;
import io.dropwizard.revolver.optimizer.OptimizerMetricsCollector;
import io.dropwizard.revolver.optimizer.RevolverConfigUpdater;
import io.dropwizard.revolver.optimizer.config.OptimizerConfig;
import io.dropwizard.revolver.persistence.AeroSpikePersistenceProvider;
import io.dropwizard.revolver.persistence.InMemoryPersistenceProvider;
import io.dropwizard.revolver.persistence.PersistenceProvider;
import io.dropwizard.revolver.resource.RevolverApiManageResource;
import io.dropwizard.revolver.resource.RevolverCallbackResource;
import io.dropwizard.revolver.resource.RevolverConfigResource;
import io.dropwizard.revolver.resource.RevolverMailboxResource;
import io.dropwizard.revolver.resource.RevolverMetadataResource;
import io.dropwizard.revolver.resource.RevolverRequestResource;
import io.dropwizard.revolver.splitting.PathExpressionSplitConfig;
import io.dropwizard.revolver.splitting.SplitConfig;
import io.dropwizard.riemann.RiemannBundle;
import io.dropwizard.riemann.RiemannConfig;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.curator.framework.CuratorFramework;
import org.msgpack.jackson.dataformat.MessagePackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RevolverBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final Logger log = LoggerFactory.getLogger(RevolverBundle.class);
    public static final ObjectMapper MSG_PACK_OBJECT_MAPPER = new ObjectMapper((JsonFactory)new MessagePackFactory());
    public static final Map<String, Boolean> API_STATUS = new ConcurrentHashMap<String, Boolean>();
    public static RevolverServiceResolver serviceNameResolver = null;
    private static Map<String, RevolverHttpServiceConfig> serviceConfig = new ConcurrentHashMap<String, RevolverHttpServiceConfig>();
    private static Map<String, RevolverHttpApiConfig> apiConfig = new ConcurrentHashMap<String, RevolverHttpApiConfig>();
    private static MultivaluedMap<String, ApiPathMap> serviceToPathMap = new MultivaluedHashMap();
    private static Map<String, Integer> serviceConnectionPoolMap = new ConcurrentHashMap<String, Integer>();
    private static RevolverConfig revolverConfig;
    private static ResilienceHttpContext resilienceHttpContext;

    public void initialize(Bootstrap<?> bootstrap) {
        HystrixPlugins.reset();
        this.registerTypes(bootstrap);
        bootstrap.addBundle((Bundle)new MsgPackBundle());
        bootstrap.addBundle((Bundle)new AssetsBundle("/revolver/dashboard/", "/revolver/dashboard/", "index.html"));
        bootstrap.addBundle((ConfiguredBundle)new RiemannBundle<Configuration>(){

            public RiemannConfig getRiemannConfiguration(Configuration configuration) {
                if (configuration instanceof RevolverConfig) {
                    return ((RevolverConfig)configuration).getRiemann();
                }
                return null;
            }
        });
    }

    public void run(T configuration, Environment environment) {
        HystrixCodaHaleMetricsPublisher metricsPublisher = new HystrixCodaHaleMetricsPublisher(environment.metrics());
        MetricRegistry metrics = environment.metrics();
        ScheduledExecutorService scheduledExecutorService = environment.lifecycle().scheduledExecutorService("metrics-builder").build();
        this.initializeRevolver(configuration, environment);
        HystrixUtil.initializeHystrix(environment, metricsPublisher, revolverConfig);
        SentinelUtil.initializeSentinel(revolverConfig);
        ResilienceUtil.initializeResilience(revolverConfig, resilienceHttpContext, environment.metrics());
        this.initializeOptimizer(metrics, scheduledExecutorService);
        PersistenceProvider persistenceProvider = this.getPersistenceProvider(configuration, environment);
        InlineCallbackHandler callbackHandler = InlineCallbackHandler.builder().persistenceProvider(persistenceProvider).revolverConfig(revolverConfig).build();
        this.registerResources(environment, metrics, persistenceProvider, callbackHandler);
        this.registerMappers(environment);
        this.registerFilters(environment);
    }

    public abstract RevolverConfig getRevolverConfig(T var1);

    public abstract String getRevolverConfigAttribute();

    public abstract ConfigSource getConfigSource();

    public void onConfigChange(String configData) {
        log.info("Config changed! Override to propagate config changes to other bundles");
    }

    PersistenceProvider getPersistenceProvider(T configuration, Environment environment) {
        RevolverConfig revolverConfig = this.getRevolverConfig(configuration);
        if (revolverConfig.getMailBox() == null) {
            return new InMemoryPersistenceProvider();
        }
        switch (revolverConfig.getMailBox().getType()) {
            case "in_memory": {
                return new InMemoryPersistenceProvider();
            }
            case "aerospike": {
                AerospikeConnectionManager.init((AerospikeMailBoxConfig)revolverConfig.getMailBox());
                return new AeroSpikePersistenceProvider((AerospikeMailBoxConfig)revolverConfig.getMailBox(), environment.getObjectMapper());
            }
        }
        throw new IllegalArgumentException("Invalid mailbox configuration");
    }

    public abstract CuratorFramework getCurator();

    public static ApiPathMap matchPath(String service, String path) {
        if (serviceToPathMap.containsKey((Object)service)) {
            Optional<ApiPathMap> apiMap = ((List)serviceToPathMap.get((Object)service)).stream().filter(api -> path.matches(api.getPath())).findFirst();
            return apiMap.orElse(null);
        }
        return null;
    }

    public static RevolverHttpCommand getHttpCommand(String service, String api) {
        if (!serviceConfig.containsKey(service)) {
            throw new RevolverExecutionException(RevolverExecutionException.Type.BAD_REQUEST, "No service spec defined for service: " + service);
        }
        String serviceKey = service + "." + api;
        if (!apiConfig.containsKey(serviceKey)) {
            throw new RevolverExecutionException(RevolverExecutionException.Type.BAD_REQUEST, "No api spec defined for service: " + service);
        }
        RevolverHttpContext revolverContext = RevolverBundle.getRevolverContext(serviceKey);
        return RevolverHttpCommand.builder().apiConfiguration(apiConfig.get(serviceKey)).clientConfiguration(revolverConfig.getClientConfig()).runtimeConfig(revolverConfig.getGlobal()).revolverContext(revolverContext).serviceConfiguration(serviceConfig.get(service)).build();
    }

    private static RevolverHttpContext getRevolverContext(String serviceKey) {
        RevolverHttpApiConfig revolverHttpApiConfig = apiConfig.get(serviceKey);
        RevolverExecutorType revolverExecutorType = revolverHttpApiConfig.getRevolverExecutorType();
        if (revolverExecutorType == null) {
            return new ResilienceHttpContext();
        }
        switch (revolverExecutorType) {
            case RESILIENCE: {
                return resilienceHttpContext;
            }
        }
        return new RevolverHttpContext();
    }

    public static RevolverServiceResolver getServiceNameResolver() {
        return serviceNameResolver;
    }

    public static void loadServiceConfiguration(RevolverConfig revolverConfig) {
        block8: for (RevolverServiceConfig config : revolverConfig.getServices()) {
            String type;
            switch (type = config.getType()) {
                case "http": {
                    RevolverBundle.registerHttpCommand(config);
                    continue block8;
                }
                case "https": {
                    RevolverBundle.registerHttpsCommand(config);
                    continue block8;
                }
            }
            log.warn("Unsupported Service type: " + type);
        }
    }

    public static Map<String, RevolverHttpServiceConfig> getServiceConfig() {
        return serviceConfig;
    }

    public static void addHttpCommand(RevolverHttpServiceConfig config) {
        if (!serviceConfig.containsKey(config.getService())) {
            serviceConfig.put(config.getService(), config);
            RevolverBundle.registerCommand(config, config);
        }
    }

    private static void registerHttpsCommand(RevolverServiceConfig config) {
        RevolverHttpsServiceConfig httpsConfig = (RevolverHttpsServiceConfig)config;
        RevolverHttpServiceConfig revolverHttpServiceConfig = RevolverHttpServiceConfig.builder().apis(httpsConfig.getApis()).auth(httpsConfig.getAuth()).authEnabled(httpsConfig.isAuthEnabled()).compression(httpsConfig.isCompression()).connectionKeepAliveInMillis(httpsConfig.getConnectionKeepAliveInMillis()).connectionPoolSize(httpsConfig.getConnectionPoolSize()).enpoint(httpsConfig.getEndpoint()).keystorePassword(httpsConfig.getKeystorePassword()).keyStorePath(httpsConfig.getKeyStorePath()).secured(true).service(httpsConfig.getService()).trackingHeaders(httpsConfig.isTrackingHeaders()).type(httpsConfig.getType()).build();
        RevolverBundle.registerCommand(config, revolverHttpServiceConfig);
    }

    private static void registerCommand(RevolverServiceConfig config, RevolverHttpServiceConfig revolverHttpServiceConfig) {
        if (config instanceof RevolverHttpServiceConfig) {
            int totalConcurrency = 0;
            if (config.getThreadPoolGroupConfig() != null) {
                totalConcurrency = config.getThreadPoolGroupConfig().getThreadPools().stream().mapToInt(ThreadPoolConfig::getConcurrency).sum();
                config.getThreadPoolGroupConfig().getThreadPools().forEach(a -> a.setInitialConcurrency(a.getConcurrency()));
            }
            ((RevolverHttpServiceConfig)config).setConnectionPoolSize(totalConcurrency += ((RevolverHttpServiceConfig)config).getApis().stream().filter(a -> Strings.isNullOrEmpty((String)a.getRuntime().getThreadPool().getThreadPoolName())).mapToInt(a -> a.getRuntime().getThreadPool().getConcurrency()).sum());
            ((RevolverHttpServiceConfig)config).getApis().forEach(a -> {
                String key = config.getService() + "." + a.getApi();
                API_STATUS.put(key, true);
                apiConfig.put(key, (RevolverHttpApiConfig)a);
                if (a.getRuntime() != null && a.getRuntime().getThreadPool() != null) {
                    a.getRuntime().getThreadPool().setInitialConcurrency(a.getRuntime().getThreadPool().getConcurrency());
                }
                if (null != a.getSplitConfig() && a.getSplitConfig().isEnabled()) {
                    RevolverBundle.updateSplitConfig(a);
                    if (CollectionUtils.isNotEmpty(a.getSplitConfig().getPathExpressionSplitConfigs())) {
                        List<PathExpressionSplitConfig> sortedOnOrder = a.getSplitConfig().getPathExpressionSplitConfigs().stream().sorted(Comparator.comparing(PathExpressionSplitConfig::getOrder)).collect(Collectors.toList());
                        a.getSplitConfig().setPathExpressionSplitConfigs(sortedOnOrder);
                    }
                }
            });
            RevolverBundle.generateApiConfigMap((RevolverHttpServiceConfig)config);
            serviceNameResolver.register(revolverHttpServiceConfig.getEndpoint());
        }
    }

    private static void updateSplitConfig(RevolverHttpApiConfig apiConfig) {
        double from = 0.0;
        for (SplitConfig splitConfig : CollectionUtils.nullSafeList(apiConfig.getSplitConfig().getSplits())) {
            double wrr = splitConfig.getWrr();
            splitConfig.setFrom(from);
            splitConfig.setTo(from += wrr);
        }
        if (from > 1.0) {
            throw new RuntimeException("wrr of split api is exceeding weight of 1");
        }
    }

    private void initializeOptimizer(MetricRegistry metrics, ScheduledExecutorService scheduledExecutorService) {
        OptimizerConfig optimizerConfig = revolverConfig.getOptimizerConfig();
        if (optimizerConfig != null && optimizerConfig.isEnabled()) {
            OptimizerMetricsCache optimizerMetricsCache = OptimizerMetricsCache.builder().optimizerMetricsCollectorConfig(optimizerConfig.getMetricsCollectorConfig()).build();
            if (optimizerConfig.getConcurrencyConfig() != null && optimizerConfig.getConcurrencyConfig().isEnabled()) {
                OptimizerMetricsCollector optimizerMetricsCollector = OptimizerMetricsCollector.builder().metrics(metrics).optimizerMetricsCache(optimizerMetricsCache).optimizerConfig(optimizerConfig).build();
                scheduledExecutorService.scheduleAtFixedRate(optimizerMetricsCollector, optimizerConfig.getInitialDelay(), optimizerConfig.getMetricsCollectorConfig().getRepeatAfter(), optimizerConfig.getMetricsCollectorConfig().getTimeUnit());
            }
            if (optimizerConfig.getTimeConfig() != null && optimizerConfig.getTimeConfig().isEnabled()) {
                RevolverConfigUpdater revolverConfigUpdater = RevolverConfigUpdater.builder().optimizerConfig(optimizerConfig).optimizerMetricsCache(optimizerMetricsCache).revolverConfig(revolverConfig).build();
                scheduledExecutorService.scheduleAtFixedRate(revolverConfigUpdater, optimizerConfig.getInitialDelay(), optimizerConfig.getConfigUpdaterConfig().getRepeatAfter(), optimizerConfig.getConfigUpdaterConfig().getTimeUnit());
            }
        }
    }

    private void initializeRevolver(T configuration, Environment environment) {
        revolverConfig = this.getRevolverConfig(configuration);
        serviceNameResolver = revolverConfig.getServiceResolverConfig() != null ? (revolverConfig.getServiceResolverConfig().isUseCurator() ? RevolverServiceResolver.usingCurator().curatorFramework(this.getCurator()).objectMapper(environment.getObjectMapper()).resolverConfig(revolverConfig.getServiceResolverConfig()).build() : RevolverServiceResolver.builder().resolverConfig(revolverConfig.getServiceResolverConfig()).objectMapper(environment.getObjectMapper()).build()) : RevolverServiceResolver.builder().objectMapper(environment.getObjectMapper()).build();
        RevolverBundle.loadServiceConfiguration(revolverConfig);
    }

    private static void registerHttpCommand(RevolverServiceConfig config) {
        RevolverHttpServiceConfig httpConfig = (RevolverHttpServiceConfig)config;
        httpConfig.setSecured(false);
        RevolverBundle.registerCommand(config, httpConfig);
        if (serviceConfig.containsKey(httpConfig.getService())) {
            serviceConfig.put(config.getService(), httpConfig);
            if (serviceConnectionPoolMap.get(httpConfig.getService()) != null && !serviceConnectionPoolMap.get(httpConfig.getService()).equals(((RevolverHttpServiceConfig)config).getConnectionPoolSize())) {
                RevolverHttpClientFactory.refreshClient(httpConfig);
            }
        } else {
            serviceConfig.put(config.getService(), httpConfig);
        }
        serviceConnectionPoolMap.put(httpConfig.getService(), httpConfig.getConnectionPoolSize());
    }

    private static Map<String, RevolverHttpApiConfig> generateApiConfigMap(RevolverHttpServiceConfig serviceConfiguration) {
        Pattern tokenMatch = Pattern.compile("\\{(([^/])+\\})");
        ArrayList<RevolverHttpApiConfig> apis = new ArrayList<RevolverHttpApiConfig>(serviceConfiguration.getApis());
        apis.sort((o1, o2) -> {
            String o1Expr = RevolverBundle.generatePathExpression(o1.getPath());
            String o2Expr = RevolverBundle.generatePathExpression(o2.getPath());
            return tokenMatch.matcher(o2Expr).groupCount() - tokenMatch.matcher(o1Expr).groupCount();
        });
        apis.sort(Comparator.comparing(RevolverHttpApiConfig::getPath));
        apis.forEach(apiConfig -> {
            ApiPathMap apiPathMap = ApiPathMap.builder().api((RevolverHttpApiConfig)apiConfig).path(RevolverBundle.generatePathExpression(apiConfig.getPath())).build();
            int elementIndex = ((List)serviceToPathMap.getOrDefault((Object)serviceConfiguration.getService(), Collections.emptyList())).indexOf(apiPathMap);
            if (elementIndex == -1) {
                serviceToPathMap.add((Object)serviceConfiguration.getService(), (Object)apiPathMap);
            } else {
                ((List)serviceToPathMap.get((Object)serviceConfiguration.getService())).set(elementIndex, apiPathMap);
            }
        });
        ImmutableMap.Builder configMapBuilder = ImmutableMap.builder();
        apis.forEach(apiConfig -> configMapBuilder.put((Object)apiConfig.getApi(), apiConfig));
        return configMapBuilder.build();
    }

    private static String generatePathExpression(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            return "";
        }
        return path.replaceAll("\\{(([^/])+\\})", "(([^/])+)");
    }

    private void registerTypes(Bootstrap<?> bootstrap) {
        bootstrap.getObjectMapper().registerModule((Module)new MetricsModule(TimeUnit.MINUTES, TimeUnit.MILLISECONDS, false));
        bootstrap.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(RevolverHttpServiceConfig.class, "http")});
        bootstrap.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(RevolverHttpsServiceConfig.class, "https")});
        bootstrap.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(BasicAuthConfig.class, "basic")});
        bootstrap.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(TokenAuthConfig.class, "token")});
        bootstrap.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(SimpleEndpointSpec.class, "simple")});
        bootstrap.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(RangerEndpointSpec.class, "ranger_sharded")});
        bootstrap.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(InMemoryMailBoxConfig.class, "in_memory")});
        bootstrap.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(AerospikeMailBoxConfig.class, "aerospike")});
    }

    private void registerResources(Environment environment, MetricRegistry metrics, PersistenceProvider persistenceProvider, InlineCallbackHandler callbackHandler) {
        environment.jersey().register((Object)new RevolverRequestResource(environment.getObjectMapper(), MSG_PACK_OBJECT_MAPPER, persistenceProvider, callbackHandler, metrics, revolverConfig));
        environment.jersey().register((Object)new RevolverCallbackResource(persistenceProvider, callbackHandler));
        environment.jersey().register((Object)new RevolverMetadataResource(revolverConfig));
        environment.jersey().register((Object)new RevolverMailboxResource(persistenceProvider, environment.getObjectMapper(), MSG_PACK_OBJECT_MAPPER, Collections.unmodifiableMap(apiConfig)));
        DynamicConfigHandler dynamicConfigHandler = new DynamicConfigHandler(this.getRevolverConfigAttribute(), revolverConfig, environment.getObjectMapper(), this.getConfigSource(), this);
        if (revolverConfig.isDynamicConfig()) {
            environment.lifecycle().manage((Managed)dynamicConfigHandler);
        }
        environment.jersey().register((Object)new RevolverConfigResource(dynamicConfigHandler));
        environment.jersey().register((Object)new RevolverApiManageResource());
    }

    private void registerFilters(Environment environment) {
        environment.jersey().register((Object)new RevolverRequestFilter(revolverConfig));
    }

    private void registerMappers(Environment environment) {
        environment.jersey().register((Object)new RevolverExceptionMapper(environment.getObjectMapper(), MSG_PACK_OBJECT_MAPPER));
        environment.jersey().register((Object)new TimeoutExceptionMapper(environment.getObjectMapper()));
    }

    static {
        resilienceHttpContext = new ResilienceHttpContext();
    }
}

