/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.resilience;

import io.dropwizard.revolver.core.RevolverCommand;
import io.dropwizard.revolver.core.RevolverContext;
import io.dropwizard.revolver.core.RevolverExecutionException;
import io.dropwizard.revolver.core.config.CommandHandlerConfig;
import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.config.hystrix.ThreadPoolConfig;
import io.dropwizard.revolver.core.model.RevolverRequest;
import io.dropwizard.revolver.core.model.RevolverResponse;
import io.dropwizard.revolver.core.resilience.ResilienceHttpContext;
import io.dropwizard.revolver.core.util.RevolverCommandHelper;
import io.dropwizard.revolver.core.util.RevolverExceptionHelper;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResilienceCommandHelper<RequestType extends RevolverRequest, ResponseType extends RevolverResponse, ContextType extends RevolverContext, ServiceConfigurationType extends RevolverServiceConfig, CommandHandlerConfigurationType extends CommandHandlerConfig> {
    private static final Logger log = LoggerFactory.getLogger(ResilienceCommandHelper.class);
    private final RevolverCommand<RequestType, ResponseType, ContextType, ServiceConfigurationType, CommandHandlerConfigurationType> handler;
    private final RequestType request;
    private final ContextType context;

    public ResilienceCommandHelper(ContextType context, RevolverCommand<RequestType, ResponseType, ContextType, ServiceConfigurationType, CommandHandlerConfigurationType> handler, RequestType request) {
        this.context = context;
        this.handler = handler;
        this.request = request;
    }

    public ResponseType executeSync() throws Exception {
        return this.execute();
    }

    public CompletableFuture<ResponseType> executeASync() {
        try {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    return this.execute();
                }
                catch (Exception e) {
                    throw this.getException(e);
                }
            });
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    private ResilienceHttpContext getResilienceExtent() {
        ResilienceHttpContext resilienceHttpContext = this.context instanceof ResilienceHttpContext ? (ResilienceHttpContext)this.context : new ResilienceHttpContext();
        return resilienceHttpContext;
    }

    private Bulkhead getBulkHead(ResilienceHttpContext resilienceHttpContext, RequestType request, ServiceConfigurationType serviceConfiguration, CommandHandlerConfigurationType apiConfiguration) {
        Bulkhead bulkhead;
        ThreadPoolConfig threadPoolConfig = ((CommandHandlerConfig)apiConfiguration).getRuntime().getThreadPool();
        String threadPoolName = threadPoolConfig.getThreadPoolName();
        if (StringUtils.isEmpty((CharSequence)threadPoolName)) {
            threadPoolName = ((RevolverRequest)request).getService() + "." + ((RevolverRequest)request).getApi();
        }
        if ((bulkhead = resilienceHttpContext.getPoolVsBulkHeadMap().get(threadPoolName)) != null) {
            return bulkhead;
        }
        threadPoolName = ((RevolverServiceConfig)serviceConfiguration).getRuntime().getThreadPool().getThreadPoolName();
        bulkhead = resilienceHttpContext.getPoolVsBulkHeadMap().get(threadPoolName);
        if (bulkhead == null) {
            log.error("No bulk head defined for service {}, api {}", (Object)((RevolverRequest)request).getService(), (Object)((RevolverRequest)request).getApi());
            bulkhead = Bulkhead.ofDefaults((String)"revolver");
        }
        return bulkhead;
    }

    private TimeLimiter getTimeoutConfig(ResilienceHttpContext resilienceHttpContext, ServiceConfigurationType serviceConfiguration, CommandHandlerConfigurationType apiConfiguration) {
        ThreadPoolConfig threadPoolConfig = ((CommandHandlerConfig)apiConfiguration).getRuntime().getThreadPool();
        long ttl = threadPoolConfig != null && threadPoolConfig.getTimeout() != 0 ? (long)threadPoolConfig.getTimeout() : (threadPoolConfig != null ? (long)resilienceHttpContext.getPoolVsTimeout().get(threadPoolConfig.getThreadPoolName()).intValue() : (StringUtils.isNotEmpty((CharSequence)((RevolverServiceConfig)serviceConfiguration).getRuntime().getThreadPool().getThreadPoolName()) ? (long)resilienceHttpContext.getPoolVsTimeout().get(((RevolverServiceConfig)serviceConfiguration).getRuntime().getThreadPool().getThreadPoolName()).intValue() : (long)((RevolverServiceConfig)serviceConfiguration).getRuntime().getThreadPool().getTimeout()));
        TimeLimiterConfig config = TimeLimiterConfig.custom().timeoutDuration(Duration.ofMillis(ttl)).build();
        return TimeLimiter.of((TimeLimiterConfig)config);
    }

    private RevolverExecutionException getException(Throwable throwable) {
        return new RevolverExecutionException(RevolverExecutionException.Type.SERVICE_ERROR, String.format("Error executing command %s", RevolverCommandHelper.getName(this.request)), RevolverExceptionHelper.getLeafThrowable(throwable));
    }

    private ResponseType execute() throws Exception {
        ResilienceHttpContext resilienceHttpContext = this.getResilienceExtent();
        CircuitBreaker circuitBreaker = resilienceHttpContext.getCircuitBreaker();
        Bulkhead bulkhead = this.getBulkHead(resilienceHttpContext, this.request, this.handler.getServiceConfiguration(), this.handler.getApiConfiguration());
        TimeLimiter timeLimiter = this.getTimeoutConfig(resilienceHttpContext, this.handler.getServiceConfiguration(), this.handler.getApiConfiguration());
        Supplier<Future> supplier = () -> {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            return executor.submit(() -> this.handler.execute(this.context, this.request));
        };
        Callable timeCallable = TimeLimiter.decorateFutureSupplier((TimeLimiter)timeLimiter, supplier);
        Callable circuitCallable = CircuitBreaker.decorateCallable((CircuitBreaker)circuitBreaker, (Callable)timeCallable);
        Callable bulkHeadCallable = Bulkhead.decorateCallable((Bulkhead)bulkhead, (Callable)circuitCallable);
        return (ResponseType)((RevolverResponse)bulkHeadCallable.call());
    }
}

