/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.resilience;

import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Maps;
import io.dropwizard.revolver.core.config.HystrixCommandConfig;
import io.dropwizard.revolver.core.config.RevolverConfig;
import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.config.ThreadPoolGroupConfig;
import io.dropwizard.revolver.core.model.RevolverExecutorType;
import io.dropwizard.revolver.core.resilience.ResilienceHttpContext;
import io.dropwizard.revolver.http.config.RevolverHttpServiceConfig;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.micrometer.tagged.TaggedBulkheadMetrics;
import io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetrics;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.dropwizard.DropwizardConfig;
import io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResilienceUtil {
    private static final Logger log = LoggerFactory.getLogger(ResilienceUtil.class);
    private static final Map<String, String> DEFAULT_KEY_VALUE_MAP = Maps.newHashMap();
    private static final String METRIC_PREFIX = "resilience";
    private static final String DEFAULT_CIRCUIT_BREAKER = "revolver";
    private static BulkheadRegistry bulkheadRegistry;
    private static CircuitBreakerRegistry circuitBreakerRegistry;

    private ResilienceUtil() {
    }

    public static void initializeResilience(RevolverConfig revolverConfig, ResilienceHttpContext resilienceHttpContext, MetricRegistry metrics) {
        log.info("Initializing resilience util");
        DropwizardMeterRegistry metricRegistry = new DropwizardMeterRegistry(new DropwizardConfig(){

            public String prefix() {
                return ResilienceUtil.METRIC_PREFIX;
            }

            public String get(String s) {
                return (String)DEFAULT_KEY_VALUE_MAP.get(s);
            }
        }, metrics, HierarchicalNameMapper.DEFAULT, Clock.SYSTEM){

            protected Double nullGaugeValue() {
                return null;
            }
        };
        TaggedBulkheadMetrics.ofBulkheadRegistry((BulkheadRegistry)bulkheadRegistry).bindTo((MeterRegistry)metricRegistry);
        TaggedCircuitBreakerMetrics.ofCircuitBreakerRegistry((CircuitBreakerRegistry)circuitBreakerRegistry).bindTo((MeterRegistry)metricRegistry);
        ResilienceUtil.initializeBulkHeads(revolverConfig, resilienceHttpContext);
        ResilienceUtil.initializeCircuitBreakers(revolverConfig, resilienceHttpContext);
        ResilienceUtil.initializeTimeout(revolverConfig, resilienceHttpContext);
    }

    private static void initializeCircuitBreakers(RevolverConfig revolverConfig, ResilienceHttpContext resilienceHttpContext) {
        HashMap poolVsCircuitBreaker = Maps.newHashMap();
        resilienceHttpContext.setDefaultCircuitBreaker(circuitBreakerRegistry.circuitBreaker(DEFAULT_CIRCUIT_BREAKER));
        for (RevolverServiceConfig revolverServiceConfig : revolverConfig.getServices()) {
            ThreadPoolGroupConfig threadPoolGroupConfig = revolverServiceConfig.getThreadPoolGroupConfig();
            if (threadPoolGroupConfig != null) {
                threadPoolGroupConfig.getThreadPools().forEach(threadPoolConfig -> poolVsCircuitBreaker.put(threadPoolConfig.getThreadPoolName(), circuitBreakerRegistry.circuitBreaker(threadPoolConfig.getThreadPoolName())));
            }
            if (!(revolverServiceConfig instanceof RevolverHttpServiceConfig)) continue;
            ((RevolverHttpServiceConfig)revolverServiceConfig).getApis().forEach(revolverHttpApiConfig -> {
                if (revolverHttpApiConfig.getRuntime() != null) {
                    HystrixCommandConfig hystrixCommandConfig = revolverHttpApiConfig.getRuntime();
                    if (hystrixCommandConfig == null || hystrixCommandConfig.getThreadPool() == null) {
                        return;
                    }
                    String threadPoolName = hystrixCommandConfig.getThreadPool().getThreadPoolName();
                    if (StringUtils.isEmpty((CharSequence)threadPoolName)) {
                        threadPoolName = revolverServiceConfig.getService() + "." + revolverHttpApiConfig.getApi();
                    }
                    poolVsCircuitBreaker.putIfAbsent(threadPoolName, circuitBreakerRegistry.circuitBreaker(threadPoolName));
                }
            });
        }
        poolVsCircuitBreaker.forEach((s, circuitBreaker) -> log.info("Resilience circuit breaker : {}, circuit break config : {} ", s, (Object)Float.valueOf(circuitBreaker.getCircuitBreakerConfig().getFailureRateThreshold())));
        resilienceHttpContext.setPoolVsCircuitBreaker(poolVsCircuitBreaker);
    }

    private static void initializeBulkHeads(RevolverConfig revolverConfig, ResilienceHttpContext resilienceHttpContext) {
        log.info("Initializing resilience bulk heads");
        HashMap poolVsBulkHead = Maps.newHashMap();
        for (RevolverServiceConfig revolverServiceConfig : revolverConfig.getServices()) {
            ThreadPoolGroupConfig threadPoolGroupConfig = revolverServiceConfig.getThreadPoolGroupConfig();
            if (threadPoolGroupConfig != null) {
                threadPoolGroupConfig.getThreadPools().forEach(threadPoolConfig -> poolVsBulkHead.put(threadPoolConfig.getThreadPoolName(), bulkheadRegistry.bulkhead(threadPoolConfig.getThreadPoolName(), BulkheadConfig.custom().maxConcurrentCalls(threadPoolConfig.getConcurrency()).build())));
            }
            if (!(revolverServiceConfig instanceof RevolverHttpServiceConfig)) continue;
            ((RevolverHttpServiceConfig)revolverServiceConfig).getApis().forEach(revolverHttpApiConfig -> {
                if (revolverHttpApiConfig.getRuntime() != null) {
                    String threadPoolName;
                    HystrixCommandConfig hystrixCommandConfig = revolverHttpApiConfig.getRuntime();
                    if (hystrixCommandConfig == null || hystrixCommandConfig.getThreadPool() == null) {
                        return;
                    }
                    if (RevolverExecutorType.RESILIENCE == revolverHttpApiConfig.getRevolverExecutorType()) {
                        log.info("API is executing via resilience : {} ", (Object)revolverHttpApiConfig.getApi());
                    }
                    if (StringUtils.isEmpty((CharSequence)(threadPoolName = hystrixCommandConfig.getThreadPool().getThreadPoolName()))) {
                        threadPoolName = revolverServiceConfig.getService() + "." + revolverHttpApiConfig.getApi();
                    }
                    poolVsBulkHead.putIfAbsent(threadPoolName, bulkheadRegistry.bulkhead(threadPoolName, BulkheadConfig.custom().maxConcurrentCalls(hystrixCommandConfig.getThreadPool().getConcurrency()).build()));
                }
            });
        }
        poolVsBulkHead.forEach((s, bulkhead) -> log.info("Resilience bulk head Key : {}, bulk head value : {} ", s, (Object)bulkhead.getBulkheadConfig().getMaxConcurrentCalls()));
        resilienceHttpContext.setPoolVsBulkHeadMap(poolVsBulkHead);
    }

    private static void initializeTimeout(RevolverConfig revolverConfig, ResilienceHttpContext resilienceHttpContext) {
        log.info("Initializing resilience time out");
        HashMap poolVsTimeout = Maps.newHashMap();
        for (RevolverServiceConfig revolverServiceConfig : revolverConfig.getServices()) {
            ThreadPoolGroupConfig threadPoolGroupConfig = revolverServiceConfig.getThreadPoolGroupConfig();
            if (threadPoolGroupConfig != null) {
                threadPoolGroupConfig.getThreadPools().forEach(threadPoolConfig -> poolVsTimeout.put(threadPoolConfig.getThreadPoolName(), threadPoolConfig.getTimeout()));
            }
            if (revolverServiceConfig instanceof RevolverHttpServiceConfig) {
                ((RevolverHttpServiceConfig)revolverServiceConfig).getApis().forEach(revolverHttpApiConfig -> {
                    if (revolverHttpApiConfig.getRuntime() != null) {
                        HystrixCommandConfig hystrixCommandConfig = revolverHttpApiConfig.getRuntime();
                        if (hystrixCommandConfig == null || hystrixCommandConfig.getThreadPool() == null) {
                            return;
                        }
                        String threadPoolName = hystrixCommandConfig.getThreadPool().getThreadPoolName();
                        if (StringUtils.isEmpty((CharSequence)threadPoolName)) {
                            threadPoolName = revolverServiceConfig.getService() + "." + revolverHttpApiConfig.getApi();
                        }
                        poolVsTimeout.putIfAbsent(threadPoolName, hystrixCommandConfig.getThreadPool().getTimeout());
                    }
                });
            }
            poolVsTimeout.forEach((s, timeout) -> log.info("Resilience timeout  Key : {}, timeput value : {} ", s, timeout));
        }
        resilienceHttpContext.setPoolVsTimeout(poolVsTimeout);
    }

    static {
        DEFAULT_KEY_VALUE_MAP.put("resilience.step", "PT1M");
        DEFAULT_KEY_VALUE_MAP.put("resilience.enabled", "true");
        bulkheadRegistry = BulkheadRegistry.ofDefaults();
        circuitBreakerRegistry = CircuitBreakerRegistry.ofDefaults();
    }
}

