/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.sharding.dao;

import com.google.common.base.Preconditions;
import io.dropwizard.hibernate.AbstractDAO;
import io.dropwizard.sharding.sharding.LookupKey;
import io.dropwizard.sharding.sharding.ShardManager;
import io.dropwizard.sharding.utils.ShardCalculator;
import io.dropwizard.sharding.utils.Transactions;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupDao<T> {
    private static final Logger log = LoggerFactory.getLogger(LookupDao.class);
    private List<LookupDaoPriv> daos;
    private final Class<T> entityClass;
    private final ShardManager shardManager;
    private final Field keyField;

    public LookupDao(List<SessionFactory> sessionFactories, Class<T> entityClass, ShardManager shardManager) {
        this.shardManager = shardManager;
        this.daos = sessionFactories.stream().map(x$0 -> new LookupDaoPriv((SessionFactory)x$0)).collect(Collectors.toList());
        this.entityClass = entityClass;
        Field[] fields = FieldUtils.getFieldsWithAnnotation(entityClass, LookupKey.class);
        Preconditions.checkArgument((fields.length != 0 ? 1 : 0) != 0, (Object)"At least one field needs to be sharding key");
        Preconditions.checkArgument((fields.length == 1 ? 1 : 0) != 0, (Object)"Only one field can be sharding key");
        this.keyField = fields[0];
        if (!this.keyField.isAccessible()) {
            try {
                this.keyField.setAccessible(true);
            }
            catch (SecurityException e) {
                log.error("Error making key field accessible please use a public method and mark that as LookupKey", (Throwable)e);
                throw new IllegalArgumentException("Invalid class, DAO cannot be created.", e);
            }
        }
        Preconditions.checkArgument((boolean)ClassUtils.isAssignable(this.keyField.getType(), String.class), (Object)"Key field must be a string");
    }

    public Optional<T> get(String key) throws Exception {
        return Optional.ofNullable(this.get(key, t -> t));
    }

    public <U> U get(String key, Function<T, U> handler) throws Exception {
        int shardId = ShardCalculator.shardId(this.shardManager, key);
        LookupDaoPriv dao = this.daos.get(shardId);
        return Transactions.execute(dao.sessionFactory, true, dao::get, key, handler);
    }

    public boolean exists(String key) throws Exception {
        return this.get(key).isPresent();
    }

    public Optional<T> save(T entity) throws Exception {
        return Optional.ofNullable(this.save(entity, t -> t));
    }

    public <U> U save(T entity, Function<T, U> handler) throws Exception {
        String key = this.keyField.get(entity).toString();
        int shardId = ShardCalculator.shardId(this.shardManager, key);
        log.debug("Saving entity of type {} with key {} to shard {}", new Object[]{this.entityClass.getSimpleName(), key, shardId});
        LookupDaoPriv dao = this.daos.get(shardId);
        return Transactions.execute(dao.sessionFactory, false, dao::save, entity, handler);
    }

    public T update(String id, Function<T, T> updater) {
        int shardId = ShardCalculator.shardId(this.shardManager, id);
        LookupDaoPriv dao = this.daos.get(shardId);
        try {
            return (T)Transactions.execute(dao.sessionFactory, true, dao::get, id, entity -> {
                Object newEntity = updater.apply(entity);
                dao.update(newEntity);
                return newEntity;
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Error updating entity: " + id, e);
        }
    }

    public List<T> scatterGather(DetachedCriteria criteria) {
        return this.daos.stream().map(dao -> {
            try {
                return Transactions.execute(((LookupDaoPriv)dao).sessionFactory, true, dao::select, criteria);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private final class LookupDaoPriv
    extends AbstractDAO<T> {
        private final SessionFactory sessionFactory;

        public LookupDaoPriv(SessionFactory sessionFactory) {
            super(sessionFactory);
            this.sessionFactory = sessionFactory;
        }

        T get(String lookupKey) {
            return this.uniqueResult(this.currentSession().createCriteria(LookupDao.this.entityClass).add((Criterion)Restrictions.eq((String)LookupDao.this.keyField.getName(), (Object)lookupKey)));
        }

        T save(T entity) {
            return this.persist(entity);
        }

        void update(T entity) {
            this.currentSession().evict(entity);
            this.currentSession().update(entity);
        }

        List<T> select(DetachedCriteria criteria) {
            return this.list(criteria.getExecutableCriteria(this.currentSession()));
        }
    }
}

