/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.sharding.dao;

import com.google.common.base.Preconditions;
import io.dropwizard.hibernate.AbstractDAO;
import io.dropwizard.sharding.sharding.ShardManager;
import io.dropwizard.sharding.utils.ShardCalculator;
import io.dropwizard.sharding.utils.Transactions;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.Id;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationalDao<T> {
    private static final Logger log = LoggerFactory.getLogger(RelationalDao.class);
    private List<LookupDaoPriv> daos;
    private final Class<T> entityClass;
    private final ShardManager shardManager;
    private final Field keyField;

    public RelationalDao(List<SessionFactory> sessionFactories, Class<T> entityClass, ShardManager shardManager) {
        this.shardManager = shardManager;
        this.daos = sessionFactories.stream().map(x$0 -> new LookupDaoPriv((SessionFactory)x$0)).collect(Collectors.toList());
        this.entityClass = entityClass;
        Field[] fields = FieldUtils.getFieldsWithAnnotation(entityClass, Id.class);
        Preconditions.checkArgument((fields.length != 0 ? 1 : 0) != 0, (Object)"A field needs to be designated as @Id");
        Preconditions.checkArgument((fields.length == 1 ? 1 : 0) != 0, (Object)"Only one field can be designated as @Id");
        this.keyField = fields[0];
        if (!this.keyField.isAccessible()) {
            try {
                this.keyField.setAccessible(true);
            }
            catch (SecurityException e) {
                log.error("Error making key field accessible please use a public method and mark that as @Id", (Throwable)e);
                throw new IllegalArgumentException("Invalid class, DAO cannot be created.", e);
            }
        }
    }

    public Optional<T> get(String parentKey, Object key) throws Exception {
        return Optional.ofNullable(this.get(parentKey, key, t -> t));
    }

    public <U> U get(String parentKey, Object key, Function<T, U> function) throws Exception {
        int shardId = ShardCalculator.shardId(this.shardManager, parentKey);
        LookupDaoPriv dao = this.daos.get(shardId);
        return Transactions.execute(dao.sessionFactory, true, dao::get, key, function);
    }

    public Optional<T> save(String parentKey, T entity) throws Exception {
        return Optional.ofNullable(this.save(parentKey, entity, t -> t));
    }

    public <U> U save(String parentKey, T entity, Function<T, U> handler) throws Exception {
        int shardId = ShardCalculator.shardId(this.shardManager, parentKey);
        LookupDaoPriv dao = this.daos.get(shardId);
        return Transactions.execute(dao.sessionFactory, false, dao::save, entity, handler);
    }

    public List<T> select(String parentKey, DetachedCriteria criteria) throws Exception {
        return this.select(parentKey, criteria, t -> t);
    }

    public <U> U select(String parentKey, DetachedCriteria criteria, Function<List<T>, U> handler) throws Exception {
        int shardId = ShardCalculator.shardId(this.shardManager, parentKey);
        LookupDaoPriv dao = this.daos.get(shardId);
        return Transactions.execute(dao.sessionFactory, true, dao::select, criteria, handler);
    }

    public long count(String parentKey, DetachedCriteria criteria) throws Exception {
        int shardId = ShardCalculator.shardId(this.shardManager, parentKey);
        LookupDaoPriv dao = this.daos.get(shardId);
        return Transactions.execute(dao.sessionFactory, true, dao::count, criteria);
    }

    public boolean exists(String parentKey, Object key) throws Exception {
        int shardId = ShardCalculator.shardId(this.shardManager, parentKey);
        LookupDaoPriv dao = this.daos.get(shardId);
        Optional<Object> result = Transactions.executeAndResolve(dao.sessionFactory, true, dao::get, key);
        return result.isPresent();
    }

    public List<T> scatterGather(DetachedCriteria criteria) {
        return this.daos.stream().map(dao -> {
            try {
                return Transactions.execute(((LookupDaoPriv)dao).sessionFactory, true, dao::select, criteria);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private final class LookupDaoPriv
    extends AbstractDAO<T> {
        private final SessionFactory sessionFactory;

        public LookupDaoPriv(SessionFactory sessionFactory) {
            super(sessionFactory);
            this.sessionFactory = sessionFactory;
        }

        T get(Object lookupKey) {
            return this.uniqueResult(this.currentSession().createCriteria(RelationalDao.this.entityClass).add((Criterion)Restrictions.eq((String)RelationalDao.this.keyField.getName(), (Object)lookupKey)));
        }

        T save(T entity) {
            return this.persist(entity);
        }

        List<T> select(DetachedCriteria criteria) {
            return this.list(criteria.getExecutableCriteria(this.currentSession()));
        }

        long count(DetachedCriteria criteria) {
            return (Long)criteria.getExecutableCriteria(this.currentSession()).setProjection(Projections.rowCount()).uniqueResult();
        }
    }
}

