/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.sharding;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.hibernate.AbstractDAO;
import io.dropwizard.hibernate.HibernateBundle;
import io.dropwizard.hibernate.SessionFactoryFactory;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.sharding.config.ShardedHibernateFactory;
import io.dropwizard.sharding.dao.LookupDao;
import io.dropwizard.sharding.dao.RelationalDao;
import io.dropwizard.sharding.dao.WrapperDao;
import io.dropwizard.sharding.sharding.ShardManager;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.SessionFactory;

public abstract class DBShardingBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private List<HibernateBundle<T>> shardBundles = Lists.newArrayList();
    private List<SessionFactory> sessionFactories;
    private ShardManager shardManager;

    public DBShardingBundle(Class<?> entity, Class<?> ... entities) {
        String numShardsEnv = System.getProperty("db.shards", "2");
        int numShards = Integer.parseInt(numShardsEnv);
        this.shardManager = new ShardManager(numShards);
        ImmutableList inEntities = ImmutableList.builder().add(entity).add((Object[])entities).build();
        int i = 0;
        while (i < numShards) {
            final int finalI = i++;
            this.shardBundles.add(new HibernateBundle<T>(inEntities, new SessionFactoryFactory()){

                protected String name() {
                    return String.format("connectionpool-%d", finalI);
                }

                public PooledDataSourceFactory getDataSourceFactory(T t) {
                    return (PooledDataSourceFactory)DBShardingBundle.this.getConfig(t).getShards().get(finalI);
                }
            });
        }
    }

    public void run(T configuration, Environment environment) throws Exception {
        this.sessionFactories = this.shardBundles.stream().map(HibernateBundle::getSessionFactory).collect(Collectors.toList());
    }

    public void initialize(Bootstrap<?> bootstrap) {
        this.shardBundles.forEach(hibernateBundle -> bootstrap.addBundle((ConfiguredBundle)hibernateBundle));
    }

    @VisibleForTesting
    public void runBundles(T configuration, Environment environment) {
        this.shardBundles.forEach(hibernateBundle -> {
            try {
                hibernateBundle.run(configuration, environment);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @VisibleForTesting
    public void initBundles(Bootstrap bootstrap) {
        this.shardBundles.forEach(hibernameBundle -> this.initialize(bootstrap));
    }

    protected abstract ShardedHibernateFactory getConfig(T var1);

    public static <EntityType, T extends Configuration> LookupDao<EntityType> createParentObjectDao(DBShardingBundle<T> bundle, Class<EntityType> clazz) {
        return new LookupDao<EntityType>(bundle.sessionFactories, clazz, bundle.shardManager);
    }

    public static <EntityType, T extends Configuration> RelationalDao<EntityType> createRelatedObjectDao(DBShardingBundle<T> bundle, Class<EntityType> clazz) {
        return new RelationalDao<EntityType>(bundle.sessionFactories, clazz, bundle.shardManager);
    }

    public static <EntityType, DaoType extends AbstractDAO<EntityType>, T extends Configuration> WrapperDao<EntityType, DaoType> createWrapperDao(DBShardingBundle<T> bundle, Class<DaoType> daoTypeClass) {
        return new WrapperDao(bundle.sessionFactories, daoTypeClass, bundle.shardManager);
    }

    public static <EntityType, DaoType extends AbstractDAO<EntityType>, T extends Configuration> WrapperDao<EntityType, DaoType> createWrapperDao(DBShardingBundle<T> bundle, Class<DaoType> daoTypeClass, Class[] extraConstructorParamClasses, Class[] extraConstructorParamObjects) {
        return new WrapperDao(bundle.sessionFactories, daoTypeClass, bundle.shardManager, extraConstructorParamClasses, extraConstructorParamObjects);
    }

    public List<SessionFactory> getSessionFactories() {
        return this.sessionFactories;
    }

    public ShardManager getShardManager() {
        return this.shardManager;
    }
}

