/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.sharding.config;

import com.google.common.collect.Lists;
import io.dropwizard.db.DataSourceFactory;
import io.dropwizard.util.Duration;
import io.dropwizard.validation.MinDuration;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

public class ShardedHibernateFactory {
    @NotNull
    private String driverClass = null;
    @Min(value=0L)
    @Max(value=100L)
    private int abandonWhenPercentageFull = 0;
    private boolean alternateUsernamesAllowed = false;
    private boolean commitOnReturn = false;
    private boolean rollbackOnReturn = false;
    private Boolean autoCommitByDefault;
    private Boolean readOnlyByDefault;
    private String user = null;
    private String password = null;
    @NotNull
    private Map<String, String> properties = new LinkedHashMap<String, String>();
    private String defaultCatalog;
    @NotNull
    private DataSourceFactory.TransactionIsolation defaultTransactionIsolation = DataSourceFactory.TransactionIsolation.DEFAULT;
    private boolean useFairQueue = true;
    @Min(value=0L)
    private int initialSize = 10;
    @Min(value=0L)
    private int minSize = 10;
    @Min(value=1L)
    private int maxSize = 100;
    private String initializationQuery;
    private boolean logAbandonedConnections = false;
    private boolean logValidationErrors = false;
    @MinDuration(value=1L, unit=TimeUnit.SECONDS)
    private Duration maxConnectionAge;
    @NotNull
    @MinDuration(value=1L, unit=TimeUnit.SECONDS)
    private Duration maxWaitForConnection = Duration.seconds((long)30L);
    @NotNull
    @MinDuration(value=1L, unit=TimeUnit.SECONDS)
    private Duration minIdleTime = Duration.minutes((long)1L);
    @NotNull
    private String validationQuery = "/* Health Check */ SELECT 1";
    @MinDuration(value=1L, unit=TimeUnit.SECONDS)
    private Duration validationQueryTimeout;
    private boolean checkConnectionWhileIdle = true;
    private boolean checkConnectionOnBorrow = false;
    private boolean checkConnectionOnConnect = true;
    private boolean checkConnectionOnReturn = false;
    private boolean autoCommentsEnabled = true;
    @NotNull
    @MinDuration(value=1L)
    private Duration evictionInterval = Duration.seconds((long)5L);
    @NotNull
    @MinDuration(value=1L)
    private Duration validationInterval = Duration.seconds((long)30L);
    private Optional<String> validatorClassName = Optional.empty();
    private boolean removeAbandoned = false;
    @NotNull
    @MinDuration(value=1L)
    private Duration removeAbandonedTimeout = Duration.seconds((long)60L);
    @NotNull
    @NotEmpty
    private List<String> urls = Lists.newArrayList();

    public DataSourceFactory shard(int i) {
        DataSourceFactory dataSourceFactory = new DataSourceFactory();
        dataSourceFactory.setDriverClass(this.driverClass);
        dataSourceFactory.setAbandonWhenPercentageFull(this.abandonWhenPercentageFull);
        dataSourceFactory.setAlternateUsernamesAllowed(this.alternateUsernamesAllowed);
        dataSourceFactory.setCommitOnReturn(this.commitOnReturn);
        dataSourceFactory.setRollbackOnReturn(this.rollbackOnReturn);
        dataSourceFactory.setAutoCommitByDefault(this.autoCommitByDefault);
        dataSourceFactory.setReadOnlyByDefault(this.readOnlyByDefault);
        dataSourceFactory.setUser(this.user);
        dataSourceFactory.setPassword(this.password);
        dataSourceFactory.setUrl(this.urls.get(i));
        dataSourceFactory.setProperties(this.properties);
        dataSourceFactory.setDefaultCatalog(this.defaultCatalog);
        dataSourceFactory.setDefaultTransactionIsolation(this.defaultTransactionIsolation);
        dataSourceFactory.setUseFairQueue(this.useFairQueue);
        dataSourceFactory.setInitialSize(this.initialSize);
        dataSourceFactory.setMinSize(this.minSize);
        dataSourceFactory.setMaxSize(this.maxSize);
        dataSourceFactory.setInitializationQuery(this.initializationQuery);
        dataSourceFactory.setLogAbandonedConnections(this.logAbandonedConnections);
        dataSourceFactory.setLogValidationErrors(this.logValidationErrors);
        dataSourceFactory.setMaxConnectionAge(this.maxConnectionAge);
        dataSourceFactory.setMinIdleTime(this.minIdleTime);
        dataSourceFactory.setValidationQuery(this.validationQuery);
        dataSourceFactory.setValidationQueryTimeout(this.validationQueryTimeout);
        dataSourceFactory.setCheckConnectionWhileIdle(this.checkConnectionWhileIdle);
        dataSourceFactory.setCheckConnectionOnBorrow(this.checkConnectionOnBorrow);
        dataSourceFactory.setCheckConnectionOnConnect(this.checkConnectionOnConnect);
        dataSourceFactory.setCheckConnectionOnReturn(this.checkConnectionOnReturn);
        dataSourceFactory.setAutoCommentsEnabled(this.autoCommentsEnabled);
        dataSourceFactory.setEvictionInterval(this.evictionInterval);
        dataSourceFactory.setValidationInterval(this.validationInterval);
        dataSourceFactory.setValidatorClassName(this.validatorClassName);
        dataSourceFactory.setRemoveAbandoned(this.removeAbandoned);
        return dataSourceFactory;
    }

    public static ShardedHibernateFactoryBuilder builder() {
        return new ShardedHibernateFactoryBuilder();
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public int getAbandonWhenPercentageFull() {
        return this.abandonWhenPercentageFull;
    }

    public boolean isAlternateUsernamesAllowed() {
        return this.alternateUsernamesAllowed;
    }

    public boolean isCommitOnReturn() {
        return this.commitOnReturn;
    }

    public boolean isRollbackOnReturn() {
        return this.rollbackOnReturn;
    }

    public Boolean getAutoCommitByDefault() {
        return this.autoCommitByDefault;
    }

    public Boolean getReadOnlyByDefault() {
        return this.readOnlyByDefault;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public DataSourceFactory.TransactionIsolation getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public boolean isUseFairQueue() {
        return this.useFairQueue;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public String getInitializationQuery() {
        return this.initializationQuery;
    }

    public boolean isLogAbandonedConnections() {
        return this.logAbandonedConnections;
    }

    public boolean isLogValidationErrors() {
        return this.logValidationErrors;
    }

    public Duration getMaxConnectionAge() {
        return this.maxConnectionAge;
    }

    public Duration getMaxWaitForConnection() {
        return this.maxWaitForConnection;
    }

    public Duration getMinIdleTime() {
        return this.minIdleTime;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public Duration getValidationQueryTimeout() {
        return this.validationQueryTimeout;
    }

    public boolean isCheckConnectionWhileIdle() {
        return this.checkConnectionWhileIdle;
    }

    public boolean isCheckConnectionOnBorrow() {
        return this.checkConnectionOnBorrow;
    }

    public boolean isCheckConnectionOnConnect() {
        return this.checkConnectionOnConnect;
    }

    public boolean isCheckConnectionOnReturn() {
        return this.checkConnectionOnReturn;
    }

    public boolean isAutoCommentsEnabled() {
        return this.autoCommentsEnabled;
    }

    public Duration getEvictionInterval() {
        return this.evictionInterval;
    }

    public Duration getValidationInterval() {
        return this.validationInterval;
    }

    public Optional<String> getValidatorClassName() {
        return this.validatorClassName;
    }

    public boolean isRemoveAbandoned() {
        return this.removeAbandoned;
    }

    public Duration getRemoveAbandonedTimeout() {
        return this.removeAbandonedTimeout;
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public void setAbandonWhenPercentageFull(int abandonWhenPercentageFull) {
        this.abandonWhenPercentageFull = abandonWhenPercentageFull;
    }

    public void setAlternateUsernamesAllowed(boolean alternateUsernamesAllowed) {
        this.alternateUsernamesAllowed = alternateUsernamesAllowed;
    }

    public void setCommitOnReturn(boolean commitOnReturn) {
        this.commitOnReturn = commitOnReturn;
    }

    public void setRollbackOnReturn(boolean rollbackOnReturn) {
        this.rollbackOnReturn = rollbackOnReturn;
    }

    public void setAutoCommitByDefault(Boolean autoCommitByDefault) {
        this.autoCommitByDefault = autoCommitByDefault;
    }

    public void setReadOnlyByDefault(Boolean readOnlyByDefault) {
        this.readOnlyByDefault = readOnlyByDefault;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = defaultCatalog;
    }

    public void setDefaultTransactionIsolation(DataSourceFactory.TransactionIsolation defaultTransactionIsolation) {
        this.defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public void setUseFairQueue(boolean useFairQueue) {
        this.useFairQueue = useFairQueue;
    }

    public void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    public void setMinSize(int minSize) {
        this.minSize = minSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setInitializationQuery(String initializationQuery) {
        this.initializationQuery = initializationQuery;
    }

    public void setLogAbandonedConnections(boolean logAbandonedConnections) {
        this.logAbandonedConnections = logAbandonedConnections;
    }

    public void setLogValidationErrors(boolean logValidationErrors) {
        this.logValidationErrors = logValidationErrors;
    }

    public void setMaxConnectionAge(Duration maxConnectionAge) {
        this.maxConnectionAge = maxConnectionAge;
    }

    public void setMaxWaitForConnection(Duration maxWaitForConnection) {
        this.maxWaitForConnection = maxWaitForConnection;
    }

    public void setMinIdleTime(Duration minIdleTime) {
        this.minIdleTime = minIdleTime;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public void setValidationQueryTimeout(Duration validationQueryTimeout) {
        this.validationQueryTimeout = validationQueryTimeout;
    }

    public void setCheckConnectionWhileIdle(boolean checkConnectionWhileIdle) {
        this.checkConnectionWhileIdle = checkConnectionWhileIdle;
    }

    public void setCheckConnectionOnBorrow(boolean checkConnectionOnBorrow) {
        this.checkConnectionOnBorrow = checkConnectionOnBorrow;
    }

    public void setCheckConnectionOnConnect(boolean checkConnectionOnConnect) {
        this.checkConnectionOnConnect = checkConnectionOnConnect;
    }

    public void setCheckConnectionOnReturn(boolean checkConnectionOnReturn) {
        this.checkConnectionOnReturn = checkConnectionOnReturn;
    }

    public void setAutoCommentsEnabled(boolean autoCommentsEnabled) {
        this.autoCommentsEnabled = autoCommentsEnabled;
    }

    public void setEvictionInterval(Duration evictionInterval) {
        this.evictionInterval = evictionInterval;
    }

    public void setValidationInterval(Duration validationInterval) {
        this.validationInterval = validationInterval;
    }

    public void setValidatorClassName(Optional<String> validatorClassName) {
        this.validatorClassName = validatorClassName;
    }

    public void setRemoveAbandoned(boolean removeAbandoned) {
        this.removeAbandoned = removeAbandoned;
    }

    public void setRemoveAbandonedTimeout(Duration removeAbandonedTimeout) {
        this.removeAbandonedTimeout = removeAbandonedTimeout;
    }

    public void setUrls(List<String> urls) {
        this.urls = urls;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardedHibernateFactory)) {
            return false;
        }
        ShardedHibernateFactory other = (ShardedHibernateFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$driverClass = this.getDriverClass();
        String other$driverClass = other.getDriverClass();
        if (this$driverClass == null ? other$driverClass != null : !this$driverClass.equals(other$driverClass)) {
            return false;
        }
        if (this.getAbandonWhenPercentageFull() != other.getAbandonWhenPercentageFull()) {
            return false;
        }
        if (this.isAlternateUsernamesAllowed() != other.isAlternateUsernamesAllowed()) {
            return false;
        }
        if (this.isCommitOnReturn() != other.isCommitOnReturn()) {
            return false;
        }
        if (this.isRollbackOnReturn() != other.isRollbackOnReturn()) {
            return false;
        }
        Boolean this$autoCommitByDefault = this.getAutoCommitByDefault();
        Boolean other$autoCommitByDefault = other.getAutoCommitByDefault();
        if (this$autoCommitByDefault == null ? other$autoCommitByDefault != null : !((Object)this$autoCommitByDefault).equals(other$autoCommitByDefault)) {
            return false;
        }
        Boolean this$readOnlyByDefault = this.getReadOnlyByDefault();
        Boolean other$readOnlyByDefault = other.getReadOnlyByDefault();
        if (this$readOnlyByDefault == null ? other$readOnlyByDefault != null : !((Object)this$readOnlyByDefault).equals(other$readOnlyByDefault)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$defaultCatalog = this.getDefaultCatalog();
        String other$defaultCatalog = other.getDefaultCatalog();
        if (this$defaultCatalog == null ? other$defaultCatalog != null : !this$defaultCatalog.equals(other$defaultCatalog)) {
            return false;
        }
        DataSourceFactory.TransactionIsolation this$defaultTransactionIsolation = this.getDefaultTransactionIsolation();
        DataSourceFactory.TransactionIsolation other$defaultTransactionIsolation = other.getDefaultTransactionIsolation();
        if (this$defaultTransactionIsolation == null ? other$defaultTransactionIsolation != null : !this$defaultTransactionIsolation.equals(other$defaultTransactionIsolation)) {
            return false;
        }
        if (this.isUseFairQueue() != other.isUseFairQueue()) {
            return false;
        }
        if (this.getInitialSize() != other.getInitialSize()) {
            return false;
        }
        if (this.getMinSize() != other.getMinSize()) {
            return false;
        }
        if (this.getMaxSize() != other.getMaxSize()) {
            return false;
        }
        String this$initializationQuery = this.getInitializationQuery();
        String other$initializationQuery = other.getInitializationQuery();
        if (this$initializationQuery == null ? other$initializationQuery != null : !this$initializationQuery.equals(other$initializationQuery)) {
            return false;
        }
        if (this.isLogAbandonedConnections() != other.isLogAbandonedConnections()) {
            return false;
        }
        if (this.isLogValidationErrors() != other.isLogValidationErrors()) {
            return false;
        }
        Duration this$maxConnectionAge = this.getMaxConnectionAge();
        Duration other$maxConnectionAge = other.getMaxConnectionAge();
        if (this$maxConnectionAge == null ? other$maxConnectionAge != null : !this$maxConnectionAge.equals(other$maxConnectionAge)) {
            return false;
        }
        Duration this$maxWaitForConnection = this.getMaxWaitForConnection();
        Duration other$maxWaitForConnection = other.getMaxWaitForConnection();
        if (this$maxWaitForConnection == null ? other$maxWaitForConnection != null : !this$maxWaitForConnection.equals(other$maxWaitForConnection)) {
            return false;
        }
        Duration this$minIdleTime = this.getMinIdleTime();
        Duration other$minIdleTime = other.getMinIdleTime();
        if (this$minIdleTime == null ? other$minIdleTime != null : !this$minIdleTime.equals(other$minIdleTime)) {
            return false;
        }
        String this$validationQuery = this.getValidationQuery();
        String other$validationQuery = other.getValidationQuery();
        if (this$validationQuery == null ? other$validationQuery != null : !this$validationQuery.equals(other$validationQuery)) {
            return false;
        }
        Duration this$validationQueryTimeout = this.getValidationQueryTimeout();
        Duration other$validationQueryTimeout = other.getValidationQueryTimeout();
        if (this$validationQueryTimeout == null ? other$validationQueryTimeout != null : !this$validationQueryTimeout.equals(other$validationQueryTimeout)) {
            return false;
        }
        if (this.isCheckConnectionWhileIdle() != other.isCheckConnectionWhileIdle()) {
            return false;
        }
        if (this.isCheckConnectionOnBorrow() != other.isCheckConnectionOnBorrow()) {
            return false;
        }
        if (this.isCheckConnectionOnConnect() != other.isCheckConnectionOnConnect()) {
            return false;
        }
        if (this.isCheckConnectionOnReturn() != other.isCheckConnectionOnReturn()) {
            return false;
        }
        if (this.isAutoCommentsEnabled() != other.isAutoCommentsEnabled()) {
            return false;
        }
        Duration this$evictionInterval = this.getEvictionInterval();
        Duration other$evictionInterval = other.getEvictionInterval();
        if (this$evictionInterval == null ? other$evictionInterval != null : !this$evictionInterval.equals(other$evictionInterval)) {
            return false;
        }
        Duration this$validationInterval = this.getValidationInterval();
        Duration other$validationInterval = other.getValidationInterval();
        if (this$validationInterval == null ? other$validationInterval != null : !this$validationInterval.equals(other$validationInterval)) {
            return false;
        }
        Optional<String> this$validatorClassName = this.getValidatorClassName();
        Optional<String> other$validatorClassName = other.getValidatorClassName();
        if (this$validatorClassName == null ? other$validatorClassName != null : !((Object)this$validatorClassName).equals(other$validatorClassName)) {
            return false;
        }
        if (this.isRemoveAbandoned() != other.isRemoveAbandoned()) {
            return false;
        }
        Duration this$removeAbandonedTimeout = this.getRemoveAbandonedTimeout();
        Duration other$removeAbandonedTimeout = other.getRemoveAbandonedTimeout();
        if (this$removeAbandonedTimeout == null ? other$removeAbandonedTimeout != null : !this$removeAbandonedTimeout.equals(other$removeAbandonedTimeout)) {
            return false;
        }
        List<String> this$urls = this.getUrls();
        List<String> other$urls = other.getUrls();
        return !(this$urls == null ? other$urls != null : !((Object)this$urls).equals(other$urls));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShardedHibernateFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $driverClass = this.getDriverClass();
        result = result * 59 + ($driverClass == null ? 43 : $driverClass.hashCode());
        result = result * 59 + this.getAbandonWhenPercentageFull();
        result = result * 59 + (this.isAlternateUsernamesAllowed() ? 79 : 97);
        result = result * 59 + (this.isCommitOnReturn() ? 79 : 97);
        result = result * 59 + (this.isRollbackOnReturn() ? 79 : 97);
        Boolean $autoCommitByDefault = this.getAutoCommitByDefault();
        result = result * 59 + ($autoCommitByDefault == null ? 43 : ((Object)$autoCommitByDefault).hashCode());
        Boolean $readOnlyByDefault = this.getReadOnlyByDefault();
        result = result * 59 + ($readOnlyByDefault == null ? 43 : ((Object)$readOnlyByDefault).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $defaultCatalog = this.getDefaultCatalog();
        result = result * 59 + ($defaultCatalog == null ? 43 : $defaultCatalog.hashCode());
        DataSourceFactory.TransactionIsolation $defaultTransactionIsolation = this.getDefaultTransactionIsolation();
        result = result * 59 + ($defaultTransactionIsolation == null ? 43 : $defaultTransactionIsolation.hashCode());
        result = result * 59 + (this.isUseFairQueue() ? 79 : 97);
        result = result * 59 + this.getInitialSize();
        result = result * 59 + this.getMinSize();
        result = result * 59 + this.getMaxSize();
        String $initializationQuery = this.getInitializationQuery();
        result = result * 59 + ($initializationQuery == null ? 43 : $initializationQuery.hashCode());
        result = result * 59 + (this.isLogAbandonedConnections() ? 79 : 97);
        result = result * 59 + (this.isLogValidationErrors() ? 79 : 97);
        Duration $maxConnectionAge = this.getMaxConnectionAge();
        result = result * 59 + ($maxConnectionAge == null ? 43 : $maxConnectionAge.hashCode());
        Duration $maxWaitForConnection = this.getMaxWaitForConnection();
        result = result * 59 + ($maxWaitForConnection == null ? 43 : $maxWaitForConnection.hashCode());
        Duration $minIdleTime = this.getMinIdleTime();
        result = result * 59 + ($minIdleTime == null ? 43 : $minIdleTime.hashCode());
        String $validationQuery = this.getValidationQuery();
        result = result * 59 + ($validationQuery == null ? 43 : $validationQuery.hashCode());
        Duration $validationQueryTimeout = this.getValidationQueryTimeout();
        result = result * 59 + ($validationQueryTimeout == null ? 43 : $validationQueryTimeout.hashCode());
        result = result * 59 + (this.isCheckConnectionWhileIdle() ? 79 : 97);
        result = result * 59 + (this.isCheckConnectionOnBorrow() ? 79 : 97);
        result = result * 59 + (this.isCheckConnectionOnConnect() ? 79 : 97);
        result = result * 59 + (this.isCheckConnectionOnReturn() ? 79 : 97);
        result = result * 59 + (this.isAutoCommentsEnabled() ? 79 : 97);
        Duration $evictionInterval = this.getEvictionInterval();
        result = result * 59 + ($evictionInterval == null ? 43 : $evictionInterval.hashCode());
        Duration $validationInterval = this.getValidationInterval();
        result = result * 59 + ($validationInterval == null ? 43 : $validationInterval.hashCode());
        Optional<String> $validatorClassName = this.getValidatorClassName();
        result = result * 59 + ($validatorClassName == null ? 43 : ((Object)$validatorClassName).hashCode());
        result = result * 59 + (this.isRemoveAbandoned() ? 79 : 97);
        Duration $removeAbandonedTimeout = this.getRemoveAbandonedTimeout();
        result = result * 59 + ($removeAbandonedTimeout == null ? 43 : $removeAbandonedTimeout.hashCode());
        List<String> $urls = this.getUrls();
        result = result * 59 + ($urls == null ? 43 : ((Object)$urls).hashCode());
        return result;
    }

    public String toString() {
        return "ShardedHibernateFactory(driverClass=" + this.getDriverClass() + ", abandonWhenPercentageFull=" + this.getAbandonWhenPercentageFull() + ", alternateUsernamesAllowed=" + this.isAlternateUsernamesAllowed() + ", commitOnReturn=" + this.isCommitOnReturn() + ", rollbackOnReturn=" + this.isRollbackOnReturn() + ", autoCommitByDefault=" + this.getAutoCommitByDefault() + ", readOnlyByDefault=" + this.getReadOnlyByDefault() + ", user=" + this.getUser() + ", password=" + this.getPassword() + ", properties=" + this.getProperties() + ", defaultCatalog=" + this.getDefaultCatalog() + ", defaultTransactionIsolation=" + this.getDefaultTransactionIsolation() + ", useFairQueue=" + this.isUseFairQueue() + ", initialSize=" + this.getInitialSize() + ", minSize=" + this.getMinSize() + ", maxSize=" + this.getMaxSize() + ", initializationQuery=" + this.getInitializationQuery() + ", logAbandonedConnections=" + this.isLogAbandonedConnections() + ", logValidationErrors=" + this.isLogValidationErrors() + ", maxConnectionAge=" + this.getMaxConnectionAge() + ", maxWaitForConnection=" + this.getMaxWaitForConnection() + ", minIdleTime=" + this.getMinIdleTime() + ", validationQuery=" + this.getValidationQuery() + ", validationQueryTimeout=" + this.getValidationQueryTimeout() + ", checkConnectionWhileIdle=" + this.isCheckConnectionWhileIdle() + ", checkConnectionOnBorrow=" + this.isCheckConnectionOnBorrow() + ", checkConnectionOnConnect=" + this.isCheckConnectionOnConnect() + ", checkConnectionOnReturn=" + this.isCheckConnectionOnReturn() + ", autoCommentsEnabled=" + this.isAutoCommentsEnabled() + ", evictionInterval=" + this.getEvictionInterval() + ", validationInterval=" + this.getValidationInterval() + ", validatorClassName=" + this.getValidatorClassName() + ", removeAbandoned=" + this.isRemoveAbandoned() + ", removeAbandonedTimeout=" + this.getRemoveAbandonedTimeout() + ", urls=" + this.getUrls() + ")";
    }

    @ConstructorProperties(value={"driverClass", "abandonWhenPercentageFull", "alternateUsernamesAllowed", "commitOnReturn", "rollbackOnReturn", "autoCommitByDefault", "readOnlyByDefault", "user", "password", "properties", "defaultCatalog", "defaultTransactionIsolation", "useFairQueue", "initialSize", "minSize", "maxSize", "initializationQuery", "logAbandonedConnections", "logValidationErrors", "maxConnectionAge", "maxWaitForConnection", "minIdleTime", "validationQuery", "validationQueryTimeout", "checkConnectionWhileIdle", "checkConnectionOnBorrow", "checkConnectionOnConnect", "checkConnectionOnReturn", "autoCommentsEnabled", "evictionInterval", "validationInterval", "validatorClassName", "removeAbandoned", "removeAbandonedTimeout", "urls"})
    public ShardedHibernateFactory(String driverClass, int abandonWhenPercentageFull, boolean alternateUsernamesAllowed, boolean commitOnReturn, boolean rollbackOnReturn, Boolean autoCommitByDefault, Boolean readOnlyByDefault, String user, String password, Map<String, String> properties, String defaultCatalog, DataSourceFactory.TransactionIsolation defaultTransactionIsolation, boolean useFairQueue, int initialSize, int minSize, int maxSize, String initializationQuery, boolean logAbandonedConnections, boolean logValidationErrors, Duration maxConnectionAge, Duration maxWaitForConnection, Duration minIdleTime, String validationQuery, Duration validationQueryTimeout, boolean checkConnectionWhileIdle, boolean checkConnectionOnBorrow, boolean checkConnectionOnConnect, boolean checkConnectionOnReturn, boolean autoCommentsEnabled, Duration evictionInterval, Duration validationInterval, Optional<String> validatorClassName, boolean removeAbandoned, Duration removeAbandonedTimeout, List<String> urls) {
        this.driverClass = driverClass;
        this.abandonWhenPercentageFull = abandonWhenPercentageFull;
        this.alternateUsernamesAllowed = alternateUsernamesAllowed;
        this.commitOnReturn = commitOnReturn;
        this.rollbackOnReturn = rollbackOnReturn;
        this.autoCommitByDefault = autoCommitByDefault;
        this.readOnlyByDefault = readOnlyByDefault;
        this.user = user;
        this.password = password;
        this.properties = properties;
        this.defaultCatalog = defaultCatalog;
        this.defaultTransactionIsolation = defaultTransactionIsolation;
        this.useFairQueue = useFairQueue;
        this.initialSize = initialSize;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.initializationQuery = initializationQuery;
        this.logAbandonedConnections = logAbandonedConnections;
        this.logValidationErrors = logValidationErrors;
        this.maxConnectionAge = maxConnectionAge;
        this.maxWaitForConnection = maxWaitForConnection;
        this.minIdleTime = minIdleTime;
        this.validationQuery = validationQuery;
        this.validationQueryTimeout = validationQueryTimeout;
        this.checkConnectionWhileIdle = checkConnectionWhileIdle;
        this.checkConnectionOnBorrow = checkConnectionOnBorrow;
        this.checkConnectionOnConnect = checkConnectionOnConnect;
        this.checkConnectionOnReturn = checkConnectionOnReturn;
        this.autoCommentsEnabled = autoCommentsEnabled;
        this.evictionInterval = evictionInterval;
        this.validationInterval = validationInterval;
        this.validatorClassName = validatorClassName;
        this.removeAbandoned = removeAbandoned;
        this.removeAbandonedTimeout = removeAbandonedTimeout;
        this.urls = urls;
    }

    public ShardedHibernateFactory() {
    }

    public static class ShardedHibernateFactoryBuilder {
        private String driverClass;
        private int abandonWhenPercentageFull;
        private boolean alternateUsernamesAllowed;
        private boolean commitOnReturn;
        private boolean rollbackOnReturn;
        private Boolean autoCommitByDefault;
        private Boolean readOnlyByDefault;
        private String user;
        private String password;
        private Map<String, String> properties;
        private String defaultCatalog;
        private DataSourceFactory.TransactionIsolation defaultTransactionIsolation;
        private boolean useFairQueue;
        private int initialSize;
        private int minSize;
        private int maxSize;
        private String initializationQuery;
        private boolean logAbandonedConnections;
        private boolean logValidationErrors;
        private Duration maxConnectionAge;
        private Duration maxWaitForConnection;
        private Duration minIdleTime;
        private String validationQuery;
        private Duration validationQueryTimeout;
        private boolean checkConnectionWhileIdle;
        private boolean checkConnectionOnBorrow;
        private boolean checkConnectionOnConnect;
        private boolean checkConnectionOnReturn;
        private boolean autoCommentsEnabled;
        private Duration evictionInterval;
        private Duration validationInterval;
        private Optional<String> validatorClassName;
        private boolean removeAbandoned;
        private Duration removeAbandonedTimeout;
        private ArrayList<String> urls;

        ShardedHibernateFactoryBuilder() {
        }

        public ShardedHibernateFactoryBuilder driverClass(String driverClass) {
            this.driverClass = driverClass;
            return this;
        }

        public ShardedHibernateFactoryBuilder abandonWhenPercentageFull(int abandonWhenPercentageFull) {
            this.abandonWhenPercentageFull = abandonWhenPercentageFull;
            return this;
        }

        public ShardedHibernateFactoryBuilder alternateUsernamesAllowed(boolean alternateUsernamesAllowed) {
            this.alternateUsernamesAllowed = alternateUsernamesAllowed;
            return this;
        }

        public ShardedHibernateFactoryBuilder commitOnReturn(boolean commitOnReturn) {
            this.commitOnReturn = commitOnReturn;
            return this;
        }

        public ShardedHibernateFactoryBuilder rollbackOnReturn(boolean rollbackOnReturn) {
            this.rollbackOnReturn = rollbackOnReturn;
            return this;
        }

        public ShardedHibernateFactoryBuilder autoCommitByDefault(Boolean autoCommitByDefault) {
            this.autoCommitByDefault = autoCommitByDefault;
            return this;
        }

        public ShardedHibernateFactoryBuilder readOnlyByDefault(Boolean readOnlyByDefault) {
            this.readOnlyByDefault = readOnlyByDefault;
            return this;
        }

        public ShardedHibernateFactoryBuilder user(String user) {
            this.user = user;
            return this;
        }

        public ShardedHibernateFactoryBuilder password(String password) {
            this.password = password;
            return this;
        }

        public ShardedHibernateFactoryBuilder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public ShardedHibernateFactoryBuilder defaultCatalog(String defaultCatalog) {
            this.defaultCatalog = defaultCatalog;
            return this;
        }

        public ShardedHibernateFactoryBuilder defaultTransactionIsolation(DataSourceFactory.TransactionIsolation defaultTransactionIsolation) {
            this.defaultTransactionIsolation = defaultTransactionIsolation;
            return this;
        }

        public ShardedHibernateFactoryBuilder useFairQueue(boolean useFairQueue) {
            this.useFairQueue = useFairQueue;
            return this;
        }

        public ShardedHibernateFactoryBuilder initialSize(int initialSize) {
            this.initialSize = initialSize;
            return this;
        }

        public ShardedHibernateFactoryBuilder minSize(int minSize) {
            this.minSize = minSize;
            return this;
        }

        public ShardedHibernateFactoryBuilder maxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public ShardedHibernateFactoryBuilder initializationQuery(String initializationQuery) {
            this.initializationQuery = initializationQuery;
            return this;
        }

        public ShardedHibernateFactoryBuilder logAbandonedConnections(boolean logAbandonedConnections) {
            this.logAbandonedConnections = logAbandonedConnections;
            return this;
        }

        public ShardedHibernateFactoryBuilder logValidationErrors(boolean logValidationErrors) {
            this.logValidationErrors = logValidationErrors;
            return this;
        }

        public ShardedHibernateFactoryBuilder maxConnectionAge(Duration maxConnectionAge) {
            this.maxConnectionAge = maxConnectionAge;
            return this;
        }

        public ShardedHibernateFactoryBuilder maxWaitForConnection(Duration maxWaitForConnection) {
            this.maxWaitForConnection = maxWaitForConnection;
            return this;
        }

        public ShardedHibernateFactoryBuilder minIdleTime(Duration minIdleTime) {
            this.minIdleTime = minIdleTime;
            return this;
        }

        public ShardedHibernateFactoryBuilder validationQuery(String validationQuery) {
            this.validationQuery = validationQuery;
            return this;
        }

        public ShardedHibernateFactoryBuilder validationQueryTimeout(Duration validationQueryTimeout) {
            this.validationQueryTimeout = validationQueryTimeout;
            return this;
        }

        public ShardedHibernateFactoryBuilder checkConnectionWhileIdle(boolean checkConnectionWhileIdle) {
            this.checkConnectionWhileIdle = checkConnectionWhileIdle;
            return this;
        }

        public ShardedHibernateFactoryBuilder checkConnectionOnBorrow(boolean checkConnectionOnBorrow) {
            this.checkConnectionOnBorrow = checkConnectionOnBorrow;
            return this;
        }

        public ShardedHibernateFactoryBuilder checkConnectionOnConnect(boolean checkConnectionOnConnect) {
            this.checkConnectionOnConnect = checkConnectionOnConnect;
            return this;
        }

        public ShardedHibernateFactoryBuilder checkConnectionOnReturn(boolean checkConnectionOnReturn) {
            this.checkConnectionOnReturn = checkConnectionOnReturn;
            return this;
        }

        public ShardedHibernateFactoryBuilder autoCommentsEnabled(boolean autoCommentsEnabled) {
            this.autoCommentsEnabled = autoCommentsEnabled;
            return this;
        }

        public ShardedHibernateFactoryBuilder evictionInterval(Duration evictionInterval) {
            this.evictionInterval = evictionInterval;
            return this;
        }

        public ShardedHibernateFactoryBuilder validationInterval(Duration validationInterval) {
            this.validationInterval = validationInterval;
            return this;
        }

        public ShardedHibernateFactoryBuilder validatorClassName(Optional<String> validatorClassName) {
            this.validatorClassName = validatorClassName;
            return this;
        }

        public ShardedHibernateFactoryBuilder removeAbandoned(boolean removeAbandoned) {
            this.removeAbandoned = removeAbandoned;
            return this;
        }

        public ShardedHibernateFactoryBuilder removeAbandonedTimeout(Duration removeAbandonedTimeout) {
            this.removeAbandonedTimeout = removeAbandonedTimeout;
            return this;
        }

        public ShardedHibernateFactoryBuilder url(String url) {
            if (this.urls == null) {
                this.urls = new ArrayList();
            }
            this.urls.add(url);
            return this;
        }

        public ShardedHibernateFactoryBuilder urls(Collection<? extends String> urls) {
            if (this.urls == null) {
                this.urls = new ArrayList();
            }
            this.urls.addAll(urls);
            return this;
        }

        public ShardedHibernateFactory build() {
            List<String> urls;
            switch (this.urls == null ? 0 : this.urls.size()) {
                case 0: {
                    urls = Collections.emptyList();
                    break;
                }
                case 1: {
                    urls = Collections.singletonList(this.urls.get(0));
                    break;
                }
                default: {
                    urls = Collections.unmodifiableList(new ArrayList<String>(this.urls));
                }
            }
            return new ShardedHibernateFactory(this.driverClass, this.abandonWhenPercentageFull, this.alternateUsernamesAllowed, this.commitOnReturn, this.rollbackOnReturn, this.autoCommitByDefault, this.readOnlyByDefault, this.user, this.password, this.properties, this.defaultCatalog, this.defaultTransactionIsolation, this.useFairQueue, this.initialSize, this.minSize, this.maxSize, this.initializationQuery, this.logAbandonedConnections, this.logValidationErrors, this.maxConnectionAge, this.maxWaitForConnection, this.minIdleTime, this.validationQuery, this.validationQueryTimeout, this.checkConnectionWhileIdle, this.checkConnectionOnBorrow, this.checkConnectionOnConnect, this.checkConnectionOnReturn, this.autoCommentsEnabled, this.evictionInterval, this.validationInterval, this.validatorClassName, this.removeAbandoned, this.removeAbandonedTimeout, urls);
        }

        public String toString() {
            return "ShardedHibernateFactory.ShardedHibernateFactoryBuilder(driverClass=" + this.driverClass + ", abandonWhenPercentageFull=" + this.abandonWhenPercentageFull + ", alternateUsernamesAllowed=" + this.alternateUsernamesAllowed + ", commitOnReturn=" + this.commitOnReturn + ", rollbackOnReturn=" + this.rollbackOnReturn + ", autoCommitByDefault=" + this.autoCommitByDefault + ", readOnlyByDefault=" + this.readOnlyByDefault + ", user=" + this.user + ", password=" + this.password + ", properties=" + this.properties + ", defaultCatalog=" + this.defaultCatalog + ", defaultTransactionIsolation=" + this.defaultTransactionIsolation + ", useFairQueue=" + this.useFairQueue + ", initialSize=" + this.initialSize + ", minSize=" + this.minSize + ", maxSize=" + this.maxSize + ", initializationQuery=" + this.initializationQuery + ", logAbandonedConnections=" + this.logAbandonedConnections + ", logValidationErrors=" + this.logValidationErrors + ", maxConnectionAge=" + this.maxConnectionAge + ", maxWaitForConnection=" + this.maxWaitForConnection + ", minIdleTime=" + this.minIdleTime + ", validationQuery=" + this.validationQuery + ", validationQueryTimeout=" + this.validationQueryTimeout + ", checkConnectionWhileIdle=" + this.checkConnectionWhileIdle + ", checkConnectionOnBorrow=" + this.checkConnectionOnBorrow + ", checkConnectionOnConnect=" + this.checkConnectionOnConnect + ", checkConnectionOnReturn=" + this.checkConnectionOnReturn + ", autoCommentsEnabled=" + this.autoCommentsEnabled + ", evictionInterval=" + this.evictionInterval + ", validationInterval=" + this.validationInterval + ", validatorClassName=" + this.validatorClassName + ", removeAbandoned=" + this.removeAbandoned + ", removeAbandonedTimeout=" + this.removeAbandonedTimeout + ", urls=" + this.urls + ")";
        }
    }
}

