/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.sharding.dao;

import io.dropwizard.sharding.caching.LookupCache;
import io.dropwizard.sharding.dao.LookupDao;
import io.dropwizard.sharding.sharding.BucketIdExtractor;
import io.dropwizard.sharding.sharding.ShardManager;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheableLookupDao<T>
extends LookupDao<T> {
    private static final Logger log = LoggerFactory.getLogger(CacheableLookupDao.class);
    private LookupCache<T> cache;

    public CacheableLookupDao(List<SessionFactory> sessionFactories, Class<T> entityClass, ShardManager shardManager, BucketIdExtractor<String> bucketIdExtractor, LookupCache<T> cache) {
        super(sessionFactories, entityClass, shardManager, bucketIdExtractor);
        this.cache = cache;
    }

    @Override
    public Optional<T> get(String key) throws Exception {
        if (this.cache.exists(key)) {
            return Optional.ofNullable(this.cache.get(key));
        }
        Object entity = super.get(key, t -> t);
        if (entity != null) {
            this.cache.put(key, entity);
        }
        return Optional.ofNullable(entity);
    }

    @Override
    public Optional<T> save(T entity) throws Exception {
        Object savedEntity = super.save(entity, t -> t);
        if (savedEntity != null) {
            String key = this.getKeyField().get(entity).toString();
            this.cache.put(key, entity);
        }
        return Optional.ofNullable(savedEntity);
    }

    @Override
    public boolean update(String id, Function<Optional<T>, T> updater) {
        boolean result = super.update(id, updater);
        if (result) {
            try {
                Optional updatedEntity = super.get(id);
                if (updatedEntity.isPresent()) {
                    this.cache.put(id, updatedEntity.get());
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error updating entity: " + id, e);
            }
        }
        return result;
    }

    @Override
    public boolean exists(String key) throws Exception {
        if (this.cache.exists(key)) {
            return true;
        }
        Optional entity = super.get(key);
        if (entity.isPresent()) {
            this.cache.put(key, entity.get());
        }
        return entity.isPresent();
    }
}

