/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.sharding.utils;

import io.dropwizard.sharding.utils.TransactionHandler;
import java.util.Optional;
import java.util.function.Function;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class Transactions {
    private Transactions() {
    }

    public static <T, U> Optional<T> executeAndResolve(SessionFactory sessionFactory, Function<U, T> function, U arg) {
        return Transactions.executeAndResolve(sessionFactory, false, function, arg);
    }

    public static <T, U> Optional<T> executeAndResolve(SessionFactory sessionFactory, boolean readOnly, Function<U, T> function, U arg) {
        T result = Transactions.execute(sessionFactory, readOnly, function, arg);
        return Optional.ofNullable(result);
    }

    public static <T, U> T execute(SessionFactory sessionFactory, boolean readOnly, Function<U, T> function, U arg) {
        return (T)Transactions.execute(sessionFactory, readOnly, function, arg, t -> t);
    }

    public static <T, U, V> V execute(SessionFactory sessionFactory, boolean readOnly, Function<U, T> function, U arg, Function<T, V> handler) {
        return Transactions.execute(sessionFactory, readOnly, function, arg, handler, true);
    }

    public static <T, U, V> V execute(SessionFactory sessionFactory, boolean readOnly, Function<U, T> function, U arg, Function<T, V> handler, boolean completeTransaction) {
        TransactionHandler transactionHandler = new TransactionHandler(sessionFactory, readOnly);
        if (completeTransaction) {
            transactionHandler.beforeStart();
        }
        try {
            T result = function.apply(arg);
            V returnValue = handler.apply(result);
            if (completeTransaction) {
                transactionHandler.afterEnd();
            }
            return returnValue;
        }
        catch (Exception e) {
            if (completeTransaction) {
                transactionHandler.onError();
            }
            throw e;
        }
    }

    public static <T> T execute(SessionFactory sessionFactory, Function<Session, T> handler) {
        TransactionHandler transactionHandler = new TransactionHandler(sessionFactory, true);
        transactionHandler.beforeStart();
        try {
            T result = handler.apply(transactionHandler.getSession());
            transactionHandler.afterEnd();
            return result;
        }
        catch (Exception e) {
            transactionHandler.onError();
            throw e;
        }
    }
}

