/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.sharding.utils;

import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.context.internal.ManagedSessionContext;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionHandler {
    private static final Logger log = LoggerFactory.getLogger(TransactionHandler.class);
    private Session session;
    private final SessionFactory sessionFactory;
    private final boolean readOnly;

    public TransactionHandler(SessionFactory sessionFactory, boolean readOnly) {
        this.sessionFactory = sessionFactory;
        this.readOnly = readOnly;
        this.session = null;
    }

    public void beforeStart() {
        if (ManagedSessionContext.hasBind((SessionFactory)this.sessionFactory)) {
            log.debug("Not creating session as session as a session is already bound");
            return;
        }
        this.session = this.sessionFactory.openSession();
        try {
            this.configureSession();
            ManagedSessionContext.bind((Session)this.session);
            this.beginTransaction();
        }
        catch (Throwable th) {
            this.session.close();
            this.session = null;
            ManagedSessionContext.unbind((SessionFactory)this.sessionFactory);
            throw th;
        }
    }

    public void afterEnd() {
        if (this.session == null) {
            return;
        }
        try {
            this.commitTransaction();
        }
        catch (Exception e) {
            this.rollbackTransaction();
            throw e;
        }
        finally {
            this.session.close();
            this.session = null;
            ManagedSessionContext.unbind((SessionFactory)this.sessionFactory);
        }
    }

    public void onError() {
        if (this.session == null) {
            return;
        }
        try {
            this.rollbackTransaction();
        }
        finally {
            this.session.close();
            this.session = null;
            ManagedSessionContext.unbind((SessionFactory)this.sessionFactory);
        }
    }

    private void configureSession() {
        this.session.setDefaultReadOnly(this.readOnly);
        this.session.setCacheMode(CacheMode.NORMAL);
        this.session.setHibernateFlushMode(FlushMode.AUTO);
    }

    private void beginTransaction() {
        this.session.beginTransaction();
    }

    private void rollbackTransaction() {
        Transaction txn = this.session.getTransaction();
        if (txn != null && txn.getStatus() == TransactionStatus.ACTIVE) {
            txn.rollback();
        }
    }

    private void commitTransaction() {
        Transaction txn = this.session.getTransaction();
        if (txn != null && txn.getStatus() == TransactionStatus.ACTIVE) {
            txn.commit();
        }
    }

    public Session getSession() {
        return this.session;
    }
}

