/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.sharding.dao;

import io.dropwizard.sharding.caching.RelationalCache;
import io.dropwizard.sharding.dao.RelationalDao;
import io.dropwizard.sharding.utils.ShardCalculator;
import java.util.List;
import java.util.Optional;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.DetachedCriteria;

public class CacheableRelationalDao<T>
extends RelationalDao<T> {
    private RelationalCache<T> cache;

    public CacheableRelationalDao(List<SessionFactory> sessionFactories, Class<T> entityClass, ShardCalculator<String> shardCalculator, RelationalCache<T> cache) {
        super(sessionFactories, entityClass, shardCalculator);
        this.cache = cache;
    }

    @Override
    public Optional<T> get(String parentKey, Object key) {
        if (this.cache.exists(parentKey, key)) {
            return Optional.ofNullable(this.cache.get(parentKey, key));
        }
        Object entity = super.get(parentKey, key, t -> t);
        if (entity != null) {
            this.cache.put(parentKey, key, entity);
        }
        return Optional.ofNullable(entity);
    }

    @Override
    public Optional<T> save(String parentKey, T entity) throws Exception {
        Object savedEntity = super.save(parentKey, entity, (T t) -> t);
        if (savedEntity != null) {
            String key = this.getKeyField().get(entity).toString();
            this.cache.put(parentKey, key, entity);
        }
        return Optional.ofNullable(savedEntity);
    }

    @Override
    public List<T> select(String parentKey, DetachedCriteria criteria) throws Exception {
        List<T> result = this.cache.select(parentKey);
        if (result == null) {
            result = super.select(parentKey, criteria, 0, 10);
        }
        if (result != null) {
            this.cache.put(parentKey, result);
        }
        return result;
    }

    @Override
    public List<T> select(String parentKey, DetachedCriteria criteria, int first, int numResults) throws Exception {
        List<T> result = this.cache.select(parentKey, first, numResults);
        if (result == null) {
            result = super.select(parentKey, criteria, first, numResults);
        }
        if (result != null) {
            this.cache.put(parentKey, first, numResults, result);
        }
        return this.select(parentKey, criteria, first, numResults, t -> t);
    }
}

