/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.sharding.sharding;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import io.dropwizard.sharding.exceptions.ShardBlacklistedException;
import io.dropwizard.sharding.sharding.InMemoryLocalShardBlacklistingStore;
import io.dropwizard.sharding.sharding.ShardBlacklistingStore;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardManager {
    private static final Logger log = LoggerFactory.getLogger(ShardManager.class);
    public static final int MIN_BUCKET = 0;
    public static final int MAX_BUCKET = 999;
    private final int numShards;
    private final ShardBlacklistingStore shardBlacklistingStore;
    private RangeMap<Integer, Integer> buckets = TreeRangeMap.create();
    private LoadingCache<Integer, Boolean> blackListedShards;

    public ShardManager(int numShards) {
        this(numShards, new InMemoryLocalShardBlacklistingStore());
    }

    public ShardManager(int numShards, ShardBlacklistingStore shardBlacklistingStore) {
        this.numShards = numShards;
        this.shardBlacklistingStore = shardBlacklistingStore;
        int interval = 999 / numShards;
        int shardCounter = 0;
        boolean endReached = false;
        int start = 0;
        while (!endReached) {
            int end = start + interval - 1;
            endReached = 999 - start <= 2 * interval;
            end = endReached ? end + 999 - end : end;
            this.buckets.put(Range.closed((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end)), (Object)shardCounter);
            start += interval;
            ++shardCounter;
        }
        log.info("Buckets to shard allocation: {}", this.buckets);
        this.blackListedShards = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(5L, TimeUnit.MINUTES).refreshAfterWrite(1L, TimeUnit.MINUTES).build(shardBlacklistingStore::blacklisted);
    }

    public int shardForBucket(int bucketId) {
        Preconditions.checkArgument((bucketId >= 0 && bucketId <= 999 ? 1 : 0) != 0, (Object)"Bucket id can only be in the range of [1-1000] (inclusive)");
        Map.Entry entry = this.buckets.getEntry((Comparable)Integer.valueOf(bucketId));
        if (null == entry) {
            throw new IllegalAccessError("Bucket not mapped to any shard");
        }
        int shard = (Integer)entry.getValue();
        Boolean isBlacklisted = (Boolean)this.blackListedShards.get((Object)shard);
        if (null != isBlacklisted && isBlacklisted.booleanValue()) {
            throw new ShardBlacklistedException(shard);
        }
        return shard;
    }

    public boolean isMappedToValidShard(int bucketId) {
        if (bucketId >= 0 && bucketId <= 999) {
            return false;
        }
        Map.Entry entry = this.buckets.getEntry((Comparable)Integer.valueOf(bucketId));
        if (null == entry) {
            return false;
        }
        int shard = (Integer)entry.getValue();
        Boolean isBlacklisted = (Boolean)this.blackListedShards.get((Object)shard);
        return null == isBlacklisted || isBlacklisted == false;
    }

    public void blacklistShard(int shardId) {
        if (shardId >= 0 && shardId < this.numShards) {
            this.shardBlacklistingStore.blacklist(shardId);
            this.blackListedShards.refresh((Object)shardId);
        }
    }

    public void unblacklistShard(int shardId) {
        if (shardId >= 0 && shardId < this.numShards) {
            this.shardBlacklistingStore.unblacklist(shardId);
            this.blackListedShards.refresh((Object)shardId);
        }
    }

    public static ShardManagerBuilder builder() {
        return new ShardManagerBuilder();
    }

    public String toString() {
        return "ShardManager(numShards=" + this.numShards + ", shardBlacklistingStore=" + this.shardBlacklistingStore + ", buckets=" + this.buckets + ", blackListedShards=" + this.blackListedShards + ")";
    }

    public static class ShardManagerBuilder {
        private int numShards;
        private ShardBlacklistingStore shardBlacklistingStore;

        ShardManagerBuilder() {
        }

        public ShardManagerBuilder numShards(int numShards) {
            this.numShards = numShards;
            return this;
        }

        public ShardManagerBuilder shardBlacklistingStore(ShardBlacklistingStore shardBlacklistingStore) {
            this.shardBlacklistingStore = shardBlacklistingStore;
            return this;
        }

        public ShardManager build() {
            return new ShardManager(this.numShards, this.shardBlacklistingStore);
        }

        public String toString() {
            return "ShardManager.ShardManagerBuilder(numShards=" + this.numShards + ", shardBlacklistingStore=" + this.shardBlacklistingStore + ")";
        }
    }
}

