/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.sharding.sharding;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import io.dropwizard.sharding.sharding.InMemoryLocalShardBlacklistingStore;
import io.dropwizard.sharding.sharding.ShardBlacklistingStore;
import io.dropwizard.sharding.sharding.ShardManager;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalancedShardManager
extends ShardManager {
    private static final Logger log = LoggerFactory.getLogger(BalancedShardManager.class);
    private static final int MIN_BUCKET = 0;
    private static final int MAX_BUCKET = 1023;
    private final int numShards;
    private RangeMap<Integer, Integer> buckets = TreeRangeMap.create();

    public BalancedShardManager(int numShards) {
        this(numShards, new InMemoryLocalShardBlacklistingStore());
    }

    public BalancedShardManager(int numShards, ShardBlacklistingStore shardBlacklistingStore) {
        super(shardBlacklistingStore);
        Preconditions.checkArgument((numShards > 1 && (numShards & numShards - 1) == 0 ? 1 : 0) != 0, (Object)"Shard manager only support 2^n shards. Also it is senseless to use anything other than 2^n shards for scale out.");
        this.numShards = numShards;
        TreeRangeMap assignedBuckets = TreeRangeMap.create();
        int interval = 1024 / numShards;
        log.trace("Interval: {}", (Object)interval);
        int shardCounter = 0;
        boolean endReached = false;
        int start = 0;
        while (!endReached) {
            int end = start + interval - 1;
            end = shardCounter == numShards - 1 ? 1023 : end;
            endReached = end == 1023;
            log.trace("Assigning {} to {} to shard {}", new Object[]{start, end, shardCounter});
            assignedBuckets.put(Range.closed((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end)), (Object)shardCounter);
            start += interval;
            ++shardCounter;
        }
        Preconditions.checkArgument((boolean)assignedBuckets.asMapOfRanges().keySet().stream().allMatch(range -> (Integer)range.upperEndpoint() - (Integer)range.lowerEndpoint() + 1 == interval));
        this.buckets.putAll((RangeMap)assignedBuckets);
        log.info("Buckets to shard allocation: {}", this.buckets);
    }

    @Override
    public int numBuckets() {
        return 1024;
    }

    @Override
    public int numShards() {
        return this.numShards;
    }

    @Override
    protected int shardForBucketImpl(int bucketId) {
        Preconditions.checkArgument((bucketId >= 0 && bucketId <= 1023 ? 1 : 0) != 0, (Object)"Bucket id can only be in the range of [1-1000] (inclusive)");
        Map.Entry entry = this.buckets.getEntry((Comparable)Integer.valueOf(bucketId));
        if (null == entry) {
            throw new IllegalAccessError("Bucket not mapped to any shard");
        }
        return (Integer)entry.getValue();
    }

    public static BalancedShardManagerBuilder builder() {
        return new BalancedShardManagerBuilder();
    }

    @Override
    public String toString() {
        return "BalancedShardManager(numShards=" + this.numShards + ", buckets=" + this.buckets + ")";
    }

    public static class BalancedShardManagerBuilder {
        private int numShards;

        BalancedShardManagerBuilder() {
        }

        public BalancedShardManagerBuilder numShards(int numShards) {
            this.numShards = numShards;
            return this;
        }

        public BalancedShardManager build() {
            return new BalancedShardManager(this.numShards);
        }

        public String toString() {
            return "BalancedShardManager.BalancedShardManagerBuilder(numShards=" + this.numShards + ")";
        }
    }
}

