/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hystrix.path.tracker.trackers;

import io.dropwizard.hystrix.path.tracker.filters.FilterBuilder;
import io.dropwizard.hystrix.path.tracker.filters.impl.PathTrackerFilter;
import io.dropwizard.hystrix.path.tracker.trackers.TrackPath;
import io.dropwizard.setup.Environment;
import java.beans.ConstructorProperties;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class RuntimeFeature
implements DynamicFeature {
    private static final Logger log = LoggerFactory.getLogger(RuntimeFeature.class);
    private Environment environment;

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        TrackPath trackPath = resourceInfo.getResourceMethod().getAnnotation(TrackPath.class);
        if (trackPath != null) {
            String message = "Registering filter: " + PathTrackerFilter.class.getSimpleName() + " at method: " + resourceInfo.getResourceMethod().getName() + " against resource path: " + trackPath.value();
            log.info(message);
            FilterBuilder.newBuilder().addUrlMapping(trackPath.value()).withClass(PathTrackerFilter.class).build().consume(this.environment);
        }
    }

    @ConstructorProperties(value={"environment"})
    public RuntimeFeature(Environment environment) {
        this.environment = environment;
    }
}

