/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hystrix.path.tracker.filters;

import io.dropwizard.setup.Environment;
import java.beans.ConstructorProperties;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;

public class EnvironmentConsumingFilter {
    private String name;
    private Class<? extends Filter> klass;
    private Map<String, String> initParams;
    private List<String> urlMappings;

    public void consume(Environment environment) {
        if (this.name == null) {
            this.name = this.klass.getSimpleName();
        }
        FilterRegistration.Dynamic filter = environment.servlets().addFilter(this.name, this.klass);
        this.urlMappings.forEach(u -> filter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{u}));
        this.initParams.forEach((arg_0, arg_1) -> ((FilterRegistration.Dynamic)filter).setInitParameter(arg_0, arg_1));
    }

    @ConstructorProperties(value={"name", "klass", "initParams", "urlMappings"})
    public EnvironmentConsumingFilter(String name, Class<? extends Filter> klass, Map<String, String> initParams, List<String> urlMappings) {
        this.name = name;
        this.klass = klass;
        this.initParams = initParams;
        this.urlMappings = urlMappings;
    }
}

