/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hystrix.path.tracker.filters;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.dropwizard.hystrix.path.tracker.filters.EnvironmentConsumingFilter;
import io.dropwizard.hystrix.path.tracker.util.Builder;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;

public class FilterBuilder
implements Builder<EnvironmentConsumingFilter> {
    private String name;
    private Class<? extends Filter> klass;
    private Map<String, String> initParams = Maps.newConcurrentMap();
    private List<String> urlMappings = Lists.newArrayList();

    public static FilterBuilder newBuilder() {
        return new FilterBuilder();
    }

    public FilterBuilder name(String name) {
        this.name = name;
        return this;
    }

    public FilterBuilder withClass(Class<? extends Filter> klass) {
        this.klass = klass;
        return this;
    }

    public FilterBuilder addInitParam(String key, String value) {
        this.initParams.put(key, value);
        return this;
    }

    public FilterBuilder addUrlMapping(String urlMapping) {
        this.urlMappings.add(urlMapping);
        return this;
    }

    @Override
    public EnvironmentConsumingFilter build() {
        return new EnvironmentConsumingFilter(this.name, this.klass, this.initParams, this.urlMappings);
    }
}

