/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.discovery.bundle;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.ranger.ServiceProviderBuilders;
import com.flipkart.ranger.healthcheck.Healthcheck;
import com.flipkart.ranger.healthservice.TimeEntity;
import com.flipkart.ranger.healthservice.monitor.IsolatedHealthMonitor;
import com.flipkart.ranger.serviceprovider.ServiceProvider;
import com.flipkart.ranger.serviceprovider.ServiceProviderBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.appform.dropwizard.discovery.bundle.InfoResource;
import io.appform.dropwizard.discovery.bundle.ServiceDiscoveryConfiguration;
import io.appform.dropwizard.discovery.bundle.healthchecks.InitialDelayChecker;
import io.appform.dropwizard.discovery.bundle.healthchecks.InternalHealthChecker;
import io.appform.dropwizard.discovery.bundle.healthchecks.RotationCheck;
import io.appform.dropwizard.discovery.bundle.id.IdGenerator;
import io.appform.dropwizard.discovery.bundle.id.NodeIdManager;
import io.appform.dropwizard.discovery.bundle.id.constraints.IdValidationConstraint;
import io.appform.dropwizard.discovery.bundle.monitors.DropwizardHealthMonitor;
import io.appform.dropwizard.discovery.bundle.monitors.DropwizardServerStartupCheck;
import io.appform.dropwizard.discovery.bundle.rotationstatus.BIRTask;
import io.appform.dropwizard.discovery.bundle.rotationstatus.DropwizardServerStatus;
import io.appform.dropwizard.discovery.bundle.rotationstatus.OORTask;
import io.appform.dropwizard.discovery.bundle.rotationstatus.RotationStatus;
import io.appform.dropwizard.discovery.client.ServiceDiscoveryClient;
import io.appform.dropwizard.discovery.common.ShardInfo;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.servlets.tasks.Task;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.durg.tsaheylu.metered.ErrorRegistry;
import io.durg.tsaheylu.registry.HealthMetricManager;
import io.durg.tsaheylu.registry.metrics.JVMHeapSizeMetricMonitor;
import io.durg.tsaheylu.registry.metrics.MetricMonitor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryForever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceDiscoveryBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final Logger log = LoggerFactory.getLogger(ServiceDiscoveryBundle.class);
    private ServiceDiscoveryConfiguration serviceDiscoveryConfiguration;
    private List<Healthcheck> healthchecks = Lists.newArrayList();
    private ServiceProvider<ShardInfo> serviceProvider;
    private final List<IdValidationConstraint> globalIdConstraints;
    private CuratorFramework curator;
    private ServiceDiscoveryClient serviceDiscoveryClient;
    @VisibleForTesting
    private RotationStatus rotationStatus;
    @VisibleForTesting
    private DropwizardServerStatus serverStatus;

    protected ServiceDiscoveryBundle() {
        this.globalIdConstraints = Collections.emptyList();
    }

    protected ServiceDiscoveryBundle(List<IdValidationConstraint> globalIdConstraints) {
        this.globalIdConstraints = globalIdConstraints != null ? globalIdConstraints : Collections.emptyList();
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(T configuration, Environment environment) throws Exception {
        this.serviceDiscoveryConfiguration = this.getRangerConfiguration(configuration);
        ObjectMapper objectMapper = environment.getObjectMapper();
        String namespace = this.serviceDiscoveryConfiguration.getNamespace();
        String serviceName = this.getServiceName(configuration);
        String hostname = this.getHost();
        int port = this.getPort(configuration);
        this.rotationStatus = new RotationStatus(this.serviceDiscoveryConfiguration.isInitialRotationStatus());
        this.serverStatus = new DropwizardServerStatus(false);
        this.curator = CuratorFrameworkFactory.builder().connectString(this.serviceDiscoveryConfiguration.getZookeeper()).namespace(namespace).retryPolicy((RetryPolicy)new RetryForever(this.serviceDiscoveryConfiguration.getConnectionRetryIntervalMillis())).build();
        this.serviceProvider = this.buildServiceProvider(environment, objectMapper, namespace, serviceName, hostname, port);
        this.serviceDiscoveryClient = this.buildDiscoveryClient(environment, namespace, serviceName, null);
        environment.lifecycle().manage((Managed)new ServiceDiscoveryManager(serviceName));
        environment.jersey().register((Object)new InfoResource(this.serviceDiscoveryClient));
        environment.admin().addTask((Task)new OORTask(this.rotationStatus));
        environment.admin().addTask((Task)new BIRTask(this.rotationStatus));
    }

    protected abstract ServiceDiscoveryConfiguration getRangerConfiguration(T var1);

    protected abstract String getServiceName(T var1);

    protected List<IsolatedHealthMonitor> getHealthMonitors() {
        return Lists.newArrayList();
    }

    protected int getPort(T configuration) {
        Preconditions.checkArgument((-1 != this.serviceDiscoveryConfiguration.getPublishedPort() && 0 != this.serviceDiscoveryConfiguration.getPublishedPort() ? 1 : 0) != 0, (Object)"Looks like publishedPost has not been set and getPort() has not been overridden. This is wrong. \nEither set publishedPort in config or override getPort() to return the port on which the service is running");
        return this.serviceDiscoveryConfiguration.getPublishedPort();
    }

    protected String getHost() throws UnknownHostException {
        String host = this.serviceDiscoveryConfiguration.getPublishedHost();
        if (Strings.isNullOrEmpty((String)host) || host.equals("__DEFAULT_SERVICE_HOST")) {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        return host;
    }

    public void registerHealthcheck(Healthcheck healthcheck) {
        this.healthchecks.add(healthcheck);
    }

    public void registerHealthchecks(List<Healthcheck> healthchecks) {
        this.healthchecks.addAll(healthchecks);
    }

    private ServiceDiscoveryClient buildDiscoveryClient(Environment environment, String namespace, String serviceName, ErrorRegistry errorRegistry) {
        return ServiceDiscoveryClient.fromCurator().curator(this.curator).namespace(namespace).serviceName(serviceName).environment(this.serviceDiscoveryConfiguration.getEnvironment()).objectMapper(environment.getObjectMapper()).refreshTimeMs(this.serviceDiscoveryConfiguration.getRefreshTimeMs()).disableWatchers(this.serviceDiscoveryConfiguration.isDisableWatchers()).errorRegistry(errorRegistry).build();
    }

    private ServiceProvider<ShardInfo> buildServiceProvider(Environment environment, ObjectMapper objectMapper, String namespace, String serviceName, String hostname, int port) {
        ShardInfo nodeData = ShardInfo.builder().environment(this.serviceDiscoveryConfiguration.getEnvironment()).build();
        long initialDelayForMonitor = this.serviceDiscoveryConfiguration.getInitialDelaySeconds() > 1L ? this.serviceDiscoveryConfiguration.getInitialDelaySeconds() - 1L : 0L;
        int dwMonitoringInterval = this.serviceDiscoveryConfiguration.getDropwizardCheckInterval() == 0 ? 15 : this.serviceDiscoveryConfiguration.getDropwizardCheckInterval();
        int dwMonitoringStaleness = this.serviceDiscoveryConfiguration.getDropwizardCheckStaleness() < dwMonitoringInterval + 1 ? dwMonitoringInterval + 1 : this.serviceDiscoveryConfiguration.getDropwizardCheckStaleness();
        Supplier<Double> healthMetricSupplier = () -> {
            HealthMetricManager healthMetricManager = HealthMetricManager.builder().monitor((MetricMonitor)new JVMHeapSizeMetricMonitor()).build();
            return healthMetricManager.getMetricValue();
        };
        ServiceProviderBuilder serviceProviderBuilder = ServiceProviderBuilders.shardedServiceProviderBuilder().withCuratorFramework(this.curator).withNamespace(namespace).withServiceName(serviceName).withSerializer(data -> {
            try {
                return objectMapper.writeValueAsBytes((Object)data);
            }
            catch (Exception e) {
                log.warn("Could not parse node data", (Throwable)e);
                return null;
            }
        }).withHostname(hostname).withPort(port).withNodeData((Object)nodeData).withHealthMetricSupplier(healthMetricSupplier).withHealthcheck((Healthcheck)new InternalHealthChecker(this.healthchecks)).withHealthcheck((Healthcheck)new RotationCheck(this.rotationStatus)).withHealthcheck((Healthcheck)new InitialDelayChecker(this.serviceDiscoveryConfiguration.getInitialDelaySeconds())).withHealthcheck((Healthcheck)new DropwizardServerStartupCheck(environment, this.serverStatus)).withIsolatedHealthMonitor((IsolatedHealthMonitor)new DropwizardHealthMonitor(new TimeEntity(initialDelayForMonitor, (long)dwMonitoringInterval, TimeUnit.SECONDS), dwMonitoringStaleness * 1000, environment)).withHealthUpdateIntervalMs(this.serviceDiscoveryConfiguration.getRefreshTimeMs()).withStaleUpdateThresholdMs(10000);
        List<IsolatedHealthMonitor> healthMonitors = this.getHealthMonitors();
        if (healthMonitors != null && !healthMonitors.isEmpty()) {
            healthMonitors.forEach(arg_0 -> ((ServiceProviderBuilder)serviceProviderBuilder).withIsolatedHealthMonitor(arg_0));
        }
        return serviceProviderBuilder.buildServiceDiscovery();
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    public ServiceDiscoveryClient getServiceDiscoveryClient() {
        return this.serviceDiscoveryClient;
    }

    public RotationStatus getRotationStatus() {
        return this.rotationStatus;
    }

    public DropwizardServerStatus getServerStatus() {
        return this.serverStatus;
    }

    private class ServiceDiscoveryManager
    implements Managed {
        private final String serviceName;

        public ServiceDiscoveryManager(String serviceName) {
            this.serviceName = serviceName;
        }

        public void start() throws Exception {
            ServiceDiscoveryBundle.this.curator.start();
            ServiceDiscoveryBundle.this.serviceProvider.start();
            ServiceDiscoveryBundle.this.serviceDiscoveryClient.start();
            NodeIdManager nodeIdManager = new NodeIdManager(ServiceDiscoveryBundle.this.curator, this.serviceName);
            IdGenerator.initialize(nodeIdManager.fixNodeId(), ServiceDiscoveryBundle.this.globalIdConstraints, Collections.emptyMap());
        }

        public void stop() throws Exception {
            ServiceDiscoveryBundle.this.serviceDiscoveryClient.stop();
            ServiceDiscoveryBundle.this.serviceProvider.stop();
            ServiceDiscoveryBundle.this.curator.close();
            IdGenerator.cleanUp();
        }
    }
}

