/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.discovery.bundle.monitors;

import com.flipkart.ranger.healthcheck.Healthcheck;
import com.flipkart.ranger.healthcheck.HealthcheckStatus;
import io.appform.dropwizard.discovery.bundle.rotationstatus.DropwizardServerStatus;
import io.dropwizard.setup.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropwizardServerStartupCheck
implements Healthcheck {
    private static final Logger log = LoggerFactory.getLogger(DropwizardServerStartupCheck.class);
    private final DropwizardServerStatus serverStatus;

    public DropwizardServerStartupCheck(Environment environment, DropwizardServerStatus serverStatus) {
        this.serverStatus = serverStatus;
        environment.lifecycle().addServerLifecycleListener(server -> {
            log.info("Dropwizard server started. Marking healthcheck as healthy");
            serverStatus.markStarted();
        });
    }

    public HealthcheckStatus check() {
        return this.serverStatus.started() ? HealthcheckStatus.healthy : HealthcheckStatus.unhealthy;
    }
}

