/*
 * Decompiled with CFR 0.152.
 */
package io.durg.kirtimukh.dw.demo;

import io.dropwizard.Application;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.durg.kirtimukh.dw.ThrottlingBundle;
import io.durg.kirtimukh.dw.ThrottlingBundleConfiguration;
import io.durg.kirtimukh.dw.demo.AppConfig;
import io.durg.kirtimukh.dw.demo.AppException;
import io.durg.kirtimukh.dw.demo.Evaluator;
import io.durg.kirtimukh.dw.demo.ResponseCode;
import io.durg.kirtimukh.throttling.ThrottlingExceptionTranslator;
import io.durg.kirtimukh.throttling.ThrottlingKey;
import io.durg.kirtimukh.throttling.custom.CustomThrottlingController;
import io.durg.kirtimukh.throttling.custom.GatePass;
import io.durg.kirtimukh.throttling.custom.GatePassStrategyChecker;
import io.durg.kirtimukh.throttling.custom.ThrottlingKeyResolver;
import io.durg.kirtimukh.throttling.custom.ThrottlingKeyType;
import io.durg.kirtimukh.throttling.custom.ThrottlingVerdict;
import io.durg.kirtimukh.throttling.enums.ThrottlingStrategyType;
import io.durg.kirtimukh.throttling.window.impl.CustomThrottlingException;
import java.util.Random;

public class App
extends Application<AppConfig> {
    public void initialize(Bootstrap<AppConfig> bootstrap) {
        bootstrap.addBundle((ConfiguredBundle)new ThrottlingBundle<AppConfig>(){

            protected ThrottlingBundleConfiguration getThrottlingConfiguration(AppConfig appConfig) {
                return appConfig.getThrottlingConfig();
            }

            protected CustomThrottlingController<ThrottlingKeyType> getCustomController() {
                return new CustomThrottlingController<ThrottlingKeyType>((ThrottlingKeyResolver)new ThrottlingKeyResolver<ThrottlingKeyType>(){
                    final Evaluator evaluator = new Evaluator(){
                        final Random random = new Random();

                        @Override
                        public ThrottlingVerdict evaluate(String key) {
                            switch (this.random.nextInt(4)) {
                                case 0: {
                                    return ThrottlingVerdict.DENY;
                                }
                                case 1: {
                                    return ThrottlingVerdict.WAIT;
                                }
                                case 2: {
                                    return ThrottlingVerdict.ACK;
                                }
                            }
                            return ThrottlingVerdict.ALLOW;
                        }
                    };

                    public GatePass<ThrottlingKeyType> resolve(ThrottlingKey bucketKey) {
                        return new GatePass<ThrottlingKeyType>(ThrottlingKeyType.COMMAND, bucketKey.getConfigName()){

                            public ThrottlingVerdict enter() {
                                return evaluator.evaluate(this.getKey());
                            }

                            public long retryAfter() {
                                return 0L;
                            }

                            public void exit() {
                            }
                        };
                    }
                }){

                    public GatePassStrategyChecker<ThrottlingKeyType> checker(GatePass<ThrottlingKeyType> gatePass) {
                        return new GatePassStrategyChecker<ThrottlingKeyType>(gatePass){

                            public void react(ThrottlingVerdict verdict, final GatePass<ThrottlingKeyType> gatePass) {
                                verdict.accept((ThrottlingVerdict.Visitor)new ThrottlingVerdict.Visitor<Void>(){

                                    public Void visitAllow() {
                                        return null;
                                    }

                                    public Void visitDeny() {
                                        throw CustomThrottlingException.builder().keyType((Enum)gatePass.getKeyType()).key(gatePass.getKey()).keyType((Enum)gatePass.getKeyType()).verdict(ThrottlingVerdict.DENY).message("Threshold limits exhausted").build();
                                    }

                                    public Void visitWait() {
                                        throw CustomThrottlingException.builder().keyType((Enum)gatePass.getKeyType()).key(gatePass.getKey()).verdict(ThrottlingVerdict.WAIT).retryAfterMs(gatePass.retryAfter()).graceful(true).message(String.format("Limits exhausted so wait for %s", gatePass.retryAfter())).build();
                                    }

                                    public Void visitAck() {
                                        throw CustomThrottlingException.builder().keyType((Enum)gatePass.getKeyType()).key(gatePass.getKey()).verdict(ThrottlingVerdict.ACK).graceful(true).message("Limits exhausted but request accepted").build();
                                    }
                                });
                            }
                        };
                    }
                };
            }

            protected ThrottlingExceptionTranslator<AppException> getExceptionTranslator() {
                return e -> (AppException)e.getStrategyType().accept((ThrottlingStrategyType.Visitor)new ThrottlingStrategyType.Visitor<AppException>(){

                    public AppException visitQuota() {
                        return AppException.builder().responseCode(ResponseCode.LIMIT_EXCEEDED).message("Limit Exceeded").build();
                    }

                    public AppException visitLeakyBucket() {
                        return AppException.builder().responseCode(ResponseCode.TOO_MANY_REQUESTS).message("Too Many Requests").build();
                    }

                    public AppException visitPriorityBucket() {
                        return AppException.builder().responseCode(ResponseCode.TEMPORARILY_UNAVAILABLE).message("Temporarily Unavailable").build();
                    }

                    public AppException visitCustomStrategy() {
                        return (AppException)((CustomThrottlingException)e).getVerdict().accept((ThrottlingVerdict.Visitor)new ThrottlingVerdict.Visitor<AppException>(){

                            public AppException visitAllow() {
                                return null;
                            }

                            public AppException visitDeny() {
                                return AppException.builder().responseCode(ResponseCode.TEMPORARILY_UNAVAILABLE).message("Temporarily Unavailable").build();
                            }

                            public AppException visitWait() {
                                return AppException.builder().responseCode(ResponseCode.TOO_MANY_REQUESTS).message("Too Many Requests").build();
                            }

                            public AppException visitAck() {
                                return AppException.builder().responseCode(ResponseCode.ACCEPTED).message("Request Accepted").build();
                            }
                        });
                    }
                });
            }
        });
    }

    public void run(AppConfig appConfig, Environment environment) throws Exception {
    }
}

