/*
 * Decompiled with CFR 0.152.
 */
package io.durg.kirtimukh.throttling.window;

import java.util.BitSet;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Window {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Window.class);
    private static final int MIN_BIT_SET_SIZE = 64;
    private final BitSet bitSet;
    private final int threshold;
    private int currentLocation;
    private int cardinality;
    private int maxTicksPerWindow;

    public Window(int threshold) {
        this.threshold = threshold;
        this.maxTicksPerWindow = Window.nPower(threshold);
        this.bitSet = new BitSet(this.maxTicksPerWindow);
    }

    private static int nPower(int number) {
        if (number < 0 || number == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int n = 1;
        while (number >= (n <<= 1)) {
        }
        return Math.max(n, 64);
    }

    private boolean locate(int location) {
        if (this.bitSet.get(location)) {
            return false;
        }
        this.currentLocation = location;
        ++this.cardinality;
        this.bitSet.set(location);
        return true;
    }

    public int cardinality() {
        return this.cardinality;
    }

    public synchronized void clear() {
        this.bitSet.clear();
        this.currentLocation = 0;
        this.cardinality = 0;
    }

    public synchronized boolean remove(int location) {
        this.bitSet.clear(location);
        --this.cardinality;
        return true;
    }

    public synchronized int add() {
        int location;
        int currentRequestCount = this.bitSet.cardinality();
        if (currentRequestCount != this.cardinality) {
            log.warn("Adjusting cardinality from {} to {}", (Object)this.cardinality, (Object)currentRequestCount);
            this.cardinality = currentRequestCount;
        }
        if (currentRequestCount >= this.threshold) {
            return -1;
        }
        do {
            if ((location = this.bitSet.nextClearBit(this.currentLocation)) < this.maxTicksPerWindow) continue;
            this.currentLocation = 0;
            location = 0;
        } while (!this.locate(location));
        return location;
    }

    @Generated
    public static WindowBuilder builder() {
        return new WindowBuilder();
    }

    @Generated
    private Window() {
        this.bitSet = null;
        this.threshold = 0;
    }

    @Generated
    public BitSet getBitSet() {
        return this.bitSet;
    }

    @Generated
    public int getThreshold() {
        return this.threshold;
    }

    @Generated
    public int getCurrentLocation() {
        return this.currentLocation;
    }

    @Generated
    public int getCardinality() {
        return this.cardinality;
    }

    @Generated
    public int getMaxTicksPerWindow() {
        return this.maxTicksPerWindow;
    }

    @Generated
    public void setCurrentLocation(int currentLocation) {
        this.currentLocation = currentLocation;
    }

    @Generated
    public void setCardinality(int cardinality) {
        this.cardinality = cardinality;
    }

    @Generated
    public void setMaxTicksPerWindow(int maxTicksPerWindow) {
        this.maxTicksPerWindow = maxTicksPerWindow;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Window)) {
            return false;
        }
        Window other = (Window)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BitSet this$bitSet = this.getBitSet();
        BitSet other$bitSet = other.getBitSet();
        if (this$bitSet == null ? other$bitSet != null : !((Object)this$bitSet).equals(other$bitSet)) {
            return false;
        }
        if (this.getThreshold() != other.getThreshold()) {
            return false;
        }
        if (this.getCurrentLocation() != other.getCurrentLocation()) {
            return false;
        }
        if (this.getCardinality() != other.getCardinality()) {
            return false;
        }
        return this.getMaxTicksPerWindow() == other.getMaxTicksPerWindow();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Window;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BitSet $bitSet = this.getBitSet();
        result = result * 59 + ($bitSet == null ? 43 : ((Object)$bitSet).hashCode());
        result = result * 59 + this.getThreshold();
        result = result * 59 + this.getCurrentLocation();
        result = result * 59 + this.getCardinality();
        result = result * 59 + this.getMaxTicksPerWindow();
        return result;
    }

    @Generated
    public String toString() {
        return "Window(bitSet=" + this.getBitSet() + ", threshold=" + this.getThreshold() + ", currentLocation=" + this.getCurrentLocation() + ", cardinality=" + this.getCardinality() + ", maxTicksPerWindow=" + this.getMaxTicksPerWindow() + ")";
    }

    @Generated
    public static class WindowBuilder {
        @Generated
        private int threshold;

        @Generated
        WindowBuilder() {
        }

        @Generated
        public WindowBuilder threshold(int threshold) {
            this.threshold = threshold;
            return this;
        }

        @Generated
        public Window build() {
            return new Window(this.threshold);
        }

        @Generated
        public String toString() {
            return "Window.WindowBuilder(threshold=" + this.threshold + ")";
        }
    }
}

